import { Buffer } from "node:buffer";
import * as exposes from "./exposes";
import * as modernExtend from "./modernExtend";
import type { BatteryLinearVoltage, BatteryNonLinearVoltage, Definition, Fz, KeyValue, KeyValueAny, ModernExtend, Range, Tz } from "./types";
declare type Day = "mon" | "tue" | "wed" | "thu" | "fri" | "sat" | "sun";
export interface TrvScheduleConfigEvent {
    time: number;
    temperature: number;
}
export interface TrvScheduleConfig {
    days: Day[];
    events: TrvScheduleConfigEvent[];
}
export declare const buffer2DataObject: (model: Definition, buffer: Buffer) => KeyValue;
export declare const numericAttributes2Payload: (msg: Fz.Message<any, undefined, any>, meta: Fz.Meta, model: Definition, options: KeyValue, dataObject: KeyValue) => Promise<KeyValue>;
type LumiPresenceRegionZone = {
    x: number;
    y: number;
};
declare const lumiPresenceConstants: {
    region_event_key: number;
    region_event_types: {
        Enter: number;
        Leave: number;
        Occupied: number;
        Unoccupied: number;
    };
    region_config_write_attribute: number;
    region_config_write_attribute_type: number;
    region_config_cmds: {
        /**
         * Creates new region (or force replaces existing one)
         * with new zones definition.
         */
        create: number;
        /**
         * Modifies existing region.
         * Note: unused, as it seems to break existing regions
         * (region stops reporting new detection events).
         * Use "create" instead, as it replaces existing region with new one.
         */
        modify: number;
        /**
         * Deletes existing region.
         */
        delete: number;
    };
    region_config_regionId_min: number;
    region_config_regionId_max: number;
    region_config_zoneY_min: number;
    region_config_zoneY_max: number;
    region_config_zoneX_min: number;
    region_config_zoneX_max: number;
    region_config_cmd_suffix_upsert: number;
    region_config_cmd_suffix_delete: number;
};
export declare const presence: {
    constants: {
        region_event_key: number;
        region_event_types: {
            Enter: number;
            Leave: number;
            Occupied: number;
            Unoccupied: number;
        };
        region_config_write_attribute: number;
        region_config_write_attribute_type: number;
        region_config_cmds: {
            /**
             * Creates new region (or force replaces existing one)
             * with new zones definition.
             */
            create: number;
            /**
             * Modifies existing region.
             * Note: unused, as it seems to break existing regions
             * (region stops reporting new detection events).
             * Use "create" instead, as it replaces existing region with new one.
             */
            modify: number;
            /**
             * Deletes existing region.
             */
            delete: number;
        };
        region_config_regionId_min: number;
        region_config_regionId_max: number;
        region_config_zoneY_min: number;
        region_config_zoneY_max: number;
        region_config_zoneX_min: number;
        region_config_zoneX_max: number;
        region_config_cmd_suffix_upsert: number;
        region_config_cmd_suffix_delete: number;
    };
    mappers: {
        lumi_presence: {
            region_event_type_names: {
                [lumiPresenceConstants.region_event_types.Enter]: string;
                [lumiPresenceConstants.region_event_types.Leave]: string;
                [lumiPresenceConstants.region_event_types.Occupied]: string;
                [lumiPresenceConstants.region_event_types.Unoccupied]: string;
            };
        };
    };
    encodeXCellsDefinition: (xCells?: number[]) => number;
    encodeXCellIdx: (cellXIdx: number) => number;
    parseAqaraFp1RegionDeleteInput: (input: KeyValueAny) => {
        isSuccess: false;
        error: {
            reason: string;
        };
    } | {
        isSuccess: boolean;
        payload: {
            command: {
                region_id: number;
            };
        };
    };
    parseAqaraFp1RegionUpsertInput: (input: KeyValueAny) => {
        isSuccess: false;
        error: {
            reason: string;
        };
    } | {
        isSuccess: boolean;
        payload: {
            command: {
                region_id: number;
                zones: LumiPresenceRegionZone[];
            };
        };
    };
    isAqaraFp1RegionId: (value: any) => value is number;
    isAqaraFp1RegionZoneDefinition: (value: any) => value is LumiPresenceRegionZone;
    failure: (error: {
        reason: string;
    }) => {
        isSuccess: false;
        error: {
            reason: string;
        };
    };
};
export declare const trv: {
    decodeFirmwareVersionString(value: number): string;
    decodePreset(value: number): {
        setup: boolean;
        preset: string;
    };
    decodeHeartbeat(meta: Fz.Meta, model: Definition, messageBuffer: Buffer): KeyValue;
    /**
     * Decode a Zigbee schedule configuration message into a schedule configuration object.
     */
    decodeSchedule(buffer: Buffer): TrvScheduleConfig;
    validateSchedule(schedule: TrvScheduleConfig): void;
    /**
     * Encodes a schedule object into Zigbee message format.
     */
    encodeSchedule(schedule: TrvScheduleConfig): Buffer;
    stringifySchedule(schedule: TrvScheduleConfig): string;
    parseSchedule(stringifiedSchedule: string): TrvScheduleConfig;
};
export declare const manufacturerCode = 4447;
export declare const lumiModernExtend: {
    lumiLight: (args?: Omit<modernExtend.LightArgs, "colorTemp"> & {
        colorTemp?: true;
        colorTempRange?: Range;
        powerOutageMemory?: "switch" | "light" | "enum";
        deviceTemperature?: boolean;
        powerOutageCount?: boolean;
    }) => ModernExtend;
    lumiDimmingRangeMin: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiDimmingRangeMax: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiOffOnDuration: (args?: Partial<modernExtend.NumericArgs<"genLevelCtrl">>) => ModernExtend;
    lumiOnOffDuration: (args?: Partial<modernExtend.NumericArgs<"genLevelCtrl">>) => ModernExtend;
    lumiTransitionCurveCurvature: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiTransitionInitialBrightness: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiRGBEffect: (lookup: KeyValue, args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiRGBEffectSpeed: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiRGBEffectColors: () => ModernExtend;
    lumiT1MEffect: () => ModernExtend;
    lumiSegmentColors: () => ModernExtend;
    lumiRGBEffectSegments: () => ModernExtend;
    lumiOnOff: (args?: modernExtend.OnOffArgs & {
        operationMode?: boolean;
        powerOutageMemory?: "binary" | "enum";
        lockRelay?: boolean;
    }) => ModernExtend;
    lumiSwitchType: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiMotorSpeed: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainSpeed: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainManualOpenClose: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainAdaptivePullingSpeed: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainManualStop: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainReverse: (args?: Partial<modernExtend.BinaryArgs<"closuresWindowCovering">>) => ModernExtend;
    lumiCurtainStatus: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainLastManualOperation: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainPosition: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainTraverseTime: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainCalibrationStatus: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainCalibrated: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiCurtainIdentifyBeep: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiPowerOnBehavior: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiPowerOutageMemory: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiOperationMode: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiAction: (args?: Partial<modernExtend.ActionEnumLookupArgs<"genMultistateInput">>) => ModernExtend;
    lumiVoc: (args?: Partial<modernExtend.NumericArgs<"genAnalogInput">>) => ModernExtend;
    lumiAirQuality: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiDisplayUnit: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiOutageCountRestoreBindReporting: () => ModernExtend;
    lumiZigbeeOTA: () => ModernExtend;
    lumiPower: (args?: Partial<modernExtend.NumericArgs<"genAnalogInput">>) => ModernExtend;
    lumiElectricityMeter: () => ModernExtend;
    lumiOverloadProtection: (args?: Partial<modernExtend.NumericArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiLedIndicator: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiLedDisabledNight: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiLedDisabledNightTime: () => {
        isModernExtend: true;
        exposes: exposes.Text[];
        fromZigbee: {
            cluster: string;
            type: string[];
            convert: (model: Definition, msg: Fz.Message<any, any, any>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
                schedule_start_time: string;
                schedule_end_time: string;
                schedule_time_raw: any;
            };
        }[];
        toZigbee: {
            key: string[];
            convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
                state: KeyValue;
            }>;
            convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
        }[];
    };
    lumiButtonLock: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiFlipIndicatorLight: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiPreventReset: () => ModernExtend;
    lumiClickMode: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiSlider: () => ModernExtend;
    lumiLockRelay: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiSetEventMode: () => ModernExtend;
    lumiSwitchMode: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiVibration: () => ModernExtend;
    lumiSensitivityAdjustment: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiReportInterval: (args?: Partial<modernExtend.EnumLookupArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiMiscellaneous: (args?: {
        cluster: "genBasic" | "manuSpecificLumi";
        deviceTemperatureAttribute?: number;
        powerOutageCountAttribute?: number;
        resetsWhenPairing?: boolean;
    }) => ModernExtend;
    lumiKnobRotation: (args?: {
        withButtonState: boolean;
    }) => ModernExtend;
    lumiCommandMode: (args?: {
        setEventMode: boolean;
    }) => ModernExtend;
    lumiBattery: (args?: {
        cluster?: "genBasic" | "manuSpecificLumi";
        voltageToPercentage?: BatteryNonLinearVoltage | BatteryLinearVoltage;
        percentageAtrribute?: number;
        voltageAttribute?: number;
    }) => ModernExtend;
    fp300PIRDetection: () => ModernExtend;
    fp300DetectionRange: (args?: {
        rangeOffset: number;
        rangesCount: number;
    }) => ModernExtend;
    fp300TrackDistance: () => {
        isModernExtend: true;
        exposes: exposes.Enum[];
        toZigbee: {
            key: string[];
            convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        }[];
    };
    fp1eAIInterference: () => ModernExtend;
    fp1eAdaptiveSensitivity: () => ModernExtend;
    fp1ePresence: () => ModernExtend;
    fp1eMovement: () => ModernExtend;
    fp1eTargetDistance: () => ModernExtend;
    fp1eDetectionRange: () => ModernExtend;
    fp1eSpatialLearning: () => {
        isModernExtend: true;
        exposes: exposes.Enum[];
        toZigbee: {
            key: string[];
            convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        }[];
    };
    fp1eRestartDevice: () => {
        isModernExtend: true;
        exposes: exposes.Enum[];
        toZigbee: {
            key: string[];
            convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        }[];
    };
    lumiMultiClick: (args?: Partial<modernExtend.BinaryArgs<"manuSpecificLumi">>) => ModernExtend;
    lumiPreventLeave: () => ModernExtend;
    lumiExternalSensor: () => ModernExtend;
    lumiReadPositionOnReport: (type: "genAnalogOutput" | "genMultistateOutput" | "genBasic") => ModernExtend;
};
export { lumiModernExtend as modernExtend };
export interface W100State {
    system_mode: string;
    occupied_heating_setpoint: number | string;
    fan_mode: string;
    unused: string | number;
    thermostat_mode: string;
}
export declare function w100EnsureDefaults(meta: Fz.Meta | Tz.Meta): W100State;
export declare const fromZigbee: {
    lumi_basic: {
        cluster: "genBasic";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genBasic", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => Promise<KeyValue>;
    };
    lumi_basic_raw: {
        cluster: "genBasic";
        type: ["raw"];
        convert: (model: Definition, msg: Fz.Message<"genBasic", undefined, ["raw"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => Promise<{}>;
    };
    lumi_specific: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => Promise<KeyValue>;
    };
    lumi_co2: {
        cluster: "msCO2";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"msCO2", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            co2: number;
        };
    };
    lumi_pm25: {
        cluster: "pm25Measurement";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"pm25Measurement", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            pm25: number;
        };
    };
    lumi_contact: {
        cluster: "genOnOff";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genOnOff", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            contact: boolean;
        };
    };
    lumi_power: {
        cluster: "genAnalogInput";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genAnalogInput", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            power: number;
        };
    };
    lumi_action: {
        cluster: "genOnOff";
        type: ["attributeReport"];
        convert: (model: Definition, msg: Fz.Message<"genOnOff", undefined, ["attributeReport"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: any;
        };
    };
    lumi_action_multistate: {
        cluster: "genMultistateInput";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genMultistateInput", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
            side: number;
            action_from_side?: undefined;
            action_to_side?: undefined;
            action_side?: undefined;
            from_side?: undefined;
            to_side?: undefined;
        } | {
            action: string;
            action_from_side: number;
            action_to_side: number;
            action_side: number;
            from_side: number;
            to_side: number;
            side: number;
        } | {
            action: string;
            side: number;
            action_from_side: number;
            action_to_side?: undefined;
            action_side?: undefined;
            from_side?: undefined;
            to_side?: undefined;
        } | {
            action: any;
            side?: undefined;
            action_from_side?: undefined;
            action_to_side?: undefined;
            action_side?: undefined;
            from_side?: undefined;
            to_side?: undefined;
        };
    };
    lumi_action_analog: {
        cluster: "genAnalogInput";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genAnalogInput", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_temperature: {
        cluster: "msTemperatureMeasurement";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"msTemperatureMeasurement", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            temperature: number;
        };
    };
    lumi_pressure: {
        cluster: "msPressureMeasurement";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"msPressureMeasurement", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_feeder: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValue;
    };
    lumi_trv: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValue;
    };
    lumi_presence_region_events: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValue;
    };
    lumi_lock_report: {
        cluster: "genBasic";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genBasic", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            keyerror: boolean;
            inserted: string;
            forgotten?: undefined;
        } | {
            keyerror: boolean;
            inserted: number;
            forgotten?: undefined;
        } | {
            inserted: number;
            keyerror?: undefined;
            forgotten?: undefined;
        } | {
            forgotten: number;
            keyerror?: undefined;
            inserted?: undefined;
        };
    };
    lumi_occupancy_illuminance: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        options: (exposes.Numeric | exposes.List)[];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            occupancy: boolean;
            illuminance: number;
        };
    };
    lumi_curtain_position: {
        cluster: "genAnalogOutput";
        type: ["attributeReport", "readResponse"];
        options: exposes.Binary[];
        convert: (model: Definition, msg: Fz.Message<"genAnalogOutput", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            position: number;
            state: string;
        };
    };
    lumi_curtain_position_tilt: {
        cluster: "closuresWindowCovering";
        type: ["attributeReport", "readResponse"];
        options: exposes.Binary[];
        convert: (model: Definition, msg: Fz.Message<"closuresWindowCovering", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_operation_mode_basic: {
        cluster: "genBasic";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genBasic", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_bulb_interval: {
        cluster: "genBasic";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genBasic", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            state: string;
            brightness: number | number[];
            color_temp: number | number[];
        };
    };
    lumi_on_off: {
        cluster: "genOnOff";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genOnOff", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            [x: string]: string;
        };
    };
    lumi_curtain_status: {
        cluster: "genMultistateOutput";
        type: ["attributeReport"];
        convert: (model: Definition, msg: Fz.Message<"genMultistateOutput", undefined, ["attributeReport"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            motor_state: any;
            running: boolean;
        };
    };
    lumi_curtain_options: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            hand_open: boolean;
            reverse_direction?: undefined;
            limits_calibration?: undefined;
        } | {
            reverse_direction: boolean;
            hand_open?: undefined;
            limits_calibration?: undefined;
        } | {
            limits_calibration: string;
            hand_open?: undefined;
            reverse_direction?: undefined;
        };
    };
    lumi_vibration_analog: {
        cluster: "closuresDoorLock";
        type: ["attributeReport", "readResponse"];
        options: exposes.Numeric[];
        convert: (model: Definition, msg: Fz.Message<"closuresDoorLock", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_illuminance: {
        cluster: "msIlluminanceMeasurement";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"msIlluminanceMeasurement", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_occupancy: {
        cluster: "msOccupancySensing";
        type: ["attributeReport", "readResponse"];
        options: (exposes.Numeric | exposes.List)[];
        convert: (model: Definition, msg: Fz.Message<"msOccupancySensing", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            occupancy: boolean;
        };
    };
    lumi_smoke: {
        cluster: "ssIasZone";
        type: "commandStatusChangeNotification";
        convert: (model: Definition, msg: Fz.Message<"ssIasZone", undefined, "commandStatusChangeNotification">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_gas_density: {
        cluster: "genBasic";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genBasic", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            gas_density: number | number[];
        };
    };
    lumi_gas_sensitivity: {
        cluster: "ssIasZone";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"ssIasZone", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            sensitivity: any;
        };
    };
    lumi_door_lock_low_battery: {
        cluster: "genPowerCfg";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"genPowerCfg", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            battery_low: boolean;
        };
    };
    lumi_door_lock_report: {
        cluster: "closuresDoorLock";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"closuresDoorLock", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    lumi_action_on: {
        cluster: "genOnOff";
        type: "commandOn";
        convert: (model: Definition, msg: Fz.Message<"genOnOff", undefined, "commandOn">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
        };
    };
    lumi_action_off: {
        cluster: "genOnOff";
        type: "commandOff";
        convert: (model: Definition, msg: Fz.Message<"genOnOff", undefined, "commandOff">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
        };
    };
    lumi_action_step: {
        cluster: "genLevelCtrl";
        type: "commandStep";
        convert: (model: Definition, msg: Fz.Message<"genLevelCtrl", undefined, "commandStep">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
        };
    };
    lumi_action_stop: {
        cluster: "genLevelCtrl";
        type: "commandStop";
        convert: (model: Definition, msg: Fz.Message<"genLevelCtrl", undefined, "commandStop">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
            action_duration: number;
        };
    };
    lumi_action_move: {
        cluster: "genLevelCtrl";
        type: "commandMove";
        convert: (model: Definition, msg: Fz.Message<"genLevelCtrl", undefined, "commandMove">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
        };
    };
    lumi_action_step_color_temp: {
        cluster: "lightingColorCtrl";
        type: "commandStepColorTemp";
        convert: (model: Definition, msg: Fz.Message<"lightingColorCtrl", undefined, "commandStepColorTemp">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
        };
    };
    lumi_action_move_color_temp: {
        cluster: "lightingColorCtrl";
        type: "commandMoveColorTemp";
        convert: (model: Definition, msg: Fz.Message<"lightingColorCtrl", undefined, "commandMoveColorTemp">, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            action: string;
            duration: number;
            action_duration: number;
        } | {
            action: string;
            duration?: undefined;
            action_duration?: undefined;
        };
    };
    lumi_action_WXKG01LM: {
        cluster: "genOnOff";
        type: ["attributeReport", "readResponse"];
        options: exposes.Numeric[];
        convert: (model: Definition, msg: Fz.Message<"genOnOff", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValueAny, meta: Fz.Meta) => void;
    };
    lumi_smart_panel_ZNCJMB14LM: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => KeyValueAny;
    };
    w100_specific: {
        cluster: "manuSpecificLumi";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"manuSpecificLumi", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => Promise<KeyValue>;
    };
    w100_temperature: {
        cluster: "msTemperatureMeasurement";
        type: ["attributeReport", "readResponse"];
        convert: (model: Definition, msg: Fz.Message<"msTemperatureMeasurement", undefined, ["attributeReport", "readResponse"]>, publish: import("./types").Publish, options: KeyValue, meta: Fz.Meta) => {
            system_mode: string;
            occupied_heating_setpoint: number | string;
            fan_mode: string;
            unused: string | number;
            thermostat_mode: string;
            temperature: any;
            local_temperature: any;
        };
    };
};
export declare const toZigbee: {
    lumi_power: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_led_disabled_night: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                led_disabled_night: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_flip_indicator_light: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                flip_indicator_light: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_power_outage_count: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_feeder: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                [x: string]: unknown;
            };
        }>;
    };
    lumi_detection_distance: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                detection_distance: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_trv: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_presence_region_upsert: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_presence_region_delete: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_cube_operation_mode: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => void;
    };
    lumi_switch_operation_mode_basic: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                operation_mode: any;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_switch_operation_mode_opple: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_detection_interval: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                detection_interval: number;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_overload_protection: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                overload_protection: number;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_switch_mode_switch: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                mode_switch: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_button_switch_mode: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                button_switch_mode: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_socket_button_lock: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                button_lock: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_dimmer_mode: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                dimmer_mode: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_switch_do_not_disturb: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                do_not_disturb: unknown;
            };
        }>;
    };
    lumi_switch_type: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                switch_type: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_switch_power_outage_memory: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                power_outage_memory: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_light_power_outage_memory: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                power_outage_memory: unknown;
            };
        }>;
    };
    lumi_auto_off: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                auto_off: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_detection_period: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                detection_period: number;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_motion_sensitivity: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                motion_sensitivity: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_presence: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_monitoring_mode: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                monitoring_mode: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_approach_distance: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                approach_distance: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_reset_nopresence_status: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_switch_click_mode: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                click_mode: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_switch_lock_relay_opple: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                lock_relay: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_operation_mode_opple: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                operation_mode: string;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_vibration_sensitivity: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                sensitivity: number;
            };
        }>;
    };
    lumi_interlock: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                interlock: unknown;
            };
        }>;
    };
    lumi_curtain_options: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                options: {
                    reverse_direction: boolean;
                    hand_open: boolean;
                    reset_limits: boolean;
                };
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_position_state: {
        key: string[];
        options: exposes.Binary[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                position: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_battery_voltage: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_charging_status: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_battery: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_trigger_indicator: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                trigger_indicator: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_hooks_lock: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                [x: string]: unknown;
            };
        }>;
    };
    lumi_curtain_hooks_state: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_hand_open: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_reverse: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_limits_calibration: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_limits_calibration_ZNCLDJ14LM: {
        key: string[];
        options: exposes.Enum[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_curtain_automatic_calibration_ZNCLDJ01LM: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_buzzer: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_buzzer_manual: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_heartbeat_indicator: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                heartbeat_indicator: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_selftest: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<void>;
    };
    lumi_linkage_alarm: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                linkage_alarm: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_state: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_alarm: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_density: {
        key: string[];
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_sensitivity: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                sensitivity: unknown;
            };
        }>;
    };
    lumi_gas_sensitivity: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                gas_sensitivity: unknown;
            };
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    lumi_smart_panel_ZNCJMB14LM: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: KeyValue;
        }>;
    };
    w100_pmtsd: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                occupied_heating_setpoint: number;
                fan_mode: string;
                system_mode: string;
                unused: string;
            };
        } | {
            state: {};
        }>;
        convertGet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, meta: Tz.Meta) => Promise<void>;
    };
    w100_mode: {
        key: string[];
        convertSet: (entity: import("zigbee-herdsman/dist/controller/model").Group | import("zigbee-herdsman/dist/controller/model").Endpoint, key: string, value: unknown, meta: Tz.Meta) => Promise<{
            state: {
                thermostat_mode: unknown;
                system_mode: string;
                occupied_heating_setpoint: number | string;
                fan_mode: string;
                unused: string | number;
            };
        }>;
    };
};
//# sourceMappingURL=lumi.d.ts.map