/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmAccessor;
import org.apache.tika.parser.microsoft.chm.ChmAssert;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmParsingException;

public class ChmItspHeader
implements ChmAccessor<ChmItspHeader> {
    private static final long serialVersionUID = 1962394421998181341L;
    private byte[] signature;
    private int version;
    private int header_len;
    private int unknown_000c;
    private long block_len;
    private int blockidx_intvl;
    private int index_depth;
    private int index_root;
    private int index_head;
    private int unknown_0024;
    private long num_blocks;
    private int unknown_002c;
    private long lang_id;
    private byte[] system_uuid = new byte[16];
    private byte[] unknown_0044 = new byte[16];
    private int dataRemained;
    private int currentPlace = 0;

    public ChmItspHeader() {
        this.signature = "ITSP".getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ signature:=").append(new String(this.getSignature(), StandardCharsets.UTF_8)).append(System.getProperty("line.separator"));
        sb.append("version:=\t").append(this.getVersion()).append(System.getProperty("line.separator"));
        sb.append("header_len:=\t").append(this.getHeader_len()).append(System.getProperty("line.separator"));
        sb.append("unknown_00c:=\t").append(this.getUnknown_000c()).append(System.getProperty("line.separator"));
        sb.append("block_len:=\t").append(this.getBlock_len()).append(" [directory chunk size]").append(System.getProperty("line.separator"));
        sb.append("blockidx_intvl:=").append(this.getBlockidx_intvl()).append(", density of quickref section, usually 2").append(System.getProperty("line.separator"));
        sb.append("index_depth:=\t").append(this.getIndex_depth()).append(", depth of the index tree - 1 there is no index, 2 if there is one level of PMGI").append(" chunk").append(System.getProperty("line.separator"));
        sb.append("index_root:=\t").append(this.getIndex_root()).append(", chunk number of root index chunk, -1 if there is none").append(System.getProperty("line.separator"));
        sb.append("index_head:=\t").append(this.getIndex_head()).append(", chunk number of first PMGL (listing) chunk").append(System.getProperty("line.separator"));
        sb.append("unknown_0024:=\t").append(this.getUnknown_0024()).append(", chunk number of last PMGL (listing) chunk").append(System.getProperty("line.separator"));
        sb.append("num_blocks:=\t").append(this.getNum_blocks()).append(", -1 (unknown)").append(System.getProperty("line.separator"));
        sb.append("unknown_002c:=\t").append(this.getUnknown_002c()).append(", number of directory chunks (total)").append(System.getProperty("line.separator"));
        sb.append("lang_id:=\t").append(this.getLang_id()).append(" - ").append(ChmCommons.getLanguage(this.getLang_id())).append(System.getProperty("line.separator"));
        sb.append("system_uuid:=").append(Arrays.toString(this.getSystem_uuid())).append(System.getProperty("line.separator"));
        sb.append("unknown_0044:=").append(Arrays.toString(this.getUnknown_0044())).append(" ]");
        return sb.toString();
    }

    private void unmarshalCharArray(byte[] data, ChmItspHeader chmItspHeader, int count) throws TikaException {
        ChmAssert.assertByteArrayNotNull(data);
        ChmAssert.assertChmAccessorNotNull(chmItspHeader);
        this.setDataRemained(data.length);
        System.arraycopy(data, 0, chmItspHeader.signature, 0, count);
        this.setCurrentPlace(this.getCurrentPlace() + count);
        this.setDataRemained(this.getDataRemained() - count);
    }

    private int unmarshalInt32(byte[] data, int dataLenght, int dest) throws TikaException {
        ChmAssert.assertByteArrayNotNull(data);
        if (4 > this.getDataRemained()) {
            throw new TikaException("4 > dataLenght");
        }
        dest = data[this.getCurrentPlace()] & 0xFF | (data[this.getCurrentPlace() + 1] & 0xFF) << 8 | (data[this.getCurrentPlace() + 2] & 0xFF) << 16 | (data[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        this.setDataRemained(this.getDataRemained() - 4);
        return dest;
    }

    private long unmarshalUInt32(byte[] data, int dataLenght, long dest) throws TikaException {
        ChmAssert.assertByteArrayNotNull(data);
        if (4 > dataLenght) {
            throw new TikaException("4 > dataLenght");
        }
        dest = data[this.getCurrentPlace()] & 0xFF | (data[this.getCurrentPlace() + 1] & 0xFF) << 8 | (data[this.getCurrentPlace() + 2] & 0xFF) << 16 | (data[this.getCurrentPlace() + 3] & 0xFF) << 24;
        this.setDataRemained(this.getDataRemained() - 4);
        this.setCurrentPlace(this.getCurrentPlace() + 4);
        return dest;
    }

    private byte[] unmarshalUuid(byte[] data, int dataLenght, byte[] dest, int count) {
        System.arraycopy(data, this.getCurrentPlace(), dest, 0, count);
        this.setCurrentPlace(this.getCurrentPlace() + count);
        this.setDataRemained(this.getDataRemained() - count);
        return dest;
    }

    private int getDataRemained() {
        return this.dataRemained;
    }

    private void setDataRemained(int dataRemained) {
        this.dataRemained = dataRemained;
    }

    private int getCurrentPlace() {
        return this.currentPlace;
    }

    private void setCurrentPlace(int currentPlace) {
        this.currentPlace = currentPlace;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public int getHeader_len() {
        return this.header_len;
    }

    protected void setHeader_len(int header_len) {
        this.header_len = header_len;
    }

    public int getUnknown_000c() {
        return this.unknown_000c;
    }

    protected void setUnknown_000c(int unknown_000c) {
        this.unknown_000c = unknown_000c;
    }

    public long getBlock_len() {
        return this.block_len;
    }

    protected void setBlock_len(long block_len) {
        this.block_len = block_len;
    }

    public int getBlockidx_intvl() {
        return this.blockidx_intvl;
    }

    protected void setBlockidx_intvl(int blockidx_intvl) {
        this.blockidx_intvl = blockidx_intvl;
    }

    public int getIndex_depth() {
        return this.index_depth;
    }

    protected void setIndex_depth(int index_depth) {
        this.index_depth = index_depth;
    }

    public int getIndex_root() {
        return this.index_root;
    }

    protected void setIndex_root(int index_root) {
        this.index_root = index_root;
    }

    public int getIndex_head() {
        return this.index_head;
    }

    protected void setIndex_head(int index_head) {
        this.index_head = index_head;
    }

    public int getUnknown_0024() {
        return this.unknown_0024;
    }

    protected void setUnknown_0024(int unknown_0024) {
        this.unknown_0024 = unknown_0024;
    }

    public long getNum_blocks() {
        return this.num_blocks;
    }

    protected void setNum_blocks(long num_blocks) {
        this.num_blocks = num_blocks;
    }

    public int getUnknown_002c() {
        return this.unknown_002c;
    }

    protected void setUnknown_002c(int unknown_002c) {
        this.unknown_002c = unknown_002c;
    }

    public long getLang_id() {
        return this.lang_id;
    }

    protected void setLang_id(long lang_id) {
        this.lang_id = lang_id;
    }

    public byte[] getSystem_uuid() {
        return this.system_uuid;
    }

    protected void setSystem_uuid(byte[] system_uuid) {
        this.system_uuid = system_uuid;
    }

    public byte[] getUnknown_0044() {
        return this.unknown_0044;
    }

    protected void setUnknown_0044(byte[] unknown_0044) {
        this.unknown_0044 = unknown_0044;
    }

    @Override
    public void parse(byte[] data, ChmItspHeader chmItspHeader) throws TikaException {
        if (data.length != 84) {
            throw new ChmParsingException("we only know how to deal with the 0x58 and 0x60 byte structures");
        }
        chmItspHeader.unmarshalCharArray(data, chmItspHeader, 4);
        chmItspHeader.setVersion(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getVersion()));
        chmItspHeader.setHeader_len(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getHeader_len()));
        chmItspHeader.setUnknown_000c(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_000c()));
        chmItspHeader.setBlock_len(chmItspHeader.unmarshalUInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getBlock_len()));
        chmItspHeader.setBlockidx_intvl(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getBlockidx_intvl()));
        chmItspHeader.setIndex_depth(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getIndex_depth()));
        chmItspHeader.setIndex_root(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getIndex_root()));
        chmItspHeader.setIndex_head(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getIndex_head()));
        chmItspHeader.setUnknown_0024(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_0024()));
        chmItspHeader.setNum_blocks(chmItspHeader.unmarshalUInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getNum_blocks()));
        chmItspHeader.setUnknown_002c(chmItspHeader.unmarshalInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_002c()));
        chmItspHeader.setLang_id(chmItspHeader.unmarshalUInt32(data, chmItspHeader.getDataRemained(), chmItspHeader.getLang_id()));
        chmItspHeader.setSystem_uuid(chmItspHeader.unmarshalUuid(data, chmItspHeader.getDataRemained(), chmItspHeader.getSystem_uuid(), 16));
        chmItspHeader.setUnknown_0044(chmItspHeader.unmarshalUuid(data, chmItspHeader.getDataRemained(), chmItspHeader.getUnknown_0044(), 16));
        if (!new String(chmItspHeader.getSignature(), StandardCharsets.UTF_8).equals("ITSP")) {
            throw new ChmParsingException("seems not valid signature");
        }
        if (chmItspHeader.getVersion() != 1) {
            throw new ChmParsingException("!=ChmConstants.CHM_VER_1");
        }
        if (chmItspHeader.getHeader_len() != 84) {
            throw new ChmParsingException("!= ChmConstants.CHM_ITSP_V1_LEN");
        }
    }
}

