/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model.metric;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.rollup.model.metric.Metric;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/metric/Cardinality;", "Lorg/opensearch/indexmanagement/rollup/model/metric/Metric;", "precisionThreshold", "", "<init>", "(J)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getPrecisionThreshold", "()J", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "opensearch-index-management"})
public final class Cardinality
extends Metric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long precisionThreshold;
    public static final float MAX_LOAD_FACTOR = 0.75f;
    public static final long DEFAULT_PRECISION_THRESHOLD = 3000L;
    @NotNull
    public static final String PRECISION_THRESHOLD_FIELD = "precision_threshold";

    public Cardinality(long precisionThreshold) {
        super(Metric.Type.CARDINALITY);
        this.precisionThreshold = precisionThreshold;
        if (!(this.precisionThreshold > 0L)) {
            boolean bl = false;
            String string = "Precision threshold must be positive, got: " + this.precisionThreshold;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ Cardinality(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 3000L;
        }
        this(l);
    }

    public final long getPrecisionThreshold() {
        return this.precisionThreshold;
    }

    public Cardinality(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        this(sin.readVLong());
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().startObject(Metric.Type.CARDINALITY.getType());
        if (this.precisionThreshold != 3000L) {
            builder.field(PRECISION_THRESHOLD_FIELD, this.precisionThreshold);
        }
        XContentBuilder xContentBuilder = builder.endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeVLong(this.precisionThreshold);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.rollup.model.metric.Cardinality");
        Cardinality cfr_ignored_0 = (Cardinality)other;
        return this.precisionThreshold == ((Cardinality)other).precisionThreshold;
    }

    public int hashCode() {
        return Long.hashCode(this.precisionThreshold);
    }

    @NotNull
    public String toString() {
        return "Cardinality(precisionThreshold=" + this.precisionThreshold + ")";
    }

    public Cardinality() {
        this(0L, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/metric/Cardinality$Companion;", "", "<init>", "()V", "MAX_LOAD_FACTOR", "", "DEFAULT_PRECISION_THRESHOLD", "", "PRECISION_THRESHOLD_FIELD", "", "precisionFromThreshold", "", "count", "parse", "Lorg/opensearch/indexmanagement/rollup/model/metric/Cardinality;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public final int precisionFromThreshold(long count) {
            long hashTableEntries = (long)Math.ceil((double)count / 0.75);
            int precision = PackedInts.bitsRequired((long)(hashTableEntries * (long)4));
            precision = Math.max(precision, 4);
            precision = Math.min(precision, 18);
            return precision;
        }

        @NotNull
        public final Cardinality parse(@NotNull XContentParser xcp) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            long precisionThreshold = 3000L;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (Intrinsics.areEqual((Object)fieldName, (Object)Cardinality.PRECISION_THRESHOLD_FIELD)) {
                    precisionThreshold = xcp.longValue();
                    continue;
                }
                throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in cardinality metric");
            }
            return new Cardinality(precisionThreshold);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

