/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.opensearch.sql.calcite.plan.rel.Dedup;

public class OpenSearchRelFieldTrimmer
extends RelFieldTrimmer {
    public OpenSearchRelFieldTrimmer(@Nullable SqlValidator validator, RelBuilder relBuilder) {
        super(validator, relBuilder);
    }

    public RelFieldTrimmer.TrimResult trimFields(Dedup dedup, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = dedup.getRowType();
        int fieldCount = rowType.getFieldCount();
        List<RexNode> dedupFields = dedup.getDedupeFields();
        RelNode input = dedup.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields, fieldsUsed);
        inputFinder.visitEach(dedup.getDedupeFields());
        ImmutableBitSet inputFieldsUsed = inputFinder.build();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild((RelNode)dedup, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result((RelNode)dedup, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, new RelNode[]{newInput});
        List newDedupFields = shuttle.visitList(dedupFields);
        return this.result((RelNode)dedup.copy(newInput, newDedupFields), inputMapping);
    }
}

