/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.lucene.store.InputStreamIndexInput;

public class RemoteIndexOutput
extends IndexOutput {
    protected final BlobContainer blobContainer;

    public RemoteIndexOutput(String name, BlobContainer blobContainer) {
        super(name, name);
        this.blobContainer = blobContainer;
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (input instanceof IndexInput) : "input should be instance of IndexInput";
        this.blobContainer.writeBlob(this.getName(), new InputStreamIndexInput((IndexInput)input, numBytes), numBytes, false);
    }

    public void close() throws IOException {
    }

    public void writeByte(byte b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(byte[] byteArray, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getFilePointer() {
        throw new UnsupportedOperationException();
    }

    public long getChecksum() throws IOException {
        throw new UnsupportedOperationException();
    }
}

