/**
 * Synchronises Matrix `m.policy.rule` events with the bridge to filter specific
 * users from using the service.
 */
import { Intent, MatrixUser, WeakStateEvent } from "matrix-appservice-bridge";
export interface MatrixBanSyncConfig {
    rooms: string[];
}
export declare class MatrixBanSync {
    private config;
    private bannedEntites;
    private subscribedRooms;
    constructor(config: MatrixBanSyncConfig);
    syncRules(intent: Intent): Promise<void>;
    /**
     * Is the given room considered part of the bridge's ban list set.
     * @param roomId A Matrix room ID.
     * @returns true if state should be handled from the room, false otherwise.
     */
    isTrackingRoomState(roomId: string): boolean;
    /**
     * Checks to see if the incoming state is a recommendation entry.
     * @param evt A Matrix state event. Unknown state events will be filtered out.
     * @param roomId The Matrix roomID where the event came from.
     * @returns `true` if the event was a new ban, and existing clients should be checked. `false` otherwise.
     */
    handleIncomingState(evt: WeakStateEvent, roomId: string): boolean;
    /**
     * Check if a user is banned by via a ban list.
     * @param user A userId string or a MatrixUser object.
     * @returns Either a string reason for the ban, or false if the user was not banned.
     */
    isUserBanned(user: MatrixUser | string): string | false;
    /**
     * Should be called when the bridge config has been updated.
     * @param config The new config.
     * @param intent The bot user intent.
     */
    updateConfig(config: MatrixBanSyncConfig, intent: Intent): Promise<void>;
}
