/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import jakarta.persistence.FetchType;
import java.util.LinkedHashSet;
import org.hibernate.annotations.FetchMode;
import org.hibernate.mapping.MetadataSource;

public class FetchProfile {
    private final String name;
    private final MetadataSource source;
    private final LinkedHashSet<Fetch> fetches = new LinkedHashSet();

    public FetchProfile(String name, MetadataSource source) {
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public MetadataSource getSource() {
        return this.source;
    }

    public LinkedHashSet<Fetch> getFetches() {
        return this.fetches;
    }

    public void addFetch(Fetch fetch) {
        this.fetches.add(fetch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (this == that) return true;
        if (!(that instanceof FetchProfile)) return false;
        FetchProfile profile = (FetchProfile)that;
        if (!this.name.equals(profile.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class Fetch {
        private final String entity;
        private final String association;
        private final FetchMode method;
        private final FetchType type;

        public Fetch(String entity, String association, FetchMode method, FetchType type) {
            this.entity = entity;
            this.association = association;
            this.method = method;
            this.type = type;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getAssociation() {
            return this.association;
        }

        public FetchMode getMethod() {
            return this.method;
        }

        public FetchType getType() {
            return this.type;
        }
    }
}

