/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.sql.PreparedStatement;
import java.util.List;
import org.hibernate.StaleStateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.ast.spi.SqlAstTranslatorWithUpsert;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.DeleteOrUpsertOperation;
import org.hibernate.sql.model.jdbc.UpsertOperation;

public class SqlAstTranslatorWithOnDuplicateKeyUpdate<T extends JdbcOperation>
extends SqlAstTranslatorWithUpsert<T> {
    public SqlAstTranslatorWithOnDuplicateKeyUpdate(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public MutationOperation createMergeOperation(OptionalTableUpdate optionalTableUpdate) {
        assert (optionalTableUpdate.getNumberOfOptimisticLockBindings() == 0);
        this.renderUpsertStatement(optionalTableUpdate);
        UpsertOperation upsertOperation = new UpsertOperation(optionalTableUpdate.getMutatingTable().getTableMapping(), optionalTableUpdate.getMutationTarget(), this.getSql(), new MySQLRowCountExpectation(), this.getParameterBinders());
        return new DeleteOrUpsertOperation(optionalTableUpdate.getMutationTarget(), (EntityTableMapping)optionalTableUpdate.getMutatingTable().getTableMapping(), upsertOperation, optionalTableUpdate);
    }

    @Override
    protected void renderUpsertStatement(OptionalTableUpdate optionalTableUpdate) {
        this.renderInsertInto(optionalTableUpdate);
        this.appendSql(" ");
        this.renderOnDuplicateKeyUpdate(optionalTableUpdate);
    }

    protected void renderInsertInto(OptionalTableUpdate optionalTableUpdate) {
        if (optionalTableUpdate.getValueBindings().isEmpty()) {
            this.appendSql("insert ignore into ");
        } else {
            this.appendSql("insert into ");
        }
        this.appendSql(optionalTableUpdate.getMutatingTable().getTableName());
        this.appendSql(" ");
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        int separator = 40;
        for (ColumnValueBinding keyBinding : keyBindings) {
            this.appendSql((char)separator);
            this.appendSql(keyBinding.getColumnReference().getColumnExpression());
            separator = 44;
        }
        optionalTableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
            this.appendSql(',');
            this.appendSql(columnValueBinding.getColumnReference().getColumnExpression());
        });
        this.appendSql(") values ");
        separator = 40;
        for (ColumnValueBinding keyBinding : keyBindings) {
            this.appendSql((char)separator);
            keyBinding.getValueExpression().accept(this);
            separator = 44;
        }
        optionalTableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
            this.appendSql(',');
            columnValueBinding.getValueExpression().accept(this);
        });
        this.appendSql(") ");
        this.renderNewRowAlias();
    }

    protected void renderNewRowAlias() {
    }

    protected void renderOnDuplicateKeyUpdate(OptionalTableUpdate optionalTableUpdate) {
        if (!optionalTableUpdate.getValueBindings().isEmpty()) {
            this.appendSql("on duplicate key update ");
            optionalTableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
                String columnName = columnValueBinding.getColumnReference().getColumnExpression();
                if (columnPosition > 0) {
                    this.appendSql(',');
                }
                this.appendSql(columnName);
                this.append(" = ");
                this.renderUpdatevalue((ColumnValueBinding)columnValueBinding);
            });
        }
    }

    @Deprecated(forRemoval=true)
    protected void renderUpdatevalue(ColumnValueBinding columnValueBinding) {
        this.renderUpdateValue(columnValueBinding);
    }

    protected void renderUpdateValue(ColumnValueBinding columnValueBinding) {
    }

    private static class MySQLRowCountExpectation
    implements Expectation {
        private MySQLRowCountExpectation() {
        }

        @Override
        public final void verifyOutcome(int rowCount, PreparedStatement statement, int batchPosition, String sql) {
            if (rowCount > 2) {
                throw new StaleStateException("Unexpected row count (the expected row count for an ON DUPLICATE KEY UPDATE statement should be either 0, 1 or 2 ) [" + sql + "]");
            }
        }
    }
}

