/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitAnyDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitAnyKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitConstraintNameSource;
import org.hibernate.boot.model.naming.ImplicitDiscriminatorColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitIdentifierColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitIndexNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitMapKeyColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitTenantIdColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.naming.NamingHelper;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.internal.util.StringHelper;

public class ImplicitNamingStrategyJpaCompliantImpl
implements ImplicitNamingStrategy,
Serializable {
    public static final ImplicitNamingStrategy INSTANCE = new ImplicitNamingStrategyJpaCompliantImpl();

    @Override
    public Identifier determinePrimaryTableName(ImplicitEntityNameSource source) {
        assert (source != null);
        String tableName = this.transformEntityName(source.getEntityNaming());
        if (tableName == null) {
            throw new HibernateException("Could not determine primary table name for entity: " + source.getEntityNaming().getClassName());
        }
        return this.toIdentifier(tableName, source.getBuildingContext());
    }

    protected String transformEntityName(EntityNaming entityNaming) {
        return StringHelper.isNotEmpty(entityNaming.getJpaEntityName()) ? entityNaming.getJpaEntityName() : StringHelper.unqualify(entityNaming.getEntityName());
    }

    @Override
    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        String name = source.getOwningPhysicalTableName() + "_" + source.getNonOwningPhysicalTableName();
        return this.toIdentifier(name, source.getBuildingContext());
    }

    @Override
    public Identifier determineCollectionTableName(ImplicitCollectionTableNameSource source) {
        String name = this.transformEntityName(source.getOwningEntityNaming()) + "_" + this.transformAttributePath(source.getOwningAttributePath());
        return this.toIdentifier(name, source.getBuildingContext());
    }

    @Override
    public Identifier determineIdentifierColumnName(ImplicitIdentifierColumnNameSource source) {
        return this.toIdentifier(this.transformAttributePath(source.getIdentifierAttributePath()), source.getBuildingContext());
    }

    @Override
    public Identifier determineDiscriminatorColumnName(ImplicitDiscriminatorColumnNameSource source) {
        MetadataBuildingContext context = source.getBuildingContext();
        return this.toIdentifier(context.getEffectiveDefaults().getDefaultDiscriminatorColumnName(), context);
    }

    @Override
    public Identifier determineTenantIdColumnName(ImplicitTenantIdColumnNameSource source) {
        MetadataBuildingContext context = source.getBuildingContext();
        return this.toIdentifier(context.getEffectiveDefaults().getDefaultTenantIdColumnName(), context);
    }

    @Override
    public Identifier determineBasicColumnName(ImplicitBasicColumnNameSource source) {
        return this.toIdentifier(this.transformAttributePath(source.getAttributePath()), source.getBuildingContext());
    }

    @Override
    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        String referencingPropertyOrEntity = source.getNature() == ImplicitJoinColumnNameSource.Nature.ELEMENT_COLLECTION || source.getAttributePath() == null ? this.transformEntityName(source.getEntityNaming()) : this.transformAttributePath(source.getAttributePath());
        String referencedColumnName = source.getReferencedColumnName().getText();
        String name = referencingPropertyOrEntity + "_" + referencedColumnName;
        return this.toIdentifier(name, source.getBuildingContext());
    }

    @Override
    public Identifier determinePrimaryKeyJoinColumnName(ImplicitPrimaryKeyJoinColumnNameSource source) {
        return source.getReferencedPrimaryKeyColumnName();
    }

    @Override
    public Identifier determineAnyDiscriminatorColumnName(ImplicitAnyDiscriminatorColumnNameSource source) {
        MetadataBuildingContext context = source.getBuildingContext();
        return this.toIdentifier(this.transformAttributePath(source.getAttributePath()) + "_" + context.getEffectiveDefaults().getDefaultDiscriminatorColumnName(), context);
    }

    @Override
    public Identifier determineAnyKeyColumnName(ImplicitAnyKeyColumnNameSource source) {
        MetadataBuildingContext context = source.getBuildingContext();
        return this.toIdentifier(this.transformAttributePath(source.getAttributePath()) + "_" + context.getEffectiveDefaults().getDefaultIdColumnName(), context);
    }

    @Override
    public Identifier determineMapKeyColumnName(ImplicitMapKeyColumnNameSource source) {
        return this.toIdentifier(this.transformAttributePath(source.getPluralAttributePath()) + "_KEY", source.getBuildingContext());
    }

    @Override
    public Identifier determineListIndexColumnName(ImplicitIndexColumnNameSource source) {
        return this.toIdentifier(this.transformAttributePath(source.getPluralAttributePath()) + "_ORDER", source.getBuildingContext());
    }

    @Override
    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        Identifier userProvidedIdentifier = source.getUserProvidedIdentifier();
        return userProvidedIdentifier == null ? this.generateConstraintName(source) : userProvidedIdentifier;
    }

    @Override
    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        Identifier userProvidedIdentifier = source.getUserProvidedIdentifier();
        return userProvidedIdentifier == null ? this.generateConstraintName(source) : userProvidedIdentifier;
    }

    @Override
    public Identifier determineIndexName(ImplicitIndexNameSource source) {
        Identifier userProvidedIdentifier = source.getUserProvidedIdentifier();
        return userProvidedIdentifier == null ? this.generateConstraintName(source) : userProvidedIdentifier;
    }

    protected String transformAttributePath(AttributePath attributePath) {
        return attributePath.getProperty();
    }

    protected Identifier toIdentifier(String stringForm, MetadataBuildingContext buildingContext) {
        return this.toIdentifier(stringForm, buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper());
    }

    protected Identifier toIdentifier(String stringForm, IdentifierHelper identifierHelper) {
        return identifierHelper.toIdentifier(stringForm);
    }

    protected Identifier generateConstraintName(ImplicitConstraintNameSource source) {
        return this.toIdentifier(this.generateConstraintNameString(source), source.getBuildingContext());
    }

    protected String generateConstraintNameString(ImplicitConstraintNameSource source) {
        String string;
        NamingHelper namingHelper = this.namingHelper(source.getBuildingContext());
        String prefix = this.constraintNamePrefix(source.kind());
        if (source instanceof ImplicitForeignKeyNameSource) {
            ImplicitForeignKeyNameSource foreignKeySource = (ImplicitForeignKeyNameSource)source;
            string = namingHelper.generateHashedFkName(prefix, source.getTableName(), foreignKeySource.getReferencedTableName(), source.getColumnNames());
        } else {
            string = namingHelper.generateHashedConstraintName(prefix, source.getTableName(), source.getColumnNames());
        }
        return string;
    }

    protected NamingHelper namingHelper(MetadataBuildingContext context) {
        return NamingHelper.withCharset(context.getBuildingOptions().getSchemaCharset());
    }

    protected String constraintNamePrefix(ImplicitConstraintNameSource.Kind kind) {
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case ImplicitConstraintNameSource.Kind.INDEX -> "IDX";
            case ImplicitConstraintNameSource.Kind.UNIQUE_KEY -> "UK";
            case ImplicitConstraintNameSource.Kind.FOREIGN_KEY -> "FK";
        };
    }
}

