/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowStepProvider;
import org.keycloak.representations.workflows.WorkflowStepRepresentation;

public class Workflow {
    private final String id;
    private final RealmModel realm;
    private final KeycloakSession session;
    private MultivaluedHashMap<String, String> config;
    private String notBefore;

    public Workflow(KeycloakSession session, ComponentModel c) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.id = c.getId();
        this.config = c.getConfig();
    }

    public Workflow(KeycloakSession session, String id, Map<String, List<String>> config) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.id = id;
        MultivaluedHashMap c = new MultivaluedHashMap();
        config.forEach((arg_0, arg_1) -> ((MultivaluedHashMap)c).addAll(arg_0, arg_1));
        this.config = c;
    }

    public String getId() {
        return this.id;
    }

    public MultivaluedHashMap<String, String> getConfig() {
        return this.config;
    }

    public String getName() {
        return this.config != null ? (String)this.config.getFirst((Object)"name") : null;
    }

    public boolean isEnabled() {
        return this.config != null && Boolean.parseBoolean((String)this.config.getFirstOrDefault((Object)"enabled", (Object)"true"));
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String notBefore) {
        this.notBefore = notBefore;
    }

    public void setEnabled(boolean enabled) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.putSingle((Object)"enabled", (Object)String.valueOf(enabled));
    }

    public void setError(String message) {
        if (this.config == null) {
            this.config = new MultivaluedHashMap();
        }
        this.config.putSingle((Object)"error", (Object)message);
    }

    public void updateConfig(MultivaluedHashMap<String, String> config, List<WorkflowStepRepresentation> steps) {
        ComponentModel component = this.getWorkflowComponent(this.id, WorkflowProvider.class.getName());
        component.setConfig(config);
        this.realm.updateComponent(component);
        if (steps != null) {
            steps.forEach(step -> {
                ComponentModel stepComponent = this.getWorkflowComponent(step.getId(), WorkflowStepProvider.class.getName());
                stepComponent.setConfig(step.getConfig());
                this.realm.updateComponent(stepComponent);
            });
        }
    }

    public Stream<WorkflowStep> getSteps() {
        return this.realm.getComponentsStream(this.getId(), WorkflowStepProvider.class.getName()).map(c -> new WorkflowStep(this.session, (ComponentModel)c)).sorted();
    }

    public Stream<WorkflowStep> getSteps(String stepId) {
        boolean[] startAdding = new boolean[]{stepId == null};
        return this.getSteps().filter(step -> {
            if (startAdding[0]) {
                return true;
            }
            if (step.getId().equals(stepId)) {
                startAdding[0] = true;
                return true;
            }
            return false;
        });
    }

    public WorkflowStep getStepById(String id) {
        return this.getSteps().filter(s -> s.getId().equals(id)).findAny().orElse(null);
    }

    public void addSteps(List<WorkflowStepRepresentation> steps) {
        steps = Optional.ofNullable(steps).orElse(List.of());
        for (int i = 0; i < steps.size(); ++i) {
            WorkflowStep step = this.toModel((WorkflowStepRepresentation)steps.get(i));
            step.setPriority(i + 1);
            this.addStep(step);
        }
    }

    private void addStep(WorkflowStep step) {
        ComponentModel workflowModel = this.realm.getComponent(this.getId());
        if (workflowModel == null) {
            throw new ModelValidationException("Workflow with id '%s' not found.".formatted(this.getId()));
        }
        ComponentModel stepModel = new ComponentModel();
        stepModel.setId(step.getId());
        stepModel.setParentId(workflowModel.getId());
        stepModel.setProviderId(step.getProviderId());
        stepModel.setProviderType(WorkflowStepProvider.class.getName());
        stepModel.setConfig(step.getConfig());
        this.realm.addComponentModel(stepModel);
    }

    private WorkflowStep toModel(WorkflowStepRepresentation rep) {
        return new WorkflowStep(rep.getUses(), (MultivaluedHashMap<String, String>)rep.getConfig());
    }

    private ComponentModel getWorkflowComponent(String id, String providerType) {
        ComponentModel component = this.realm.getComponent(id);
        if (component == null || !Objects.equals(providerType, component.getProviderType())) {
            throw new BadRequestException("Not a valid resource workflow: " + id);
        }
        return component;
    }
}

