/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx;

import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.smallrye.mutiny.vertx.impl.WriteStreamSubscriberImpl;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.streams.WriteStream;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class MutinyHelper {
    public static Executor executor(Vertx vertx) {
        return command -> vertx.runOnContext(v -> command.run());
    }

    public static Executor executor(Context context) {
        return command -> context.runOnContext(v -> command.run());
    }

    public static Executor blockingExecutor(Vertx vertx) {
        return command -> vertx.executeBlocking(fut -> {
            command.run();
            fut.complete();
        }, null);
    }

    public static Executor blockingExecutor(Vertx vertx, boolean ordered) {
        return command -> vertx.executeBlocking(fut -> {
            command.run();
            fut.complete();
        }, ordered, null);
    }

    public static Executor blockingExecutor(WorkerExecutor worker) {
        return command -> worker.executeBlocking(fut -> {
            command.run();
            fut.complete();
        }, null);
    }

    public static Class unwrap(Class<?> type) {
        MutinyGen gen;
        if (type != null && (gen = type.getAnnotation(MutinyGen.class)) != null) {
            return gen.value();
        }
        return type;
    }

    public static <BARE, MUTINY> Handler<BARE> convertHandler(Handler<MUTINY> mutinyHandler, Function<BARE, MUTINY> mapper) {
        if (mutinyHandler instanceof MutinyDelegate) {
            MutinyDelegate mutinyDelegate = (MutinyDelegate)mutinyHandler;
            return (Handler)mutinyDelegate.getDelegate();
        }
        return new DelegatingHandler<BARE, MUTINY>(mutinyHandler, mapper);
    }

    public static <T> Handler<T> convertConsumer(Consumer<T> mutinyConsumer) {
        if (mutinyConsumer instanceof MutinyDelegate) {
            return (Handler)mutinyConsumer;
        }
        return mutinyConsumer != null ? new DelegatingConsumerHandler<T>(mutinyConsumer) : null;
    }

    public static <T> WriteStreamSubscriber<T> toSubscriber(WriteStream<T> stream) {
        return MutinyHelper.toSubscriber(stream, Function.identity());
    }

    public static <R, T> WriteStreamSubscriber<R> toSubscriber(WriteStream<T> stream, Function<R, T> mapping) {
        return new WriteStreamSubscriberImpl<R, T>(stream, mapping);
    }
}

