/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.streams.TasksTupleWithEpochs;

public record TasksTuple(Map<String, Set<Integer>> activeTasks, Map<String, Set<Integer>> standbyTasks, Map<String, Set<Integer>> warmupTasks) {
    public static final TasksTuple EMPTY = new TasksTuple(Map.of(), Map.of(), Map.of());

    public TasksTuple {
        activeTasks = Collections.unmodifiableMap(Objects.requireNonNull(activeTasks));
        standbyTasks = Collections.unmodifiableMap(Objects.requireNonNull(standbyTasks));
        warmupTasks = Collections.unmodifiableMap(Objects.requireNonNull(warmupTasks));
    }

    public boolean isEmpty() {
        return this.activeTasks.isEmpty() && this.standbyTasks.isEmpty() && this.warmupTasks.isEmpty();
    }

    public boolean containsAny(TasksTupleWithEpochs other) {
        return this.activeTasks.entrySet().stream().anyMatch(entry -> other.activeTasksWithEpochs().containsKey(entry.getKey()) && !Collections.disjoint((Collection)entry.getValue(), other.activeTasksWithEpochs().get(entry.getKey()).keySet())) || this.standbyTasks.entrySet().stream().anyMatch(entry -> other.standbyTasks().containsKey(entry.getKey()) && !Collections.disjoint((Collection)entry.getValue(), (Collection)other.standbyTasks().get(entry.getKey()))) || this.warmupTasks.entrySet().stream().anyMatch(entry -> other.warmupTasks().containsKey(entry.getKey()) && !Collections.disjoint((Collection)entry.getValue(), (Collection)other.warmupTasks().get(entry.getKey())));
    }

    public static TasksTuple fromTargetAssignmentRecord(StreamsGroupTargetAssignmentMemberValue record) {
        return new TasksTuple(record.activeTasks().stream().collect(Collectors.toMap(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId, taskId -> new HashSet<Integer>(taskId.partitions()))), record.standbyTasks().stream().collect(Collectors.toMap(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId, taskId -> new HashSet<Integer>(taskId.partitions()))), record.warmupTasks().stream().collect(Collectors.toMap(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId, taskId -> new HashSet<Integer>(taskId.partitions()))));
    }

    @Override
    public String toString() {
        return "(active=" + TasksTuple.taskAssignmentToString(this.activeTasks) + ", standby=" + TasksTuple.taskAssignmentToString(this.standbyTasks) + ", warmup=" + TasksTuple.taskAssignmentToString(this.warmupTasks) + ")";
    }

    public static TasksTuple fromHeartbeatRequest(List<StreamsGroupHeartbeatRequestData.TaskIds> ownedActiveTasks, List<StreamsGroupHeartbeatRequestData.TaskIds> ownedStandbyTasks, List<StreamsGroupHeartbeatRequestData.TaskIds> ownedWarmupTasks) {
        return new TasksTuple(ownedActiveTasks.stream().collect(Collectors.toMap(StreamsGroupHeartbeatRequestData.TaskIds::subtopologyId, taskId -> new HashSet(taskId.partitions()))), ownedStandbyTasks.stream().collect(Collectors.toMap(StreamsGroupHeartbeatRequestData.TaskIds::subtopologyId, taskId -> new HashSet(taskId.partitions()))), ownedWarmupTasks.stream().collect(Collectors.toMap(StreamsGroupHeartbeatRequestData.TaskIds::subtopologyId, taskId -> new HashSet(taskId.partitions()))));
    }

    static String taskAssignmentToString(Map<String, Set<Integer>> assignment) {
        StringBuilder builder = new StringBuilder("[");
        Object[] subtopologyIds = assignment.keySet().toArray(new String[0]);
        Arrays.sort(subtopologyIds);
        boolean first = true;
        for (Object subtopologyId : subtopologyIds) {
            Set<Integer> partitions = assignment.get(subtopologyId);
            Object[] partitionIds = partitions.toArray(new Integer[0]);
            Arrays.sort(partitionIds);
            for (Object partitionId : partitionIds) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append((String)subtopologyId);
                builder.append("-");
                builder.append(partitionId);
                first = false;
            }
        }
        builder.append("]");
        return builder.toString();
    }
}

