/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.GroupAssignment;
import org.apache.kafka.coordinator.group.api.assignor.GroupSpec;
import org.apache.kafka.coordinator.group.api.assignor.MemberSubscription;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignorException;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.coordinator.group.assignor.AssignorHelpers;
import org.apache.kafka.coordinator.group.modern.MemberAssignmentImpl;
import org.apache.kafka.server.common.TopicIdPartition;

public class SimpleHeterogeneousAssignmentBuilder {
    private final Set<Uuid> subscribedTopicIds = new HashSet<Uuid>();
    private final List<String> memberIds;
    private final Map<String, Integer> memberIndices;
    private final Map<Uuid, List<Integer>> subscribedMembersByTopic;
    private final Map<Uuid, List<TopicIdPartition>> targetPartitionsByTopic;
    private final int numGroupMembers;
    private final Map<Integer, Map<Uuid, Set<Integer>>> oldGroupAssignment;
    private final Map<Integer, Map<Uuid, Set<Integer>>> newGroupAssignment;

    public SimpleHeterogeneousAssignmentBuilder(GroupSpec groupSpec, SubscribedTopicDescriber subscribedTopicDescriber) {
        groupSpec.memberIds().forEach(memberId -> this.subscribedTopicIds.addAll(groupSpec.memberSubscription(memberId).subscribedTopicIds()));
        this.numGroupMembers = groupSpec.memberIds().size();
        this.memberIds = new ArrayList<String>(groupSpec.memberIds());
        this.memberIndices = AssignorHelpers.newHashMap(this.numGroupMembers);
        for (int memberIndex = 0; memberIndex < this.numGroupMembers; ++memberIndex) {
            this.memberIndices.put(this.memberIds.get(memberIndex), memberIndex);
        }
        this.targetPartitionsByTopic = SimpleHeterogeneousAssignmentBuilder.computeTargetPartitions(groupSpec, this.subscribedTopicIds, subscribedTopicDescriber);
        this.subscribedMembersByTopic = SimpleHeterogeneousAssignmentBuilder.computeSubscribedMembers(groupSpec, this.subscribedTopicIds, this.memberIndices);
        this.oldGroupAssignment = AssignorHelpers.newHashMap(this.numGroupMembers);
        this.newGroupAssignment = AssignorHelpers.newHashMap(this.numGroupMembers);
        groupSpec.memberIds().forEach(memberId -> {
            int memberIndex = this.memberIndices.get(memberId);
            this.oldGroupAssignment.put(memberIndex, groupSpec.memberAssignment(memberId).partitions());
        });
    }

    public GroupAssignment build() {
        if (this.subscribedTopicIds.isEmpty()) {
            return new GroupAssignment(Map.of());
        }
        this.subscribedTopicIds.forEach(topicId -> {
            TopicAssignmentPartialBuilder topicAssignmentBuilder = new TopicAssignmentPartialBuilder((Uuid)topicId, this.numGroupMembers, this.targetPartitionsByTopic.get(topicId), this.subscribedMembersByTopic.get(topicId));
            topicAssignmentBuilder.build();
        });
        HashMap<String, MemberAssignmentImpl> targetAssignment = AssignorHelpers.newHashMap(this.numGroupMembers);
        for (int memberIndex = 0; memberIndex < this.numGroupMembers; ++memberIndex) {
            Map<Uuid, Set<Integer>> memberAssignment = this.newGroupAssignment.get(memberIndex);
            if (memberAssignment == null) {
                targetAssignment.put(this.memberIds.get(memberIndex), new MemberAssignmentImpl(this.oldGroupAssignment.get(memberIndex)));
                continue;
            }
            targetAssignment.put(this.memberIds.get(memberIndex), new MemberAssignmentImpl(memberAssignment));
        }
        return new GroupAssignment(targetAssignment);
    }

    private static Map<Uuid, List<TopicIdPartition>> computeTargetPartitions(GroupSpec groupSpec, Set<Uuid> subscribedTopicIds, SubscribedTopicDescriber subscribedTopicDescriber) {
        HashMap<Uuid, List<TopicIdPartition>> targetPartitionsByTopic = AssignorHelpers.newHashMap(subscribedTopicIds.size());
        subscribedTopicIds.forEach(topicId -> {
            int numPartitions = subscribedTopicDescriber.numPartitions(topicId);
            if (numPartitions == -1) {
                throw new PartitionAssignorException("Members are subscribed to topic " + String.valueOf(topicId) + " which doesn't exist in the topic metadata.");
            }
            ArrayList<TopicIdPartition> targetPartitions = new ArrayList<TopicIdPartition>(numPartitions);
            for (int partition = 0; partition < numPartitions; ++partition) {
                if (!groupSpec.isPartitionAssignable(topicId, partition)) continue;
                targetPartitions.add(new TopicIdPartition(topicId, partition));
            }
            targetPartitionsByTopic.put((Uuid)topicId, (List<TopicIdPartition>)targetPartitions);
        });
        return targetPartitionsByTopic;
    }

    private static Map<Uuid, List<Integer>> computeSubscribedMembers(GroupSpec groupSpec, Set<Uuid> subscribedTopicIds, Map<String, Integer> memberIndices) {
        int numMembers = memberIndices.size();
        HashMap<Uuid, List<Integer>> subscribedMembersByTopic = AssignorHelpers.newHashMap(subscribedTopicIds.size());
        groupSpec.memberIds().forEach(memberId -> {
            int memberIndex = (Integer)memberIndices.get(memberId);
            MemberSubscription memberSubscription = groupSpec.memberSubscription(memberId);
            memberSubscription.subscribedTopicIds().forEach(topicId -> subscribedMembersByTopic.computeIfAbsent((Uuid)topicId, k -> new ArrayList(numMembers)).add(memberIndex));
        });
        return subscribedMembersByTopic;
    }

    private final class TopicAssignmentPartialBuilder {
        private final Uuid topicId;
        private final List<TopicIdPartition> targetPartitions;
        private final List<Integer> subscribedMembers;
        private final Map<Integer, Set<Integer>> finalAssignmentByPartition;
        private final Map<Integer, Set<Integer>> finalAssignmentByMember;
        private final Integer desiredSharing;
        private final int[] desiredAssignmentCounts;

        public TopicAssignmentPartialBuilder(Uuid topicId, int numGroupMembers, List<TopicIdPartition> targetPartitions, List<Integer> subscribedMembers) {
            this.topicId = topicId;
            this.targetPartitions = targetPartitions;
            this.subscribedMembers = subscribedMembers;
            this.finalAssignmentByPartition = AssignorHelpers.newHashMap(targetPartitions.size());
            this.finalAssignmentByMember = AssignorHelpers.newHashMap(subscribedMembers.size());
            int numTargetPartitions = targetPartitions.size();
            int numSubscribedMembers = subscribedMembers.size();
            this.desiredSharing = numTargetPartitions == 0 ? Integer.valueOf(0) : Integer.valueOf((numSubscribedMembers + numTargetPartitions - 1) / numTargetPartitions);
            this.desiredAssignmentCounts = new int[numGroupMembers];
            double preciseDesiredAssignmentCount = (double)(this.desiredSharing * numTargetPartitions) / (double)numSubscribedMembers;
            for (int memberIndex = 0; memberIndex < numSubscribedMembers; ++memberIndex) {
                this.desiredAssignmentCounts[subscribedMembers.get((int)memberIndex).intValue()] = (int)Math.ceil(preciseDesiredAssignmentCount * (double)(memberIndex + 1)) - (int)Math.ceil(preciseDesiredAssignmentCount * (double)memberIndex);
            }
        }

        public void build() {
            this.revokeUnassignablePartitions();
            this.revokeOverfilledMembers();
            this.revokeOversharedPartitions();
            this.targetPartitions.forEach(topicPartition -> this.finalAssignmentByPartition.computeIfAbsent(topicPartition.partitionId(), k -> AssignorHelpers.newHashSet(this.subscribedMembers.size())));
            this.assignRemainingPartitions();
        }

        private void revokeUnassignablePartitions() {
            for (Map.Entry<Integer, Map<Uuid, Set<Integer>>> entry : SimpleHeterogeneousAssignmentBuilder.this.oldGroupAssignment.entrySet()) {
                Set<Integer> assignedPartitions;
                Integer memberIndex = entry.getKey();
                Map<Uuid, Set<Integer>> oldMemberAssignment = entry.getValue();
                Map<Uuid, Set<Integer>> newMemberAssignment = null;
                if (oldMemberAssignment.isEmpty() || (assignedPartitions = oldMemberAssignment.get(this.topicId)) == null) continue;
                if (SimpleHeterogeneousAssignmentBuilder.this.subscribedTopicIds.contains(this.topicId)) {
                    for (int partition : assignedPartitions) {
                        this.finalAssignmentByPartition.computeIfAbsent(partition, k -> new HashSet()).add(memberIndex);
                        this.finalAssignmentByMember.computeIfAbsent(memberIndex, k -> new HashSet()).add(partition);
                    }
                } else {
                    newMemberAssignment = AssignorHelpers.deepCopyAssignment(oldMemberAssignment);
                    newMemberAssignment.remove(this.topicId);
                }
                if (newMemberAssignment == null) continue;
                SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.put(memberIndex, newMemberAssignment);
            }
        }

        private void revokeOverfilledMembers() {
            this.finalAssignmentByMember.forEach((memberIndex, assignedPartitions) -> {
                int memberDesiredAssignmentCount = this.desiredAssignmentCounts[memberIndex];
                if (assignedPartitions.size() > memberDesiredAssignmentCount) {
                    Map<Uuid, Set<Integer>> newMemberAssignment = SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.get(memberIndex);
                    Iterator partitionIterator = assignedPartitions.iterator();
                    while (partitionIterator.hasNext() && assignedPartitions.size() > memberDesiredAssignmentCount) {
                        int partitionIndex = (Integer)partitionIterator.next();
                        this.finalAssignmentByPartition.get(partitionIndex).remove(memberIndex);
                        partitionIterator.remove();
                        if (newMemberAssignment == null) {
                            newMemberAssignment = AssignorHelpers.deepCopyAssignment(SimpleHeterogeneousAssignmentBuilder.this.oldGroupAssignment.get(memberIndex));
                            SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.put((Integer)memberIndex, newMemberAssignment);
                        }
                        newMemberAssignment.get(this.topicId).remove(partitionIndex);
                    }
                }
            });
        }

        private void revokeOversharedPartitions() {
            this.finalAssignmentByPartition.forEach((partitionIndex, assignedMembers) -> {
                int assignedMemberCount = assignedMembers.size();
                if (assignedMemberCount > this.desiredSharing) {
                    Iterator assignedMemberIterator = assignedMembers.iterator();
                    while (assignedMemberIterator.hasNext()) {
                        Set<Integer> partitions;
                        Integer memberIndex = (Integer)assignedMemberIterator.next();
                        Map<Uuid, Set<Integer>> newMemberAssignment = SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.get(memberIndex);
                        if (newMemberAssignment == null) {
                            newMemberAssignment = AssignorHelpers.deepCopyAssignment(SimpleHeterogeneousAssignmentBuilder.this.oldGroupAssignment.get(memberIndex));
                            SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.put(memberIndex, newMemberAssignment);
                        }
                        if ((partitions = newMemberAssignment.get(this.topicId)) != null && partitions.remove(partitionIndex)) {
                            --assignedMemberCount;
                            assignedMemberIterator.remove();
                            this.finalAssignmentByMember.get(memberIndex).remove(partitionIndex);
                        }
                        if (assignedMemberCount > this.desiredSharing) continue;
                        break;
                    }
                }
            });
        }

        private void assignRemainingPartitions() {
            HashSet unfilledMembers = AssignorHelpers.newHashSet(SimpleHeterogeneousAssignmentBuilder.this.numGroupMembers);
            SimpleHeterogeneousAssignmentBuilder.this.subscribedMembersByTopic.get(this.topicId).forEach(memberIndex -> {
                int numberOfAssignedPartitions;
                Set<Integer> assignedPartitions = this.finalAssignmentByMember.get(memberIndex);
                int n = numberOfAssignedPartitions = assignedPartitions == null ? 0 : assignedPartitions.size();
                if (numberOfAssignedPartitions < this.desiredAssignmentCounts[memberIndex]) {
                    unfilledMembers.add(memberIndex);
                }
            });
            Iterator memberIterator = unfilledMembers.iterator();
            boolean partitionAssignedForThisIterator = false;
            for (Map.Entry<Integer, Set<Integer>> partitionAssignment : this.finalAssignmentByPartition.entrySet()) {
                int partitionIndex = partitionAssignment.getKey();
                Set<Integer> membersAssigned = partitionAssignment.getValue();
                if (membersAssigned.size() < this.desiredSharing) {
                    int assignmentsToMake = this.desiredSharing - membersAssigned.size();
                    while (assignmentsToMake > 0) {
                        int memberIndex2;
                        if (!memberIterator.hasNext()) {
                            if (!partitionAssignedForThisIterator) break;
                            memberIterator = unfilledMembers.iterator();
                            partitionAssignedForThisIterator = false;
                        }
                        if (membersAssigned.contains(memberIndex2 = ((Integer)memberIterator.next()).intValue())) continue;
                        Map<Uuid, Set<Integer>> newMemberAssignment = SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.get(memberIndex2);
                        if (newMemberAssignment == null) {
                            newMemberAssignment = AssignorHelpers.deepCopyAssignment(SimpleHeterogeneousAssignmentBuilder.this.oldGroupAssignment.get(memberIndex2));
                            SimpleHeterogeneousAssignmentBuilder.this.newGroupAssignment.put(memberIndex2, newMemberAssignment);
                        }
                        newMemberAssignment.computeIfAbsent(this.topicId, k -> new HashSet()).add(partitionIndex);
                        this.finalAssignmentByMember.computeIfAbsent(memberIndex2, k -> new HashSet()).add(partitionIndex);
                        --assignmentsToMake;
                        partitionAssignedForThisIterator = true;
                        if (this.finalAssignmentByMember.get(memberIndex2).size() < this.desiredAssignmentCounts[memberIndex2]) continue;
                        memberIterator.remove();
                    }
                }
                if (!unfilledMembers.isEmpty()) continue;
                break;
            }
        }
    }
}

