/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import sun.nio.ch.DirectBuffer;

public class CRC32
implements Checksum {
    private int crc;

    @Override
    public void update(int n) {
        this.crc = CRC32.update(this.crc, n);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32.updateBytes(this.crc, byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.crc = CRC32.updateBytes(this.crc, byArray, 0, byArray.length);
    }

    public void update(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        if (byteBuffer instanceof DirectBuffer) {
            this.crc = CRC32.updateByteBuffer(this.crc, ((DirectBuffer)((Object)byteBuffer)).address(), n, n3);
        } else if (byteBuffer.hasArray()) {
            this.crc = CRC32.updateBytes(this.crc, byteBuffer.array(), n + byteBuffer.arrayOffset(), n3);
        } else {
            byte[] byArray = new byte[n3];
            byteBuffer.get(byArray);
            this.crc = CRC32.updateBytes(this.crc, byArray, 0, byArray.length);
        }
        byteBuffer.position(n2);
    }

    @Override
    public void reset() {
        this.crc = 0;
    }

    @Override
    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    private static native int update(int var0, int var1);

    private static native int updateBytes(int var0, byte[] var1, int var2, int var3);

    private static native int updateByteBuffer(int var0, long var1, int var3, int var4);
}

