/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.api.Interface;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.render.ShapeRenderer;
import org.jmol.renderbio.BioMeshRenderer;
import org.jmol.renderbio.TraceRenderer;
import org.jmol.shape.Sticks;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;
import org.jmol.util.C;
import org.jmol.util.Point3fi;

abstract class BioShapeRenderer
extends ShapeRenderer {
    private boolean invalidateMesh;
    private boolean invalidateSheets;
    private boolean isTraceAlpha;
    private boolean ribbonBorder = false;
    private boolean haveControlPointScreens;
    float aspectRatio;
    int hermiteLevel;
    private float sheetSmoothing;
    protected boolean cartoonsFancy;
    protected int monomerCount;
    protected Monomer[] monomers;
    protected boolean isNucleic;
    protected boolean isPhosphorusOnly;
    protected boolean isCarbohydrate;
    protected BS bsVisible = new BS();
    protected P3[] ribbonTopScreens;
    protected P3[] ribbonBottomScreens;
    protected P3[] controlPoints;
    protected P3[] controlPointScreens;
    protected int[] leadAtomIndices;
    protected V3[] wingVectors;
    protected short[] mads;
    protected short[] colixes;
    protected short[] colixesBack;
    protected STR[] structureTypes;
    boolean isHighRes;
    protected boolean wireframeOnly;
    private boolean needTranslucent;
    protected boolean renderStruts;
    BioMeshRenderer meshRenderer;
    BioShape bioShape;
    private final P3 pointT = new P3();
    int iPrev;
    int iNext;
    int iNext2;
    int iNext3;
    int diameterBeg;
    int diameterMid;
    int diameterEnd;
    short madBeg;
    short madMid;
    short madEnd;
    short colixBack;
    private BS reversed;
    private boolean isCyclic;
    private final P3 screenArrowTop = new P3();
    private final P3 screenArrowTopPrev = new P3();
    private final P3 screenArrowBot = new P3();
    private final P3 screenArrowBotPrev = new P3();

    BioShapeRenderer() {
    }

    protected abstract void renderBioShape(BioShape var1);

    @Override
    protected boolean render() {
        if (this.shape == null) {
            return false;
        }
        this.setGlobals();
        this.renderShapes();
        return this.needTranslucent;
    }

    private void setGlobals() {
        int val1;
        boolean TF;
        this.invalidateMesh = false;
        this.needTranslucent = false;
        this.g3d.addRenderer(553648143);
        boolean bl = TF = !this.isExport && !this.vwr.checkMotionRendering(1112152066);
        if (TF != this.wireframeOnly) {
            this.invalidateMesh = true;
        }
        this.wireframeOnly = TF;
        boolean bl2 = TF = this.isExport || !this.wireframeOnly && this.vwr.getBoolean(603979863);
        if (TF != this.isHighRes) {
            this.invalidateMesh = true;
        }
        this.isHighRes = TF;
        boolean bl3 = TF = !this.wireframeOnly && (this.vwr.getBoolean(603979816) || this.isExport);
        if (this.cartoonsFancy != TF) {
            this.invalidateMesh = true;
            this.cartoonsFancy = TF;
        }
        int n = (val1 = this.vwr.getHermiteLevel()) <= 0 ? -val1 : (val1 = this.vwr.getInMotion(true) ? 0 : val1);
        if (this.cartoonsFancy && !this.wireframeOnly) {
            val1 = Math.max(val1, 3);
        }
        if (val1 != this.hermiteLevel) {
            this.invalidateMesh = true;
        }
        this.hermiteLevel = Math.min(val1, 8);
        int val = this.vwr.getInt(553648166);
        val = Math.min(Math.max(0, val), 20);
        if (this.cartoonsFancy && val >= 16) {
            val = 4;
        }
        if (this.wireframeOnly || this.hermiteLevel == 0) {
            val = 0;
        }
        if ((float)val != this.aspectRatio && val != 0 && val1 != 0) {
            this.invalidateMesh = true;
        }
        this.aspectRatio = val;
        if (this.aspectRatio > 0.0f) {
            if (this.meshRenderer == null) {
                this.meshRenderer = (BioMeshRenderer)Interface.getInterface("org.jmol.renderbio.BioMeshRenderer");
                this.meshRenderer.setViewerG3dShapeID(this.vwr, this.shape.shapeID);
            }
            this.meshRenderer.setup(this.g3d, this.ms, this.shape);
        }
        if ((TF = this.vwr.getBoolean(603979966)) != this.isTraceAlpha) {
            this.invalidateMesh = true;
        }
        this.isTraceAlpha = TF;
        this.invalidateSheets = false;
        float fval = this.vwr.getFloat(0x22000030);
        if (fval != this.sheetSmoothing && this.isTraceAlpha) {
            this.sheetSmoothing = fval;
            this.invalidateMesh = true;
            this.invalidateSheets = true;
        }
        this.renderStruts = ((Sticks)this.vwr.shm.getShape((int)1)).haveStrutPoints;
    }

    private void renderShapes() {
        BioShapeCollection mps = (BioShapeCollection)this.shape;
        int c = mps.bioShapes.length;
        while (--c >= 0) {
            this.bioShape = mps.getBioShape(c);
            if ((this.bioShape.modelVisibilityFlags & this.myVisibilityFlag) == 0 || this.bioShape.monomerCount < 2 || !this.initializePolymer(this.bioShape)) continue;
            if (this.meshRenderer != null) {
                this.meshRenderer.initBS();
            }
            this.isCyclic = this.bioShape.bioPolymer.isCyclic();
            this.renderBioShape(this.bioShape);
            if (this.meshRenderer != null) {
                this.meshRenderer.renderMeshes();
            }
            this.freeTempArrays();
        }
    }

    protected boolean setBioColix(short colix) {
        if (this.g3d.setC(colix)) {
            return true;
        }
        this.needTranslucent = true;
        return false;
    }

    private void freeTempArrays() {
        if (this.haveControlPointScreens) {
            this.vwr.freeTempPoints(this.controlPointScreens);
        }
        this.vwr.freeTempEnum(this.structureTypes);
    }

    private boolean initializePolymer(BioShape bioShape) {
        BS bsDeleted = this.vwr.slm.bsDeleted;
        this.controlPoints = this.ms.isJmolDataFrame(bioShape.modelIndex) ? bioShape.bioPolymer.getControlPoints(true, 0.0f, false) : bioShape.bioPolymer.getControlPoints(this.isTraceAlpha, this.sheetSmoothing, this.invalidateSheets);
        this.monomerCount = bioShape.monomerCount;
        this.monomers = bioShape.monomers;
        this.reversed = bioShape.bioPolymer.reversed;
        this.leadAtomIndices = bioShape.bioPolymer.getLeadAtomIndices();
        this.bsVisible.clearAll();
        boolean haveVisible = false;
        if (this.invalidateMesh) {
            bioShape.falsifyMesh();
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            if ((this.monomers[i].shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.ms.isAtomHidden(this.leadAtomIndices[i]) || bsDeleted != null && bsDeleted.get(this.leadAtomIndices[i])) continue;
            Atom lead = this.ms.at[this.leadAtomIndices[i]];
            if (!this.g3d.isInDisplayRange(lead.sX, lead.sY)) continue;
            this.bsVisible.set(i);
            haveVisible = true;
        }
        if (!haveVisible) {
            return false;
        }
        this.ribbonBorder = this.vwr.getBoolean(603979901);
        this.isNucleic = bioShape.bioPolymer instanceof NucleicPolymer;
        this.isPhosphorusOnly = !this.isNucleic && bioShape.bioPolymer instanceof PhosphorusPolymer;
        this.isCarbohydrate = bioShape.bioPolymer instanceof CarbohydratePolymer;
        this.haveControlPointScreens = false;
        this.wingVectors = bioShape.wingVectors;
        if (this.meshRenderer != null) {
            this.meshRenderer.initialize(this, bioShape, this.monomerCount);
        }
        this.mads = bioShape.mads;
        this.colixes = bioShape.colixes;
        this.colixesBack = bioShape.colixesBack;
        this.setStructureTypes();
        return true;
    }

    private void setStructureTypes() {
        this.structureTypes = this.vwr.allocTempEnum(this.monomerCount + 1);
        STR[] types = this.structureTypes;
        int i = this.monomerCount;
        while (--i >= 0) {
            types[i] = this.monomers[i].getProteinStructureType();
            if (types[i] != STR.TURN) continue;
            types[i] = STR.NONE;
        }
        types[this.monomerCount] = types[this.monomerCount - 1];
    }

    protected void calcScreenControlPoints() {
        int count = this.monomerCount + 1;
        this.controlPointScreens = this.vwr.allocTempPoints(count);
        P3[] scr = this.controlPointScreens;
        P3[] points = this.controlPoints;
        int i = count;
        while (--i >= 0) {
            this.tm.transformPtScrT3(points[i], scr[i]);
        }
        this.haveControlPointScreens = true;
    }

    protected P3[] calcScreens(float offsetFraction, short[] mads) {
        int count = this.controlPoints.length;
        P3[] screens = this.vwr.allocTempPoints(count);
        if (offsetFraction == 0.0f) {
            int i = count;
            while (--i >= 0) {
                this.tm.transformPtScrT3(this.controlPoints[i], screens[i]);
            }
        } else {
            float offset_1000 = offsetFraction / 1000.0f;
            int i = count;
            while (--i >= 0) {
                this.calc1Screen(this.controlPoints[i], this.wingVectors[i], mads[i] == 0 && i > 0 ? mads[i - 1] : mads[i], offset_1000, screens[i]);
            }
        }
        return screens;
    }

    private void calc1Screen(P3 center, V3 vector, short mad, float offset_1000, P3 screen) {
        this.pointT.scaleAdd2((float)mad * offset_1000, vector, center);
        this.tm.transformPtScrT3(this.pointT, screen);
    }

    protected short getLeadColix(int i) {
        return C.getColixInherited(this.colixes[i], this.monomers[i].getLeadAtom().colixAtom);
    }

    protected short getLeadColixBack(int i) {
        return this.colixesBack == null || this.colixesBack.length <= i ? (short)0 : this.colixesBack[i];
    }

    void setNeighbors(int i) {
        if (this.isCyclic) {
            this.iPrev = ((i += this.monomerCount) - 1) % this.monomerCount;
            this.iNext = (i + 1) % this.monomerCount;
            this.iNext2 = (i + 2) % this.monomerCount;
            this.iNext3 = (i + 3) % this.monomerCount;
        } else {
            this.iPrev = Math.max(i - 1, 0);
            this.iNext = Math.min(i + 1, this.monomerCount);
            this.iNext2 = Math.min(i + 2, this.monomerCount);
            this.iNext3 = Math.min(i + 3, this.monomerCount);
        }
    }

    protected boolean setColix(short colix) {
        this.colix = colix;
        return this.g3d.setC(colix);
    }

    private boolean setMads(int i, boolean thisTypeOnly) {
        this.madBeg = this.madEnd = this.mads[i];
        this.madMid = this.madEnd;
        if (this.isTraceAlpha) {
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iNext]) {
                this.madEnd = this.mads[this.iNext];
                if (this.madEnd == 0) {
                    this.madEnd = this instanceof TraceRenderer ? this.madBeg : this.madBeg;
                }
                this.madMid = (short)(this.madBeg + this.madEnd >> 1);
            }
        } else {
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iPrev]) {
                this.madBeg = (short)((this.mads[this.iPrev] == 0 ? this.madMid : this.mads[this.iPrev]) + this.madMid >> 1);
            }
            if (!thisTypeOnly || this.structureTypes[i] == this.structureTypes[this.iNext]) {
                this.madEnd = (short)((this.mads[this.iNext] == 0 ? this.madMid : this.mads[this.iNext]) + this.madMid >> 1);
            }
        }
        this.diameterBeg = (int)this.vwr.tm.scaleToScreen((int)this.controlPointScreens[i].z, this.madBeg);
        this.diameterMid = (int)this.vwr.tm.scaleToScreen(this.monomers[i].getLeadAtom().sZ, this.madMid);
        this.diameterEnd = (int)this.vwr.tm.scaleToScreen((int)this.controlPointScreens[this.iNext].z, this.madEnd);
        boolean doCap0 = i == this.iPrev || !this.bsVisible.get(this.iPrev) || thisTypeOnly && this.structureTypes[i] != this.structureTypes[this.iPrev];
        boolean doCap1 = this.iNext == this.iNext2 || this.iNext2 == this.iNext3 || !this.bsVisible.get(this.iNext) || thisTypeOnly && this.structureTypes[i] != this.structureTypes[this.iNext];
        return this.aspectRatio > 0.0f && this.meshRenderer != null && this.meshRenderer.check(doCap0, doCap1);
    }

    protected void renderHermiteCylinder(P3[] screens, int i) {
        this.colix = this.getLeadColix(i);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.setNeighbors(i);
        this.g3d.drawHermite4(this.isNucleic ? 4 : 7, screens[this.iPrev], screens[i], screens[this.iNext], screens[this.iNext2]);
    }

    protected void renderHermiteConic(int i, boolean thisTypeOnly, int tension) {
        this.setNeighbors(i);
        this.colix = this.getLeadColix(i);
        this.checkStruts(i);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        if (this.setMads(i, thisTypeOnly) || this.isExport) {
            if (!this.meshRenderer.setFancyConic(i, tension)) {
                return;
            }
        } else if (this.diameterBeg == 0 && this.diameterEnd == 0 || this.wireframeOnly) {
            this.g3d.drawLineAB(this.controlPointScreens[i], this.controlPointScreens[this.iNext]);
        } else {
            this.g3d.fillHermite(this.isNucleic ? 4 : 7, this.diameterBeg, this.diameterMid, this.diameterEnd, this.controlPointScreens[this.iPrev], this.controlPointScreens[i], this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2]);
        }
    }

    private void checkStruts(int i) {
        if (this.renderStruts && this.monomers[i].isSheet() && this.monomers[i].strutPoint != null) {
            Point3fi p = new Point3fi();
            p.add2(this.controlPoints[i], this.controlPoints[i + 1]);
            p.scale(0.5f);
            this.setStrutPoint(this.monomers[i].getLeadAtom(), p);
        }
    }

    protected void renderHermiteRibbon(boolean doFill, int i, boolean thisTypeOnly) {
        this.setNeighbors(i);
        this.checkStruts(i);
        short c0 = this.colix = this.getLeadColix(i);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        short cb = this.colixBack = this.getLeadColixBack(i);
        if (doFill && (this.aspectRatio != 0.0f || this.isExport) && (this.setMads(i, thisTypeOnly) || this.isExport)) {
            this.meshRenderer.setFancyRibbon(i);
            return;
        }
        boolean isReversed = this.reversed.get(i);
        if (isReversed && this.colixBack != 0) {
            this.setColix(this.colixBack);
            cb = c0;
        }
        this.g3d.drawHermite7(doFill, this.ribbonBorder, (isReversed ? -1 : 1) * (this.isNucleic ? 4 : 7), this.ribbonTopScreens[this.iPrev], this.ribbonTopScreens[i], this.ribbonTopScreens[this.iNext], this.ribbonTopScreens[this.iNext2], this.ribbonBottomScreens[this.iPrev], this.ribbonBottomScreens[i], this.ribbonBottomScreens[this.iNext], this.ribbonBottomScreens[this.iNext2], (int)this.aspectRatio, cb);
        if (isReversed && this.colixBack != 0) {
            this.setColix(c0);
            cb = this.colixBack;
        }
    }

    protected void renderHermiteArrowHead(int i) {
        this.colix = this.getLeadColix(i);
        if (!this.setBioColix(this.colix)) {
            return;
        }
        this.colixBack = this.getLeadColixBack(i);
        this.setNeighbors(i);
        if (this.setMads(i, false) || this.isExport) {
            this.meshRenderer.setFancyArrowHead(i);
            return;
        }
        P3 cp = this.controlPoints[i];
        V3 wv = this.wingVectors[i];
        this.calc1Screen(cp, wv, this.madBeg, 7.0E-4f, this.screenArrowTop);
        this.calc1Screen(cp, wv, this.madBeg, -7.0E-4f, this.screenArrowBot);
        this.calc1Screen(cp, wv, this.madBeg, 0.001f, this.screenArrowTopPrev);
        this.calc1Screen(cp, wv, this.madBeg, -0.001f, this.screenArrowBotPrev);
        this.g3d.drawHermite7(true, this.ribbonBorder, this.isNucleic ? 4 : 7, this.screenArrowTopPrev, this.screenArrowTop, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], this.screenArrowBotPrev, this.screenArrowBot, this.controlPointScreens[this.iNext], this.controlPointScreens[this.iNext2], (int)this.aspectRatio, this.colixBack);
        this.g3d.setC(this.colix);
        if (this.ribbonBorder && this.aspectRatio == 0.0f) {
            this.g3d.fillCylinderBits((byte)3, 3, this.screenArrowTop, this.screenArrowBot);
        }
    }

    protected void drawSegmentAB(Atom atomA, Atom atomB, short colixA, short colixB, float max) {
        int xA = atomA.sX;
        int yA = atomA.sY;
        int zA = atomA.sZ;
        int xB = atomB.sX;
        int yB = atomB.sY;
        int zB = atomB.sZ;
        int mad = this.mad;
        if (max == 1000.0f) {
            mad >>= 1;
        }
        if (mad < 0) {
            this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
        } else {
            int width = (int)(this.isExport ? (float)mad : this.vwr.tm.scaleToScreen((zA + zB) / 2, mad));
            this.g3d.fillCylinderXYZ(colixA, colixB, (byte)3, width, xA, yA, zA, xB, yB, zB);
        }
    }

    protected Point3fi getStrutPointIfNeeded(Atom a) {
        Point3fi p = a.group.strutPoint;
        return p != null && p.sX == Integer.MIN_VALUE ? p : null;
    }

    protected void setStrutPoint(Atom a, Point3fi newPt) {
        Point3fi p = this.getStrutPointIfNeeded(a);
        if (p == null) {
            return;
        }
        if (newPt == null) {
            newPt = a;
        }
        p.setP(newPt);
        p.sX = newPt.sX;
        p.sY = newPt.sY;
        p.sZ = newPt.sZ;
    }
}

