/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.ArrayType;
import sun.jvm.hotspot.debugger.cdbg.BitType;
import sun.jvm.hotspot.debugger.cdbg.CVAttributes;
import sun.jvm.hotspot.debugger.cdbg.CompoundType;
import sun.jvm.hotspot.debugger.cdbg.DoubleType;
import sun.jvm.hotspot.debugger.cdbg.EnumType;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.FloatType;
import sun.jvm.hotspot.debugger.cdbg.FunctionType;
import sun.jvm.hotspot.debugger.cdbg.IntType;
import sun.jvm.hotspot.debugger.cdbg.MemberFunctionType;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.PointerType;
import sun.jvm.hotspot.debugger.cdbg.RefType;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.VoidType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public abstract class BasicType
implements Type,
CVAttributes {
    private String name;
    private int size;
    private int cvAttributes;
    private List cvVariants;

    protected BasicType(String name, int size) {
        this(name, size, 0);
    }

    protected BasicType(String name, int size, int cvAttributes) {
        this.name = name;
        this.size = size;
        this.cvAttributes = cvAttributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public BitType asBit() {
        return null;
    }

    @Override
    public IntType asInt() {
        return null;
    }

    @Override
    public EnumType asEnum() {
        return null;
    }

    @Override
    public FloatType asFloat() {
        return null;
    }

    @Override
    public DoubleType asDouble() {
        return null;
    }

    @Override
    public PointerType asPointer() {
        return null;
    }

    @Override
    public ArrayType asArray() {
        return null;
    }

    @Override
    public RefType asRef() {
        return null;
    }

    @Override
    public CompoundType asCompound() {
        return null;
    }

    @Override
    public FunctionType asFunction() {
        return null;
    }

    @Override
    public MemberFunctionType asMemberFunction() {
        return null;
    }

    @Override
    public VoidType asVoid() {
        return null;
    }

    @Override
    public boolean isBit() {
        return this.asBit() != null;
    }

    @Override
    public boolean isInt() {
        return this.asInt() != null;
    }

    @Override
    public boolean isEnum() {
        return this.asEnum() != null;
    }

    @Override
    public boolean isFloat() {
        return this.asFloat() != null;
    }

    @Override
    public boolean isDouble() {
        return this.asDouble() != null;
    }

    @Override
    public boolean isPointer() {
        return this.asPointer() != null;
    }

    @Override
    public boolean isArray() {
        return this.asArray() != null;
    }

    @Override
    public boolean isRef() {
        return this.asRef() != null;
    }

    @Override
    public boolean isCompound() {
        return this.asCompound() != null;
    }

    @Override
    public boolean isFunction() {
        return this.asFunction() != null;
    }

    @Override
    public boolean isMemberFunction() {
        return this.asMemberFunction() != null;
    }

    @Override
    public boolean isVoid() {
        return this.asVoid() != null;
    }

    @Override
    public boolean isConst() {
        return (this.cvAttributes & 1) != 0;
    }

    @Override
    public boolean isVolatile() {
        return (this.cvAttributes & 2) != 0;
    }

    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        if (this.cvVariants != null) {
            ListIterator<Type> iter = this.cvVariants.listIterator();
            while (iter.hasNext()) {
                iter.set(db.resolveType(this, (Type)((BasicType)iter.next()), listener, "resolving const/var variants"));
            }
        }
        return this;
    }

    public boolean isLazy() {
        return false;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v) {
        this.iterateObject(a, v, null);
    }

    @Override
    public abstract void iterateObject(Address var1, ObjectVisitor var2, FieldIdentifier var3);

    public Type getCVVariant(int cvAttributes) {
        Type t = this.findCVVariant(cvAttributes);
        if (t != null) {
            return t;
        }
        t = this.createCVVariant(cvAttributes);
        this.addCVVariant(t);
        return t;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private int getCVAttributes() {
        return this.cvAttributes;
    }

    protected abstract Type createCVVariant(int var1);

    protected Type findCVVariant(int cvAttributes) {
        if (this.cvVariants != null) {
            for (BasicType t : this.cvVariants) {
                if (t.getCVAttributes() != cvAttributes) continue;
                return t;
            }
        }
        return null;
    }

    protected void addCVVariant(Type t) {
        if (this.cvVariants == null) {
            this.cvVariants = new ArrayList();
        }
        this.cvVariants.add(t);
    }

    public abstract void visit(TypeVisitor var1);
}

