/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.repositorycrawler;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.repositorycrawler.RepositoryCrawler;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Component(role=RepositoryCrawler.class)
public class DefaultRepositoryCrawler
extends AbstractLogEnabled
implements RepositoryCrawler {
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;

    public ArchetypeCatalog crawl(File repository) {
        if (!repository.isDirectory()) {
            this.getLogger().warn("File is not a directory");
            return null;
        }
        ArchetypeCatalog catalog = new ArchetypeCatalog();
        for (File jar : FileUtils.listFiles((File)repository, (String[])new String[]{"jar"}, (boolean)true)) {
            this.getLogger().info("Scanning " + jar);
            if (!this.archetypeArtifactManager.isFileSetArchetype(jar) && !this.archetypeArtifactManager.isOldArchetype(jar)) continue;
            try {
                Object descriptor;
                Archetype archetype = new Archetype();
                Model pom = this.archetypeArtifactManager.getArchetypePom(jar);
                if (this.archetypeArtifactManager.isFileSetArchetype(jar)) {
                    descriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(jar);
                    archetype.setDescription(descriptor.getName());
                } else {
                    descriptor = this.archetypeArtifactManager.getOldArchetypeDescriptor(jar);
                    archetype.setDescription(((ArchetypeDescriptor)descriptor).getId());
                }
                if (pom != null) {
                    if (pom.getGroupId() != null) {
                        archetype.setGroupId(pom.getGroupId());
                    } else {
                        archetype.setGroupId(pom.getParent().getGroupId());
                    }
                    archetype.setArtifactId(pom.getArtifactId());
                    if (pom.getVersion() != null) {
                        archetype.setVersion(pom.getVersion());
                    } else {
                        archetype.setVersion(pom.getParent().getVersion());
                    }
                    this.getLogger().info("\tArchetype " + archetype + " found in pom");
                } else {
                    String version = jar.getParentFile().getName();
                    String artifactId = jar.getParentFile().getParentFile().getName();
                    String groupIdSep = StringUtils.replace((String)jar.getParentFile().getParentFile().getParentFile().getPath(), (String)repository.getPath(), (String)"");
                    String groupId = groupIdSep.replace(File.separatorChar, '.');
                    groupId = groupId.startsWith(".") ? groupId.substring(1) : groupId;
                    groupId = groupId.endsWith(".") ? groupId.substring(0, groupId.length() - 1) : groupId;
                    archetype.setGroupId(groupId);
                    archetype.setArtifactId(artifactId);
                    archetype.setVersion(version);
                    this.getLogger().info("\tArchetype " + archetype + " defined by repository path");
                }
                catalog.addArchetype(archetype);
            }
            catch (XmlPullParserException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (UnknownArchetype ex) {
                ex.printStackTrace();
            }
        }
        return catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeCatalog(ArchetypeCatalog archetypeCatalog, File archetypeCatalogFile) {
        boolean bl;
        XmlStreamWriter fileWriter = null;
        try {
            ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();
            fileWriter = WriterFactory.newXmlWriter((File)archetypeCatalogFile);
            catalogWriter.write((Writer)fileWriter, archetypeCatalog);
            bl = true;
        }
        catch (IOException ex) {
            boolean bl2;
            try {
                this.getLogger().warn("Catalog can not be writen to " + archetypeCatalogFile, (Throwable)ex);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(fileWriter);
                throw throwable;
            }
            IOUtil.close((Writer)fileWriter);
            return bl2;
        }
        IOUtil.close((Writer)fileWriter);
        return bl;
    }
}

