/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.AndIt;
import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.BufferedIterator32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.ORIt;
import com.googlecode.javaewah32.XORIt;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;

public final class IteratorAggregation32 {
    public static final int DEFAULT_MAX_BUF_SIZE = 65536;

    private IteratorAggregation32() {
    }

    public static IteratingRLW32 not(final IteratingRLW32 x) {
        return new IteratingRLW32(){

            @Override
            public boolean next() {
                return x.next();
            }

            @Override
            public int getLiteralWordAt(int index) {
                return ~x.getLiteralWordAt(index);
            }

            @Override
            public int getNumberOfLiteralWords() {
                return x.getNumberOfLiteralWords();
            }

            @Override
            public boolean getRunningBit() {
                return !x.getRunningBit();
            }

            @Override
            public int size() {
                return x.size();
            }

            @Override
            public int getRunningLength() {
                return x.getRunningLength();
            }

            @Override
            public void discardFirstWords(int y) {
                x.discardFirstWords(y);
            }

            @Override
            public void discardRunningWords() {
                x.discardRunningWords();
            }

            @Override
            public IteratingRLW32 clone() throws CloneNotSupportedException {
                throw new CloneNotSupportedException();
            }

            @Override
            public void discardLiteralWords(int y) {
                x.discardLiteralWords(y);
            }
        };
    }

    public static IteratingRLW32 bufferedand(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedand(65536, al);
    }

    public static IteratingRLW32 bufferedand(int bufSize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        Collections.addAll(basell, al);
        return new BufferedIterator32(new AndIt(basell, bufSize));
    }

    public static IteratingRLW32 bufferedor(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedor(65536, al);
    }

    public static IteratingRLW32 bufferedor(int bufSize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        Collections.addAll(basell, al);
        return new BufferedIterator32(new ORIt(basell, bufSize));
    }

    public static IteratingRLW32 bufferedxor(IteratingRLW32 ... al) {
        return IteratorAggregation32.bufferedxor(65536, al);
    }

    public static IteratingRLW32 bufferedxor(int bufSize, IteratingRLW32 ... al) {
        if (al.length == 0) {
            throw new IllegalArgumentException("Need at least one iterator");
        }
        if (al.length == 1) {
            return al[0];
        }
        LinkedList<IteratingRLW32> basell = new LinkedList<IteratingRLW32>();
        Collections.addAll(basell, al);
        return new BufferedIterator32(new XORIt(basell, bufSize));
    }

    protected static void dischargeAsEmpty(BitmapStorage32 container, IteratingRLW32 i) {
        while (i.size() > 0) {
            container.addStreamOfEmptyWords(false, i.size());
            i.next();
        }
    }

    protected static int discharge(BitmapStorage32 container, IteratingRLW32 i, int max) {
        int counter;
        int l;
        for (counter = 0; i.size() > 0 && counter < max; counter += l) {
            int l1 = i.getRunningLength();
            if (l1 > 0) {
                if (l1 + counter > max) {
                    l1 = max - counter;
                }
                container.addStreamOfEmptyWords(i.getRunningBit(), l1);
                counter += l1;
            }
            if ((l = i.getNumberOfLiteralWords()) + counter > max) {
                l = max - counter;
            }
            for (int k = 0; k < l; ++k) {
                container.addWord(i.getLiteralWordAt(k));
            }
            i.discardFirstWords(l + l1);
        }
        return counter;
    }

    protected static int dischargeNegated(BitmapStorage32 container, IteratingRLW32 i, int max) {
        int counter;
        int l;
        for (counter = 0; i.size() > 0 && counter < max; counter += l) {
            int l1 = i.getRunningLength();
            if (l1 > 0) {
                if (l1 + counter > max) {
                    l1 = max - counter;
                }
                container.addStreamOfEmptyWords(i.getRunningBit(), l1);
                counter += l1;
            }
            if ((l = i.getNumberOfLiteralWords()) + counter > max) {
                l = max - counter;
            }
            for (int k = 0; k < l; ++k) {
                container.addWord(i.getLiteralWordAt(k));
            }
            i.discardFirstWords(l + l1);
        }
        return counter;
    }

    static void andToContainer(BitmapStorage32 container, int desiredrlwcount, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0 && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    static void andToContainer(BitmapStorage32 container, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                int index = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    public static void xorToContainer(BitmapStorage32 container, int desiredrlwcount, IteratingRLW32 rlwi, IteratingRLW32 rlwj) {
        while (rlwi.size() > 0 && rlwj.size() > 0 && desiredrlwcount-- > 0) {
            while (rlwi.getRunningLength() > 0 || rlwj.getRunningLength() > 0) {
                int index;
                IteratingRLW32 predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingRLW32 prey = i_is_prey ? rlwi : rlwj;
                IteratingRLW32 iteratingRLW32 = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index = IteratorAggregation32.discharge(container, prey, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = IteratorAggregation32.dischargeNegated(container, prey, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            desiredrlwcount -= nbre_literal;
            for (int k = 0; k < nbre_literal; ++k) {
                container.addWord(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
    }

    protected static int inplaceor(int[] bitmap, IteratingRLW32 i) {
        int s;
        int pos = 0;
        while ((s = i.size()) > 0) {
            int k;
            if (pos + s < bitmap.length) {
                int L = i.getRunningLength();
                if (i.getRunningBit()) {
                    Arrays.fill(bitmap, pos, pos + L, -1);
                }
                pos += L;
                int LR = i.getNumberOfLiteralWords();
                for (k = 0; k < LR; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] | i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howmany = bitmap.length - pos;
            int l = i.getRunningLength();
            if (pos + l > bitmap.length) {
                if (i.getRunningBit()) {
                    Arrays.fill(bitmap, pos, bitmap.length, -1);
                }
                i.discardFirstWords(howmany);
                return bitmap.length;
            }
            if (i.getRunningBit()) {
                Arrays.fill(bitmap, pos, pos + l, -1);
            }
            pos += l;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] | i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howmany);
            return pos;
        }
        return pos;
    }

    protected static int inplacexor(int[] bitmap, IteratingRLW32 i) {
        int s;
        int pos = 0;
        while ((s = i.size()) > 0) {
            int k;
            if (pos + s < bitmap.length) {
                int L = i.getRunningLength();
                if (i.getRunningBit()) {
                    for (int k2 = pos; k2 < pos + L; ++k2) {
                        bitmap[k2] = ~bitmap[k2];
                    }
                }
                pos += L;
                int LR = i.getNumberOfLiteralWords();
                for (k = 0; k < LR; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] ^ i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howMany = bitmap.length - pos;
            int l = i.getRunningLength();
            if (pos + l > bitmap.length) {
                if (i.getRunningBit()) {
                    for (k = pos; k < bitmap.length; ++k) {
                        bitmap[k] = ~bitmap[k];
                    }
                }
                i.discardFirstWords(howMany);
                return bitmap.length;
            }
            if (i.getRunningBit()) {
                for (k = pos; k < pos + l; ++k) {
                    bitmap[k] = ~bitmap[k];
                }
            }
            pos += l;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] ^ i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howMany);
            return pos;
        }
        return pos;
    }

    protected static int inplaceand(int[] bitmap, IteratingRLW32 i) {
        int s;
        int pos = 0;
        while ((s = i.size()) > 0) {
            int k;
            if (pos + s < bitmap.length) {
                int L = i.getRunningLength();
                if (!i.getRunningBit()) {
                    for (int k2 = pos; k2 < pos + L; ++k2) {
                        bitmap[k2] = 0;
                    }
                }
                pos += L;
                int LR = i.getNumberOfLiteralWords();
                for (k = 0; k < LR; ++k) {
                    int n = pos++;
                    bitmap[n] = bitmap[n] & i.getLiteralWordAt(k);
                }
                if (i.next()) continue;
                return pos;
            }
            int howMany = bitmap.length - pos;
            int l = i.getRunningLength();
            if (pos + l > bitmap.length) {
                if (!i.getRunningBit()) {
                    for (k = pos; k < bitmap.length; ++k) {
                        bitmap[k] = 0;
                    }
                }
                i.discardFirstWords(howMany);
                return bitmap.length;
            }
            if (!i.getRunningBit()) {
                for (k = pos; k < pos + l; ++k) {
                    bitmap[k] = 0;
                }
            }
            pos += l;
            k = 0;
            while (pos < bitmap.length) {
                int n = pos++;
                bitmap[n] = bitmap[n] & i.getLiteralWordAt(k);
                ++k;
            }
            i.discardFirstWords(howMany);
            return pos;
        }
        return pos;
    }
}

