/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.structureView;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.KotlinSingleClassFileAnalyzer;
import org.jetbrains.kotlin.idea.structureView.KotlinInheritedMembersNodeProvider;
import org.jetbrains.kotlin.idea.structureView.KotlinStructureViewElement;
import org.jetbrains.kotlin.idea.structureView.KotlinStructureViewModel;
import org.jetbrains.kotlin.psi.KtFile;

public final class KotlinStructureViewFactory
implements PsiStructureViewFactory {
    private static final List<NodeProvider<?>> NODE_PROVIDERS = Collections.singletonList(new KotlinInheritedMembersNodeProvider());

    public StructureViewBuilder getStructureViewBuilder(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            KotlinStructureViewFactory.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof KtFile)) {
            return null;
        }
        final KtFile file = (KtFile)psiFile;
        final boolean isSingleClassFile = KotlinSingleClassFileAnalyzer.isSingleClassFile(file);
        return new TreeBasedStructureViewBuilder(this){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new KotlinStructureViewModel(this, file, editor, (StructureViewTreeElement)new KotlinStructureViewElement((NavigatablePsiElement)file, false)){

                    @NotNull
                    public Collection<NodeProvider<?>> getNodeProviders() {
                        List<NodeProvider<?>> list2 = NODE_PROVIDERS;
                        if (list2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewFactory$1$1", "getNodeProviders"));
                    }
                };
            }

            public boolean isRootNodeShown() {
                return !isSingleClassFile;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/idea/structureView/KotlinStructureViewFactory", "getStructureViewBuilder"));
    }
}

