/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.CleanupFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0094\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/CleanupFix$ModCommand;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "replaceCommasWithOrsInWhenExpression", "whenExpression", "getConditionsDataOrNull", "Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$WhenEntryConditionsData;", "whenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "WhenEntryConditionsData", "kotlin.fir.frontend-independent"})
public final class CommaInWhenConditionWithoutArgumentFix
extends PsiUpdateModCommandAction<KtWhenExpression>
implements CleanupFix.ModCommand {
    public CommaInWhenConditionWithoutArgumentFix(@NotNull KtWhenExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"replace.with.in.when", (Object[])new Object[0]);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull KtWhenExpression element, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        this.replaceCommasWithOrsInWhenExpression(element);
    }

    private final void replaceCommasWithOrsInWhenExpression(KtWhenExpression whenExpression) {
        for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
            WhenEntryConditionsData conditionsData;
            if (whenEntry.getConditions().length <= 1) continue;
            Intrinsics.checkNotNull((Object)whenEntry);
            if (this.getConditionsDataOrNull(whenEntry) == null) {
                return;
            }
            if (conditionsData.getConditions().isEmpty()) continue;
            Project project = whenEntry.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtExpression replacement = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> CommaInWhenConditionWithoutArgumentFix.replaceCommasWithOrsInWhenExpression$lambda$0(conditionsData, arg_0), (int)1, null);
            whenEntry.deleteChildRange(conditionsData.getFirst(), conditionsData.getLast());
            whenEntry.addBefore((PsiElement)replacement, conditionsData.getArrow());
        }
    }

    private final WhenEntryConditionsData getConditionsDataOrNull(KtWhenEntry whenEntry) {
        WhenEntryConditionsData whenEntryConditionsData;
        PsiElement last;
        PsiElement child;
        List conditions = new ArrayList();
        PsiElement arrow = null;
        for (child = whenEntry.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof KtWhenConditionWithExpression) {
                UtilKt.addIfNotNull((List)conditions, (Object)((KtWhenConditionWithExpression)child).getExpression());
                continue;
            }
            if (!Intrinsics.areEqual((Object)child.getNode().getElementType(), (Object)KtTokens.ARROW)) continue;
            arrow = child;
            break;
        }
        PsiElement psiElement = child;
        Object object = last = psiElement != null ? psiElement.getPrevSibling() : null;
        if (arrow != null && last != null) {
            PsiElement psiElement2 = whenEntry.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
            whenEntryConditionsData = new WhenEntryConditionsData(conditions, psiElement2, last, arrow);
        } else {
            whenEntryConditionsData = null;
        }
        return whenEntryConditionsData;
    }

    private static final Unit replaceCommasWithOrsInWhenExpression$lambda$0(WhenEntryConditionsData $conditionsData, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        $this$buildExpression.appendExpressions((Iterable)$conditionsData.getConditions(), "||");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/CommaInWhenConditionWithoutArgumentFix$WhenEntryConditionsData;", "", "conditions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "first", "Lcom/intellij/psi/PsiElement;", "last", "arrow", "<init>", "(Ljava/util/List;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "getConditions", "()Ljava/util/List;", "getFirst", "()Lcom/intellij/psi/PsiElement;", "getLast", "getArrow", "kotlin.fir.frontend-independent"})
    private static final class WhenEntryConditionsData {
        @NotNull
        private final List<KtExpression> conditions;
        @NotNull
        private final PsiElement first;
        @NotNull
        private final PsiElement last;
        @NotNull
        private final PsiElement arrow;

        public WhenEntryConditionsData(@NotNull List<? extends KtExpression> conditions, @NotNull PsiElement first2, @NotNull PsiElement last, @NotNull PsiElement arrow) {
            Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
            Intrinsics.checkNotNullParameter((Object)first2, (String)"first");
            Intrinsics.checkNotNullParameter((Object)last, (String)"last");
            Intrinsics.checkNotNullParameter((Object)arrow, (String)"arrow");
            this.conditions = conditions;
            this.first = first2;
            this.last = last;
            this.arrow = arrow;
        }

        @NotNull
        public final List<KtExpression> getConditions() {
            return this.conditions;
        }

        @NotNull
        public final PsiElement getFirst() {
            return this.first;
        }

        @NotNull
        public final PsiElement getLast() {
            return this.last;
        }

        @NotNull
        public final PsiElement getArrow() {
            return this.arrow;
        }
    }
}

