/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolInformationProviderKt;
import org.jetbrains.kotlin.analysis.api.components.KaSymbolRelationProviderKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaNamedSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.CallableImportCandidate;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ClassLikeImportCandidate;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.imprt.ImportCandidate;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.CallableIdKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"'\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004b\u00020\u0007\u008a\u0001\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"-\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00028@X\u0081\u0004b\u00020\u0007\u008a\u0001\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\"'\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u00158@X\u0080\u0004b\u00020\u0007\u008a\u0001\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"'\u0010&\u001a\u0004\u0018\u00010'*\u00020\u00158@X\u0080\u0004b\u00020\u0007\u008a\u0001\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;", "getName", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;)Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "<unused var>", "getFqName", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;)Lorg/jetbrains/kotlin/name/FqName;", "packageName", "getPackageName", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;)Lorg/jetbrains/kotlin/name/FqName;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ClassLikeImportCandidate;", "getClassId", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ClassLikeImportCandidate;)Lorg/jetbrains/kotlin/name/ClassId;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/CallableImportCandidate;", "getCallableId", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/CallableImportCandidate;)Lorg/jetbrains/kotlin/name/CallableId;", "psi", "Lcom/intellij/psi/PsiElement;", "getPsi", "(Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;)Lcom/intellij/psi/PsiElement;", "deprecationStatus", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "getDeprecationStatus$annotations", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;)V", "getDeprecationStatus", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/ImportCandidate;)Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "receiverType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "getReceiverType", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/CallableImportCandidate;)Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "containingClass", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "getContainingClass", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/imprt/CallableImportCandidate;)Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "intellij.kotlin.codeInsight.fixes"})
public final class ImportCandidateKt {
    @NotNull
    public static final Name getName(@NotNull ImportCandidate $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        KaDeclarationSymbol kaDeclarationSymbol = $this$name.getSymbol();
        Intrinsics.checkNotNull((Object)kaDeclarationSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.analysis.api.symbols.markers.KaNamedSymbol");
        return ((KaNamedSymbol)((Object)kaDeclarationSymbol)).getName();
    }

    @Nullable
    public static final FqName getFqName(@NotNull KaSession kaSession, @NotNull ImportCandidate $this$fqName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)$this$fqName, (String)"<this>");
        ImportCandidate importCandidate = $this$fqName;
        if (importCandidate instanceof CallableImportCandidate) {
            CallableId callableId = ImportCandidateKt.getCallableId((CallableImportCandidate)$this$fqName);
            object = callableId != null ? callableId.asSingleFqName() : null;
        } else if (importCandidate instanceof ClassLikeImportCandidate) {
            ClassId classId = ImportCandidateKt.getClassId((ClassLikeImportCandidate)$this$fqName);
            object = classId != null ? classId.asSingleFqName() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final FqName getPackageName(@NotNull ImportCandidate $this$packageName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$packageName, (String)"<this>");
        ImportCandidate importCandidate = $this$packageName;
        if (importCandidate instanceof CallableImportCandidate) {
            CallableId callableId = ImportCandidateKt.getCallableId((CallableImportCandidate)$this$packageName);
            object = callableId != null ? callableId.getPackageName() : null;
        } else if (importCandidate instanceof ClassLikeImportCandidate) {
            ClassId classId = ImportCandidateKt.getClassId((ClassLikeImportCandidate)$this$packageName);
            object = classId != null ? classId.getPackageFqName() : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public static final ClassId getClassId(@NotNull ClassLikeImportCandidate $this$classId) {
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        return $this$classId.getSymbol().getClassId();
    }

    @Nullable
    public static final CallableId getCallableId(@NotNull CallableImportCandidate $this$callableId) {
        Object object;
        ClassId dispatchObjectId;
        Intrinsics.checkNotNullParameter((Object)$this$callableId, (String)"<this>");
        CallableId originalId = $this$callableId.getSymbol().getCallableId();
        KaClassSymbol kaClassSymbol = $this$callableId.getDispatcherObject();
        Object object2 = dispatchObjectId = kaClassSymbol != null ? kaClassSymbol.getClassId() : null;
        if (dispatchObjectId != null) {
            CallableId callableId = originalId;
            object = callableId != null ? CallableIdKt.withClassId((CallableId)callableId, (ClassId)dispatchObjectId) : null;
        } else {
            object = originalId;
        }
        return object;
    }

    @Nullable
    public static final PsiElement getPsi(@NotNull ImportCandidate $this$psi) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$psi, (String)"<this>");
        ImportCandidate importCandidate = $this$psi;
        if (importCandidate instanceof CallableImportCandidate) {
            psiElement = ((CallableImportCandidate)$this$psi).getSymbol().getPsi();
        } else if (importCandidate instanceof ClassLikeImportCandidate) {
            psiElement = ((ClassLikeImportCandidate)$this$psi).getSymbol().getPsi();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return psiElement;
    }

    @Nullable
    public static final DeprecationInfo getDeprecationStatus(@NotNull KaSession kaSession, @NotNull ImportCandidate $this$deprecationStatus) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)$this$deprecationStatus, (String)"<this>");
        return KaSymbolInformationProviderKt.getDeprecationStatus(kaSession, $this$deprecationStatus.getSymbol());
    }

    @KaExperimentalApi
    public static /* synthetic */ void getDeprecationStatus$annotations(KaSession kaSession, ImportCandidate importCandidate) {
    }

    @Nullable
    public static final KaType getReceiverType(@NotNull KaSession kaSession, @NotNull CallableImportCandidate $this$receiverType) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)$this$receiverType, (String)"<this>");
        return KaCallableSymbolKt.getReceiverType($this$receiverType.getSymbol());
    }

    @Nullable
    public static final KaClassSymbol getContainingClass(@NotNull KaSession kaSession, @NotNull CallableImportCandidate $this$containingClass) {
        Intrinsics.checkNotNullParameter((Object)kaSession, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)$this$containingClass, (String)"<this>");
        KaClassSymbol kaClassSymbol = $this$containingClass.getDispatcherObject();
        if (kaClassSymbol == null) {
            KaSymbol kaSymbol = KaSymbolRelationProviderKt.getContainingSymbol(kaSession, KaSymbolRelationProviderKt.getFakeOverrideOriginal(kaSession, $this$containingClass.getSymbol()));
            kaClassSymbol = kaSymbol instanceof KaClassSymbol ? (KaClassSymbol)kaSymbol : null;
        }
        return kaClassSymbol;
    }
}

