/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.intentions.ConvertToIndexedFunctionCallIntentionKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToIndexedFunctionCallIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertToIndexedFunctionCallIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToIndexedFunctionCallIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertToIndexedFunctionCallIntention\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n464#2,14:111\n383#2,2:125\n395#2:127\n482#2:128\n1869#3,2:129\n*S KotlinDebug\n*F\n+ 1 ConvertToIndexedFunctionCallIntention.kt\norg/jetbrains/kotlin/idea/intentions/ConvertToIndexedFunctionCallIntention\n*L\n50#1:111,14\n50#1:125,2\n50#1:127\n50#1:128\n53#1:129,2\n*E\n"})
public final class ConvertToIndexedFunctionCallIntention
extends SelfTargetingRangeIntention<KtCallExpression> {
    public ConvertToIndexedFunctionCallIntention() {
        super(KtCallExpression.class, KotlinBundle.messagePointer((String)"convert.to.indexed.function.call", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getCalleeExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression callee = ktExpression;
        Pair pair = (Pair)ConvertToIndexedFunctionCallIntentionKt.access$getFunctions$p().get(callee.getText());
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        FqName functionFqName = (FqName)pair2.component1();
        String newFunctionName = (String)pair2.component2();
        if (KotlinCommonRefactoringUtilKt.singleLambdaArgumentExpression(element) == null) {
            return null;
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)element), (BindingContext)context2);
        if (!Intrinsics.areEqual((Object)functionFqName, resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall)) : null)) {
            return null;
        }
        Object[] objectArray = new Object[]{"'" + newFunctionName + "'"};
        this.setTextGetter(KotlinBundle.messagePointer((String)"convert.to.0", (Object[])objectArray));
        return callee.getTextRange();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtCallExpression element, @Nullable Editor editor) {
        void $this$forEach$iv;
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void to$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv$iv;
        Iterable $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element.getCalleeExpression();
        if (object == null || (object = object.getText()) == null) {
            return;
        }
        Object functionName = object;
        Pair pair = (Pair)ConvertToIndexedFunctionCallIntentionKt.access$getFunctions$p().get(functionName);
        if (pair == null) {
            return;
        }
        String newFunctionName = (String)pair.component2();
        KtLambdaExpression ktLambdaExpression = KotlinCommonRefactoringUtilKt.singleLambdaArgumentExpression(element);
        if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
            return;
        }
        KtLambdaExpression functionLiteral = ktLambdaExpression;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        BindingContext context2 = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL);
        PsiElement psiElement = (PsiElement)functionLiteral;
        Function1 predicate$iv = arg_0 -> ConvertToIndexedFunctionCallIntention.applyTo$lambda$0((String)functionName, context2, (KtFunctionLiteral)functionLiteral, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void var11_14 = $this$collectDescendantsOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var14_18 = $this$collectDescendantsOfType$iv$iv;
        Object[] objectArray = (Object[])new ArrayList();
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var18_22 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv$iv$iv, (Collection)to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        $this$collectDescendantsOfType$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression;
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl = false;
            KtExpression value = it.getReturnedExpression();
            if (value != null) {
                objectArray = new Object[]{value};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("return@" + newFunctionName + " $0"), (Object[])objectArray, (boolean)false, (int)4, null);
            } else {
                ktExpression = psiFactory.createExpression("return@" + newFunctionName);
            }
            KtExpression newLabeledReturn = ktExpression;
            it.replace((PsiElement)newLabeledReturn);
        }
        KtParameterList parameterList = KtPsiUtilKt.getOrCreateParameterList((KtFunctionLiteral)functionLiteral);
        List list2 = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        List parameters2 = list2;
        CollectingNameValidator nameValidator = new CollectingNameValidator(null, new Fe10KotlinNewDeclarationNameValidator((PsiElement)functionLiteral, null, KotlinNameSuggestionProvider.ValidatorTarget.PARAMETER, null, 8, null), 1, null);
        String indexParameterName = KotlinNameSuggester.Companion.suggestNameByName("index", (Function1<? super String, Boolean>)((Function1)nameValidator));
        KtParameter indexParameter = psiFactory.createParameter(indexParameterName);
        if (parameters2.isEmpty()) {
            parameterList.addParameter(indexParameter);
            String string = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
            v7 = parameterList.addParameter(psiFactory.createParameter(string));
        } else {
            v7 = parameterList.addParameterBefore(indexParameter, (KtParameter)CollectionsKt.first((List)parameters2));
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element));
        KtExpression callOrQualified = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)element;
        PsiElement result2 = callOrQualified.replace((PsiElement)CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> ConvertToIndexedFunctionCallIntention.applyTo$lambda$2(element, newFunctionName, arg_0), (int)1, null));
        CodeStyleManager.getInstance((Project)element.getProject()).reformat(result2);
    }

    private static final boolean applyTo$lambda$0(String $functionName, BindingContext $context, KtFunctionLiteral $functionLiteral, KtReturnExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getLabelName(), (Object)$functionName) && Intrinsics.areEqual((Object)BindingContextUtilsKt.getTargetFunction((KtReturnExpression)it, (BindingContext)$context), (Object)$functionLiteral);
    }

    private static final Unit applyTo$lambda$2(KtCallExpression $element, String $newFunctionName, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        KotlinCommonRefactoringUtilKt.appendCallOrQualifiedExpression((BuilderByPattern<KtExpression>)$this$buildExpression, $element, $newFunctionName);
        return Unit.INSTANCE;
    }
}

