/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinJvmAnnotationInJavaInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/JavaElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "RemoveAnnotationFix", "kotlin.idea"})
public final class KotlinJvmAnnotationInJavaInspection
extends LocalInspectionTool {
    @NotNull
    public JavaElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return new JavaElementVisitor(holder2){
            private final String KOTLIN_JVM_PACKAGE;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                this.KOTLIN_JVM_PACKAGE = "kotlin.jvm.";
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                String string = annotation.getQualifiedName();
                if (string == null) {
                    return;
                }
                String qualifiedName = string;
                if (StringsKt.startsWith$default((String)qualifiedName, (String)this.KOTLIN_JVM_PACKAGE, (boolean)false, (int)2, null)) {
                    String annotationName = StringsKt.removePrefix((String)qualifiedName, (CharSequence)this.KOTLIN_JVM_PACKAGE);
                    Object[] objectArray = new Object[]{"@" + annotationName};
                    String string2 = KotlinBundle.message((String)"inspection.kotlin.jvm.annotation.in.java.description", (Object[])objectArray);
                    objectArray = new LocalQuickFix[]{new RemoveAnnotationFix()};
                    this.$holder.registerProblem((PsiElement)annotation, string2, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinJvmAnnotationInJavaInspection$RemoveAnnotationFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class RemoveAnnotationFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message((String)"fix.remove.annotation.text", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            descriptor2.getPsiElement().delete();
        }
    }
}

