/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\u0006\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u0004*\u00020\u0006\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\u000f\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0004*\u00020\u0006\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\b\u001a'\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00062\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0017\u001a'\u0010\u0018\u001a\u0004\u0018\u00010\u0014*\u00020\u00062\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0017\u001a+\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u001b\u0010\u001c\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u001d*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u0004\"\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000b\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"findGradleProjectStructure", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "DEFAULT_SCRIPT_NAME", "", "SETTINGS_FILE_NAME", "KOTLIN_BUILD_SCRIPT_NAME", "KOTLIN_SETTINGS_SCRIPT_NAME", "getBuildScriptPsiFile", "getBuildScriptSettingsPsiFile", "getTopLevelBuildScriptPsiFile", "Lcom/intellij/openapi/project/Project;", "getTopLevelBuildScriptSettingsPsiFile", "project", "externalProjectPath", "getBuildScriptFile", "Ljava/nio/file/Path;", "fileNames", "", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)Ljava/nio/file/Path;", "getBuildScriptSettingsFile", "findBuildGradleFile", "path", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getPsiFile", "Lorg/jetbrains/annotations/Nullable;", "canBeConfigured", "", "intellij.kotlin.gradle.codeInsight.common"})
@JvmName(name="KotlinGradleCodeInsightUtils")
@SourceDebugExtension(value={"SMAP\nKotlinGradleCodeInsightUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinGradleCodeInsightUtils.kt\norg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinGradleCodeInsightUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,112:1\n1#2:113\n183#3,2:114\n*S KotlinDebug\n*F\n+ 1 KotlinGradleCodeInsightUtils.kt\norg/jetbrains/kotlin/idea/gradleCodeInsightCommon/KotlinGradleCodeInsightUtils\n*L\n106#1:114,2\n*E\n"})
public final class KotlinGradleCodeInsightUtils {
    @NonNls
    @NotNull
    private static final String DEFAULT_SCRIPT_NAME = "build.gradle";
    @NonNls
    @NotNull
    private static final String SETTINGS_FILE_NAME = "settings.gradle";
    @NonNls
    @NotNull
    private static final String KOTLIN_BUILD_SCRIPT_NAME = "build.gradle.kts";
    @NonNls
    @NotNull
    private static final String KOTLIN_SETTINGS_SCRIPT_NAME = "settings.gradle.kts";

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull PsiFile file) {
        DataNode<ProjectData> dataNode;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file.getVirtualFile(), (Project)file.getProject());
        if (module != null) {
            Module it = module;
            boolean bl = false;
            dataNode = KotlinGradleCodeInsightUtils.findGradleProjectStructure(it);
        } else {
            dataNode = null;
        }
        return dataNode;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)externalProjectPath);
        if (externalProjectInfo == null) {
            return null;
        }
        ExternalProjectInfo projectInfo = externalProjectInfo;
        return projectInfo.getExternalProjectStructure();
    }

    @Nullable
    public static final PsiFile getBuildScriptPsiFile(@NotNull Module $this$getBuildScriptPsiFile) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildScriptPsiFile, (String)"<this>");
        String[] stringArray = new String[]{DEFAULT_SCRIPT_NAME, KOTLIN_BUILD_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.getBuildScriptFile($this$getBuildScriptPsiFile, stringArray);
        if (path2 != null) {
            Project project = $this$getBuildScriptPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiFile = KotlinGradleCodeInsightUtils.getPsiFile(path2, project);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public static final PsiFile getBuildScriptSettingsPsiFile(@NotNull Module $this$getBuildScriptSettingsPsiFile) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildScriptSettingsPsiFile, (String)"<this>");
        String[] stringArray = new String[]{SETTINGS_FILE_NAME, KOTLIN_SETTINGS_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.getBuildScriptSettingsFile($this$getBuildScriptSettingsPsiFile, stringArray);
        if (path2 != null) {
            Project project = $this$getBuildScriptSettingsPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            psiFile = KotlinGradleCodeInsightUtils.getPsiFile(path2, project);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptPsiFile(@NotNull Project $this$getTopLevelBuildScriptPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelBuildScriptPsiFile, (String)"<this>");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$getTopLevelBuildScriptPsiFile);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile projectDir = virtualFile;
        String string = projectDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String[] stringArray = new String[]{DEFAULT_SCRIPT_NAME, KOTLIN_BUILD_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.findBuildGradleFile(string, stringArray);
        return path2 != null ? KotlinGradleCodeInsightUtils.getPsiFile(path2, $this$getTopLevelBuildScriptPsiFile) : null;
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptSettingsPsiFile(@NotNull Module $this$getTopLevelBuildScriptSettingsPsiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelBuildScriptSettingsPsiFile, (String)"<this>");
        String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)$this$getTopLevelBuildScriptSettingsPsiFile);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        Project project = $this$getTopLevelBuildScriptSettingsPsiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return KotlinGradleCodeInsightUtils.getTopLevelBuildScriptSettingsPsiFile(project, externalProjectPath);
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptSettingsPsiFile(@NotNull Project project, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        String[] stringArray = new String[]{SETTINGS_FILE_NAME, KOTLIN_SETTINGS_SCRIPT_NAME};
        Path path2 = KotlinGradleCodeInsightUtils.findBuildGradleFile(externalProjectPath, stringArray);
        return path2 != null ? KotlinGradleCodeInsightUtils.getPsiFile(path2, project) : null;
    }

    private static final Path getBuildScriptFile(Module $this$getBuildScriptFile, String ... fileNames) {
        Path it2;
        Path path2 = $this$getBuildScriptFile.getModuleNioFile().getParent();
        if (path2 != null) {
            Path moduleDir = path2;
            boolean bl = false;
            Path path3 = KotlinGradleCodeInsightUtils.findBuildGradleFile(((Object)moduleDir).toString(), Arrays.copyOf(fileNames, fileNames.length));
            if (path3 != null) {
                Path it2 = path3;
                boolean bl2 = false;
                return it2;
            }
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)$this$getBuildScriptFile).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        for (VirtualFile contentRoot : virtualFileArray) {
            String string = contentRoot.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            it2 = KotlinGradleCodeInsightUtils.findBuildGradleFile(string, Arrays.copyOf(fileNames, fileNames.length));
            if (it2 == null) continue;
            Path it3 = it2;
            boolean bl = false;
            return it3;
        }
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptFile);
        if (string != null) {
            String externalProjectPath = string;
            boolean bl = false;
            Path path4 = KotlinGradleCodeInsightUtils.findBuildGradleFile(externalProjectPath, Arrays.copyOf(fileNames, fileNames.length));
            if (path4 != null) {
                it2 = path4;
                boolean bl3 = false;
                return it2;
            }
        }
        return null;
    }

    private static final Path getBuildScriptSettingsFile(Module $this$getBuildScriptSettingsFile, String ... fileNames) {
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptSettingsFile);
        if (string != null) {
            String externalProjectPath = string;
            boolean bl = false;
            return (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)externalProjectPath, KotlinGradleCodeInsightUtils::getBuildScriptSettingsFile$lambda$0$0), arg_0 -> KotlinGradleCodeInsightUtils.getBuildScriptSettingsFile$lambda$0$1(fileNames, arg_0)));
        }
        return null;
    }

    private static final Path findBuildGradleFile(String path2, String ... fileNames) {
        Object v1;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])fileNames), arg_0 -> KotlinGradleCodeInsightUtils.findBuildGradleFile$lambda$0(path2, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path p0 = (Path)element$iv;
                boolean $i$f$findBuildGradleFile$exists = false;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final PsiFile getPsiFile(Path $this$getPsiFile, Project project) {
        PsiFile psiFile;
        VirtualFile virtualFile = VfsUtil.findFile((Path)$this$getPsiFile, (boolean)true);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            psiFile = PsiManager.getInstance((Project)project).findFile(it);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    public static final boolean canBeConfigured(@NotNull PsiFile $this$canBeConfigured) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeConfigured, (String)"<this>");
        return WritingAccessProvider.isPotentiallyWritable((VirtualFile)$this$canBeConfigured.getVirtualFile(), null);
    }

    private static final String getBuildScriptSettingsFile$lambda$0$0(String it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence2 = PathUtil.getParentPath((String)it);
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final Path getBuildScriptSettingsFile$lambda$0$1(String[] $fileNames, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KotlinGradleCodeInsightUtils.findBuildGradleFile(it, Arrays.copyOf($fileNames, $fileNames.length));
    }

    private static final Path findBuildGradleFile$lambda$0(String $path, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path2 = Paths.get($path + "/" + it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return path2;
    }
}

