/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.core.IterableTypesDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ForLoopConventionsChecker;
import org.jetbrains.kotlin.util.ModifierChecksKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection;", "", "project", "Lcom/intellij/openapi/project/Project;", "forLoopConventionsChecker", "Lorg/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/types/expressions/ForLoopConventionsChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "createDetector", "Lorg/jetbrains/kotlin/idea/core/IterableTypesDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "Companion", "Detector", "kotlin.base.fe10.analysis"})
public final class IterableTypesDetection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ForLoopConventionsChecker forLoopConventionsChecker;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private static final Name iteratorName;

    public IterableTypesDetection(@NotNull Project project, @NotNull ForLoopConventionsChecker forLoopConventionsChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)forLoopConventionsChecker, (String)"forLoopConventionsChecker");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.project = project;
        this.forLoopConventionsChecker = forLoopConventionsChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final IterableTypesDetector createDetector(@NotNull LexicalScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new Detector(scope);
    }

    static {
        Name name2 = Name.identifier((String)"iterator");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        iteratorName = name2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection$Companion;", "", "<init>", "()V", "iteratorName", "Lorg/jetbrains/kotlin/name/Name;", "kotlin.base.fe10.analysis"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector;", "Lorg/jetbrains/kotlin/idea/core/IterableTypesDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "<init>", "(Lorg/jetbrains/kotlin/idea/core/IterableTypesDetection;Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;)V", "cache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "typesWithExtensionIterator", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isIterable", "", "type", "loopVarType", "elementType", "elementTypeNoCache", "canBeIterable", "kotlin.base.fe10.analysis"})
    @SourceDebugExtension(value={"SMAP\nIterableTypesDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IterableTypesDetection.kt\norg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 collections.kt\norg/jetbrains/kotlin/utils/CollectionsKt\n*L\n1#1,95:1\n774#2:96\n865#2,2:97\n1617#2,9:99\n1869#2:108\n1870#2:110\n1626#2:111\n1761#2,2:119\n1617#2,9:121\n1869#2:130\n1870#2:132\n1626#2:133\n1763#2:134\n1#3:109\n1#3:131\n48#4,7:112\n*S KotlinDebug\n*F\n+ 1 IterableTypesDetection.kt\norg/jetbrains/kotlin/idea/core/IterableTypesDetection$Detector\n*L\n47#1:96\n47#1:97,2\n48#1:99,9\n48#1:108\n48#1:110\n48#1:111\n80#1:119,2\n81#1:121,9\n81#1:130\n81#1:132\n81#1:133\n80#1:134\n48#1:109\n81#1:131\n59#1:112,7\n*E\n"})
    private final class Detector
    implements IterableTypesDetector {
        @NotNull
        private final LexicalScope scope;
        @NotNull
        private final HashMap<FuzzyType, FuzzyType> cache;
        @NotNull
        private final Collection<KotlinType> typesWithExtensionIterator;

        /*
         * WARNING - void declaration
         */
        public Detector(LexicalScope scope) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.scope = scope;
            this.cache = new HashMap();
            Iterable iterable = ScopeUtilsKt.collectFunctions((HierarchicalScope)((HierarchicalScope)this.scope), (Name)iteratorName, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE));
            Detector detector = this;
            boolean $i$f$filter = false;
            void var5_6 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl = false;
                if (!ModifierChecksKt.isValidOperator((FunctionDescriptor)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FunctionDescriptor it = (FunctionDescriptor)element$iv$iv;
                boolean bl2 = false;
                ReceiverParameterDescriptor receiverParameterDescriptor = it.getExtensionReceiverParameter();
                if ((receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            detector.typesWithExtensionIterator = (List)destination$iv$iv;
        }

        @Override
        public boolean isIterable(@NotNull FuzzyType type2, @Nullable KotlinType loopVarType) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            FuzzyType fuzzyType = this.elementType(type2);
            if (fuzzyType == null) {
                return false;
            }
            FuzzyType elementType = fuzzyType;
            return loopVarType == null || elementType.checkIsSubtypeOf(loopVarType) != null;
        }

        @Override
        public boolean isIterable(@NotNull KotlinType type2, @Nullable KotlinType loopVarType) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.isIterable(FuzzyTypeUtils.toFuzzyType(type2, CollectionsKt.emptyList()), loopVarType);
        }

        /*
         * WARNING - void declaration
         */
        private final FuzzyType elementType(FuzzyType type2) {
            Object object;
            void $this$getOrPutNullable$iv;
            Map map2 = this.cache;
            FuzzyType key$iv = type2;
            boolean $i$f$getOrPutNullable = false;
            if (!$this$getOrPutNullable$iv.containsKey(key$iv)) {
                boolean bl = false;
                FuzzyType answer$iv = this.elementTypeNoCache(type2);
                $this$getOrPutNullable$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = $this$getOrPutNullable$iv.get(key$iv);
            }
            return (FuzzyType)object;
        }

        @Override
        @Nullable
        public FuzzyType elementType(@NotNull KotlinType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.elementType(FuzzyTypeUtils.toFuzzyType(type2, CollectionsKt.emptyList()));
        }

        private final FuzzyType elementTypeNoCache(FuzzyType type2) {
            KotlinType elementType;
            if (!this.canBeIterable(type2)) {
                return null;
            }
            KtExpression expression = new KtPsiFactory(IterableTypesDetection.this.project, false, 2, null).createExpression("fake");
            ExpressionTypingContext expressionTypingContext = ExpressionTypingContext.newContext((BindingTrace)((BindingTrace)new BindingTraceContext(IterableTypesDetection.this.project)), (LexicalScope)this.scope, (DataFlowInfo)DataFlowInfo.Companion.getEMPTY(), (KotlinType)((KotlinType)TypeUtils.NO_EXPECTED_TYPE), (LanguageVersionSettings)IterableTypesDetection.this.languageVersionSettings, (DataFlowValueFactory)IterableTypesDetection.this.dataFlowValueFactory);
            Intrinsics.checkNotNullExpressionValue((Object)expressionTypingContext, (String)"newContext(...)");
            ExpressionTypingContext context2 = expressionTypingContext;
            KotlinType kotlinType = type2.getType();
            BindingContext bindingContext = context2.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
            ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(expression, kotlinType, bindingContext);
            KotlinType kotlinType2 = elementType = IterableTypesDetection.this.forLoopConventionsChecker.checkIterableConvention(expressionReceiver, context2);
            return kotlinType2 != null ? FuzzyTypeUtils.toFuzzyType(kotlinType2, (Collection<? extends TypeParameterDescriptor>)type2.getFreeParameters()) : null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean canBeIterable(FuzzyType type2) {
            boolean bl;
            if (type2.getType().getConstructor() instanceof IntegerLiteralTypeConstructor) {
                return false;
            }
            if (!type2.getType().getMemberScope().getContributedFunctions(iteratorName, (LookupLocation)NoLookupLocation.FROM_IDE).isEmpty()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
            Iterable $this$any$iv = this.typesWithExtensionIterator;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                void $this$mapNotNullTo$iv$iv;
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KotlinType it = (KotlinType)element$iv;
                boolean bl3 = false;
                Iterable $this$mapNotNull$iv = it.getArguments();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    TypeParameterDescriptor it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl4 = false;
                    TypeProjection it2 = (TypeProjection)element$iv$iv;
                    boolean bl5 = false;
                    ClassifierDescriptor classifierDescriptor = it2.getType().getConstructor().getDeclarationDescriptor();
                    if ((classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List freeParams = (List)destination$iv$iv;
                if (type2.checkIsSubtypeOf(FuzzyTypeUtils.toFuzzyType(it, freeParams)) != null) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
    }
}

