/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.KotlinArtifactConstants;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.LazyZipUnpacker;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinArtifactsDownloader;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinMavenUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayoutMode;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayoutModeProvider;
import org.jetbrains.kotlin.idea.testFramework.TestKotlinArtifactsProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u0011\u001a\u00020\u00128FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d\u00b2\u0006\n\u0010\u001e\u001a\u00020\u001fX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinPluginLayout;", "", "<init>", "()V", "kotlinc", "Ljava/io/File;", "getKotlinc$annotations", "getKotlinc", "()Ljava/io/File;", "jpsPluginClasspath", "", "getJpsPluginClasspath", "()Ljava/util/List;", "jsEngines", "getJsEngines", "jsEngines$delegate", "Lkotlin/Lazy;", "standaloneCompilerVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getStandaloneCompilerVersion$annotations", "getStandaloneCompilerVersion", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "ideCompilerVersion", "getIdeCompilerVersion$annotations", "getIdeCompilerVersion", "kotlincProvider", "Lkotlin/Lazy;", "jpsPluginClasspathProvider", "standaloneCompilerVersionProvider", "intellij.kotlin.base.plugin", "bundledJpsVersion", ""})
@SourceDebugExtension(value={"SMAP\nKotlinPluginLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPluginLayout.kt\norg/jetbrains/kotlin/idea/compiler/configuration/KotlinPluginLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1#2:175\n1563#3:176\n1634#3,3:177\n*S KotlinDebug\n*F\n+ 1 KotlinPluginLayout.kt\norg/jetbrains/kotlin/idea/compiler/configuration/KotlinPluginLayout\n*L\n119#1:176\n119#1:177,3\n*E\n"})
public final class KotlinPluginLayout {
    @NotNull
    public static final KotlinPluginLayout INSTANCE = new KotlinPluginLayout();
    @NotNull
    private static final Lazy jsEngines$delegate = LazyKt.lazy(KotlinPluginLayout::jsEngines_delegate$lambda$0);
    @NotNull
    private static final IdeKotlinVersion ideCompilerVersion;
    @NotNull
    private static final Lazy<File> kotlincProvider;
    @NotNull
    private static final Lazy<List<File>> jpsPluginClasspathProvider;
    @NotNull
    private static final Lazy<IdeKotlinVersion> standaloneCompilerVersionProvider;

    private KotlinPluginLayout() {
    }

    @NotNull
    public static final File getKotlinc() {
        return (File)kotlincProvider.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getKotlinc$annotations() {
    }

    @NotNull
    public final List<File> getJpsPluginClasspath() {
        return (List)jpsPluginClasspathProvider.getValue();
    }

    @Nullable
    public final File getJsEngines() {
        Lazy lazy = jsEngines$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public static final IdeKotlinVersion getStandaloneCompilerVersion() {
        return (IdeKotlinVersion)standaloneCompilerVersionProvider.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getStandaloneCompilerVersion$annotations() {
    }

    @NotNull
    public static final IdeKotlinVersion getIdeCompilerVersion() {
        return ideCompilerVersion;
    }

    @JvmStatic
    public static /* synthetic */ void getIdeCompilerVersion$annotations() {
    }

    private static final File jsEngines_delegate$lambda$0() {
        File file;
        File it = file = FilesKt.resolve((File)FilesKt.resolve((File)KotlinPluginLayout.getKotlinc(), (String)"lib"), (String)"js.engines.jar");
        boolean bl = false;
        return it.exists() ? file : null;
    }

    private static final IdeKotlinVersion _init_$lambda$0() {
        String rawVersion = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)FilesKt.resolve((File)KotlinPluginLayout.getKotlinc(), (String)"build.txt"), null, (int)1, null))).toString();
        return IdeKotlinVersion.Companion.get(rawVersion);
    }

    private static final File _init_$lambda$1(TestKotlinArtifactsProvider $provider) {
        return $provider.getKotlincCompilerCli().toFile();
    }

    /*
     * WARNING - void declaration
     */
    private static final List _init_$lambda$2(TestKotlinArtifactsProvider $provider) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $provider.getJpsPluginClasspath();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toFile());
        }
        return (List)destination$iv$iv;
    }

    private static final String _init_$lambda$3() {
        return KotlinMavenUtils.INSTANCE.findLibraryVersion("kotlinc_kotlin_dist.xml");
    }

    private static final String _init_$lambda$4(Lazy<String> $bundledJpsVersion$delegate) {
        Lazy<String> lazy = $bundledJpsVersion$delegate;
        return (String)lazy.getValue();
    }

    private static final File _init_$lambda$5(Lazy $bundledJpsVersion$delegate) {
        File file = KotlinArtifactsDownloader.downloadArtifactForIdeFromSources$default(KotlinArtifactsDownloader.INSTANCE, "kotlin-dist-for-ide", KotlinPluginLayout._init_$lambda$4((Lazy<String>)$bundledJpsVersion$delegate), null, 4, null);
        if (file == null) {
            throw new IllegalStateException("Can't download dist".toString());
        }
        File distJar = file;
        File unpackedDistDir = FilesKt.resolve((File)KotlinArtifactConstants.INSTANCE.getKOTLIN_DIST_LOCATION_PREFIX(), (String)"kotlinc-dist-for-ide-from-sources");
        return new LazyZipUnpacker(unpackedDistDir).lazyUnpack(distJar);
    }

    private static final List _init_$lambda$6(Lazy $bundledJpsVersion$delegate) {
        Path jpsPluginArtifact = KotlinMavenUtils.INSTANCE.findArtifactOrFail("org.jetbrains.kotlin", "kotlin-jps-plugin-classpath", KotlinPluginLayout._init_$lambda$4((Lazy<String>)$bundledJpsVersion$delegate));
        return CollectionsKt.listOf((Object)jpsPluginArtifact.toFile());
    }

    private static final File _init_$resolve(Path kotlinPluginRoot, String path2) {
        Path path3;
        Path it = path3 = kotlinPluginRoot.resolve(path2);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean bl2 = false;
            String string = it + " doesn't exist";
            throw new IllegalStateException(string.toString());
        }
        return path3.toFile();
    }

    private static final File _init_$lambda$8(Path $kotlinPluginRoot) {
        return KotlinPluginLayout._init_$resolve($kotlinPluginRoot, "kotlinc");
    }

    private static final List _init_$lambda$9(Path $kotlinPluginRoot) {
        return CollectionsKt.listOf((Object)KotlinPluginLayout._init_$resolve($kotlinPluginRoot, "lib/jps/kotlin-jps-plugin.jar"));
    }

    private static final IdeKotlinVersion _init_$lambda$10() {
        return ideCompilerVersion;
    }

    static {
        String string = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VERSION");
        ideCompilerVersion = IdeKotlinVersion.Companion.get(string);
        Lazy standaloneCompilerVersionDefaultProvider = LazyKt.lazy(KotlinPluginLayout::_init_$lambda$0);
        switch (WhenMappings.$EnumSwitchMapping$0[KotlinPluginLayoutModeProvider.INSTANCE.getKotlinPluginLayoutMode().ordinal()]) {
            case 1: {
                if (PluginManagerCore.isUnitTestMode) {
                    ServiceLoader<TestKotlinArtifactsProvider> serviceLoader = ServiceLoader.load(TestKotlinArtifactsProvider.class);
                    Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
                    TestKotlinArtifactsProvider testKotlinArtifactsProvider = (TestKotlinArtifactsProvider)CollectionsKt.singleOrNull((Iterable)serviceLoader);
                    if (testKotlinArtifactsProvider == null) {
                        throw new IllegalStateException("TestKotlinArtifacts service provider is not found. Expected ...".toString());
                    }
                    TestKotlinArtifactsProvider provider2 = testKotlinArtifactsProvider;
                    kotlincProvider = LazyKt.lazy(() -> KotlinPluginLayout._init_$lambda$1(provider2));
                    jpsPluginClasspathProvider = LazyKt.lazy(() -> KotlinPluginLayout._init_$lambda$2(provider2));
                    standaloneCompilerVersionProvider = standaloneCompilerVersionDefaultProvider;
                    break;
                }
                Lazy bundledJpsVersion$delegate = LazyKt.lazy(KotlinPluginLayout::_init_$lambda$3);
                kotlincProvider = LazyKt.lazy(() -> KotlinPluginLayout._init_$lambda$5(bundledJpsVersion$delegate));
                jpsPluginClasspathProvider = LazyKt.lazy(() -> KotlinPluginLayout._init_$lambda$6(bundledJpsVersion$delegate));
                standaloneCompilerVersionProvider = standaloneCompilerVersionDefaultProvider;
                break;
            }
            case 2: {
                Path path2 = PluginManagerCoreKt.getPluginDistDirByClass(KotlinPluginLayout.class);
                if (path2 == null) {
                    throw new IllegalStateException(("Can't find jar file for " + Reflection.getOrCreateKotlinClass(KotlinPluginLayout.class).getSimpleName()).toString());
                }
                Path kotlinPluginRoot = path2;
                kotlincProvider = LazyKt.lazy(() -> KotlinPluginLayout._init_$lambda$8(kotlinPluginRoot));
                jpsPluginClasspathProvider = LazyKt.lazy(() -> KotlinPluginLayout._init_$lambda$9(kotlinPluginRoot));
                standaloneCompilerVersionProvider = standaloneCompilerVersionDefaultProvider;
                break;
            }
            case 3: {
                kotlincProvider = LazyKt.lazy((Function0)7.INSTANCE);
                jpsPluginClasspathProvider = LazyKt.lazy((Function0)8.INSTANCE);
                standaloneCompilerVersionProvider = LazyKt.lazy(KotlinPluginLayout::_init_$lambda$10);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!(KotlinPluginLayout.getStandaloneCompilerVersion().getKotlinVersion().compareTo(ideCompilerVersion.getKotlinVersion()) <= 0)) {
            boolean bl = false;
            String string2 = "standaloneCompilerVersion: " + KotlinPluginLayout.getStandaloneCompilerVersion() + ", ideCompilerVersion: " + ideCompilerVersion;
            throw new IllegalStateException(string2.toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinPluginLayoutMode.values().length];
            try {
                nArray[KotlinPluginLayoutMode.SOURCES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinPluginLayoutMode.INTELLIJ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinPluginLayoutMode.LSP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

