/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/LoopToCollectionTransformUtils;", "", "<init>", "()V", "findSingleArrayAccessUsage", "Lorg/jetbrains/kotlin/idea/codeinsight/utils/LoopToCollectionTransformUtils$LoopUsageInfo;", "loopParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "transformLoop", "", "project", "Lcom/intellij/openapi/project/Project;", "usageInfo", "loopRange", "Lorg/jetbrains/kotlin/psi/KtExpression;", "newLoopRange", "LoopUsageInfo", "intellij.kotlin.codeInsight.utils"})
@ApiStatus.Internal
public final class LoopToCollectionTransformUtils {
    @NotNull
    public static final LoopToCollectionTransformUtils INSTANCE = new LoopToCollectionTransformUtils();

    private LoopToCollectionTransformUtils() {
    }

    @Nullable
    public final LoopUsageInfo findSingleArrayAccessUsage(@NotNull KtParameter loopParameter2) {
        Intrinsics.checkNotNullParameter((Object)loopParameter2, (String)"loopParameter");
        PsiElement psiElement = loopParameter2.getOriginalElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement paramElement = psiElement;
        PsiReference psiReference = (PsiReference)CollectionsKt.singleOrNull((Iterable)ReferencesSearch.search((PsiElement)paramElement).findAll());
        if (psiReference == null || (psiReference = psiReference.getElement()) == null) {
            return null;
        }
        PsiReference usageElement = psiReference;
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtContainerNode.class)};
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)usageElement), kClassArray, Reflection.getOrCreateKotlinClass(KtArrayAccessExpression.class));
        if (ktArrayAccessExpression == null) {
            return null;
        }
        KtArrayAccessExpression arrayAccessElement = ktArrayAccessExpression;
        return new LoopUsageInfo((KtParameter)paramElement, (PsiElement)usageElement, arrayAccessElement);
    }

    public final void transformLoop(@NotNull Project project, @NotNull LoopUsageInfo usageInfo, @NotNull KtParameter loopParameter2, @NotNull KtExpression loopRange, @NotNull KtExpression newLoopRange) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        Intrinsics.checkNotNullParameter((Object)loopParameter2, (String)"loopParameter");
        Intrinsics.checkNotNullParameter((Object)loopRange, (String)"loopRange");
        Intrinsics.checkNotNullParameter((Object)newLoopRange, (String)"newLoopRange");
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtParameter newParameter = factory2.createLoopParameter("element");
        KtExpression newReferenceExpression = factory2.createExpression("element");
        usageInfo.getArrayAccessElement().replace((PsiElement)newReferenceExpression);
        loopParameter2.replace((PsiElement)newParameter);
        loopRange.replace((PsiElement)newLoopRange);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/utils/LoopToCollectionTransformUtils$LoopUsageInfo;", "", "paramElement", "Lorg/jetbrains/kotlin/psi/KtParameter;", "usageElement", "Lcom/intellij/psi/PsiElement;", "arrayAccessElement", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;)V", "getParamElement", "()Lorg/jetbrains/kotlin/psi/KtParameter;", "getUsageElement", "()Lcom/intellij/psi/PsiElement;", "getArrayAccessElement", "()Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.codeInsight.utils"})
    public static final class LoopUsageInfo {
        @NotNull
        private final KtParameter paramElement;
        @NotNull
        private final PsiElement usageElement;
        @NotNull
        private final KtArrayAccessExpression arrayAccessElement;

        public LoopUsageInfo(@NotNull KtParameter paramElement, @NotNull PsiElement usageElement, @NotNull KtArrayAccessExpression arrayAccessElement) {
            Intrinsics.checkNotNullParameter((Object)paramElement, (String)"paramElement");
            Intrinsics.checkNotNullParameter((Object)usageElement, (String)"usageElement");
            Intrinsics.checkNotNullParameter((Object)arrayAccessElement, (String)"arrayAccessElement");
            this.paramElement = paramElement;
            this.usageElement = usageElement;
            this.arrayAccessElement = arrayAccessElement;
        }

        @NotNull
        public final KtParameter getParamElement() {
            return this.paramElement;
        }

        @NotNull
        public final PsiElement getUsageElement() {
            return this.usageElement;
        }

        @NotNull
        public final KtArrayAccessExpression getArrayAccessElement() {
            return this.arrayAccessElement;
        }

        @NotNull
        public final KtParameter component1() {
            return this.paramElement;
        }

        @NotNull
        public final PsiElement component2() {
            return this.usageElement;
        }

        @NotNull
        public final KtArrayAccessExpression component3() {
            return this.arrayAccessElement;
        }

        @NotNull
        public final LoopUsageInfo copy(@NotNull KtParameter paramElement, @NotNull PsiElement usageElement, @NotNull KtArrayAccessExpression arrayAccessElement) {
            Intrinsics.checkNotNullParameter((Object)paramElement, (String)"paramElement");
            Intrinsics.checkNotNullParameter((Object)usageElement, (String)"usageElement");
            Intrinsics.checkNotNullParameter((Object)arrayAccessElement, (String)"arrayAccessElement");
            return new LoopUsageInfo(paramElement, usageElement, arrayAccessElement);
        }

        public static /* synthetic */ LoopUsageInfo copy$default(LoopUsageInfo loopUsageInfo, KtParameter ktParameter, PsiElement psiElement, KtArrayAccessExpression ktArrayAccessExpression, int n, Object object) {
            if ((n & 1) != 0) {
                ktParameter = loopUsageInfo.paramElement;
            }
            if ((n & 2) != 0) {
                psiElement = loopUsageInfo.usageElement;
            }
            if ((n & 4) != 0) {
                ktArrayAccessExpression = loopUsageInfo.arrayAccessElement;
            }
            return loopUsageInfo.copy(ktParameter, psiElement, ktArrayAccessExpression);
        }

        @NotNull
        public String toString() {
            return "LoopUsageInfo(paramElement=" + this.paramElement + ", usageElement=" + this.usageElement + ", arrayAccessElement=" + this.arrayAccessElement + ")";
        }

        public int hashCode() {
            int result2 = this.paramElement.hashCode();
            result2 = result2 * 31 + this.usageElement.hashCode();
            result2 = result2 * 31 + this.arrayAccessElement.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopUsageInfo)) {
                return false;
            }
            LoopUsageInfo loopUsageInfo = (LoopUsageInfo)other;
            if (!Intrinsics.areEqual((Object)this.paramElement, (Object)loopUsageInfo.paramElement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.usageElement, (Object)loopUsageInfo.usageElement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.arrayAccessElement, (Object)loopUsageInfo.arrayAccessElement);
        }
    }
}

