/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight.copyPaste;

import com.intellij.CommonBundle;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.kotlin.idea.base.codeInsight.copyPaste.KotlinImportListRenderer;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;

public class RestoreReferencesDialog
extends DialogWrapper {
    private final Object[] myNamedElements;
    private final boolean myInRemoveMode;
    private JList myList;
    private Object[] mySelectedElements = PsiClass.EMPTY_ARRAY;
    private boolean myContainsClassesOnly = true;

    public RestoreReferencesDialog(Project project, Object[] elements, boolean inRemoveMode) {
        super(project, true);
        this.myNamedElements = elements;
        this.myInRemoveMode = inRemoveMode;
        for (Object element : elements) {
            if (element instanceof PsiClass) continue;
            this.myContainsClassesOnly = false;
            break;
        }
        if (this.myContainsClassesOnly) {
            this.setTitle(JavaBundle.message((String)"dialog.import.on.paste.title", (Object[])new Object[0]));
        } else {
            this.setTitle(JavaBundle.message((String)"dialog.import.on.paste.title2", (Object[])new Object[0]));
        }
        this.init();
        this.myList.setSelectionInterval(0, this.myNamedElements.length - 1);
    }

    public RestoreReferencesDialog(Project project, Object[] elements) {
        this(project, elements, false);
    }

    protected void doOKAction() {
        this.mySelectedElements = this.myList.getSelectedValuesList().toArray(new Object[0]);
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 4));
        this.myList = new JBList(this.myNamedElements);
        this.myList.setCellRenderer(new KotlinImportListRenderer());
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myList), "Center");
        String text = this.myInRemoveMode ? KotlinBundle.message((String)"copy.paste.select.imports.to.remove.text", (Object[])new Object[0]) : (this.myContainsClassesOnly ? JavaBundle.message((String)"dialog.paste.on.import.text", (Object[])new Object[0]) : JavaBundle.message((String)"dialog.paste.on.import.text2", (Object[])new Object[0]));
        panel.add((Component)new JBLabel(text, UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), "North");
        JPanel buttonPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JButton okButton = new JButton(CommonBundle.getOkButtonText());
        this.getRootPane().setDefaultButton(okButton);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(CommonBundle.getCancelButtonText());
        buttonPanel.add(cancelButton);
        panel.setPreferredSize(new Dimension(500, 400));
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.codeInsight.editorActions.RestoreReferencesDialog";
    }

    public Object[] getSelectedElements() {
        return this.mySelectedElements;
    }
}

