/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirOptionalExpectationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptionalExpectationTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "typeRef", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptionalExpectationTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptionalExpectationTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptionalExpectationTypeChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1807#2,3:38\n*S KotlinDebug\n*F\n+ 1 FirOptionalExpectationTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirOptionalExpectationTypeChecker\n*L\n32#1:38,3\n*E\n"})
public final class FirOptionalExpectationTypeChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirOptionalExpectationTypeChecker INSTANCE = new FirOptionalExpectationTypeChecker();

    private FirOptionalExpectationTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedTypeRef typeRef) {
        boolean bl;
        FirAnnotationContainer annotationContainer;
        Object object;
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        KtSourceElement ktSourceElement = source = typeRef.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, typeRef.getConeType());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        if (!FirOptionalExpectationHelpersKt.isOptionalAnnotationClass(classSymbol, context2.getSession())) {
            return;
        }
        if (!FirModuleDataKt.getModuleData(context2.getSession()).isCommon()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getOPTIONAL_DECLARATION_USAGE_IN_NON_COMMON_SOURCE(), null, (int)8, null);
        }
        if ((object = (annotationContainer = (FirAnnotationContainer)CollectionsKt.lastOrNull(context2.getAnnotationContainers()))) != null && (object = object.getAnnotations()) != null) {
            boolean bl2;
            block10: {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getAnnotationTypeRef(), (Object)typeRef)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getOPTIONAL_DECLARATION_OUTSIDE_OF_ANNOTATION_ENTRY(), null, (int)8, null);
    }
}

