/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\nH\u0002J\u0018\u0010\u0004\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u0005*\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0015J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u00112\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0018\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter;", "", "<init>", "()V", "appendRepresentation", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "it", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "appendRepresentationBeforeCallableId", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "appendValueParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "represent", "", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "representClassLike", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "owner", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirRedeclarationPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirRedeclarationPresenter.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1915#2,2:119\n1915#2,2:121\n*S KotlinDebug\n*F\n+ 1 FirRedeclarationPresenter.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirRedeclarationPresenter\n*L\n58#1:119,2\n111#1:121,2\n*E\n"})
public final class FirRedeclarationPresenter {
    @NotNull
    public static final FirRedeclarationPresenter INSTANCE = new FirRedeclarationPresenter();

    private FirRedeclarationPresenter() {
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, ClassId it) {
        $this$appendRepresentation.append(it.getPackageFqName().asString());
        $this$appendRepresentation.append('/');
        $this$appendRepresentation.append(it.getRelativeClassName().asString());
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, CallableId it) {
        $this$appendRepresentation.append(it.getPackageName().asString());
        $this$appendRepresentation.append('/');
        if (it.getClassName() != null) {
            $this$appendRepresentation.append(it.getClassName());
            $this$appendRepresentation.append('.');
        }
        $this$appendRepresentation.append(it.getCallableName());
    }

    private final void appendRepresentation(StringBuilder $this$appendRepresentation, FirValueParameterSymbol it) {
        if (it.isVararg()) {
            $this$appendRepresentation.append("vararg ");
        }
    }

    private final void appendRepresentationBeforeCallableId(StringBuilder $this$appendRepresentationBeforeCallableId, FirCallableSymbol<?> it) {
        if (!((Collection)it.getContextParameterSymbols()).isEmpty()) {
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append('<');
        int n = it.getTypeParameterSymbols().size();
        int n2 = 0;
        while (n2 < n) {
            int it2 = n2++;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append('>');
        $this$appendRepresentationBeforeCallableId.append('[');
        FirReceiverParameterSymbol firReceiverParameterSymbol = it.getReceiverParameterSymbol();
        if (firReceiverParameterSymbol != null) {
            FirReceiverParameterSymbol it3 = firReceiverParameterSymbol;
            boolean bl = false;
            $this$appendRepresentationBeforeCallableId.append(',');
        }
        $this$appendRepresentationBeforeCallableId.append(']');
    }

    private final void appendValueParameters(StringBuilder $this$appendValueParameters, FirNamedFunctionSymbol it) {
        $this$appendValueParameters.append('(');
        Iterable $this$forEach$iv = it.getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol it2 = (FirValueParameterSymbol)element$iv;
            boolean bl = false;
            INSTANCE.appendRepresentation($this$appendValueParameters, it2);
            $this$appendValueParameters.append(',');
        }
        $this$appendValueParameters.append(')');
    }

    @Nullable
    public final String represent(@NotNull FirBasedSymbol<?> declaration) {
        Intrinsics.checkNotNullParameter(declaration, (String)"declaration");
        FirBasedSymbol<?> firBasedSymbol = declaration;
        return firBasedSymbol instanceof FirNamedFunctionSymbol ? this.represent((FirNamedFunctionSymbol)declaration) : (firBasedSymbol instanceof FirRegularClassSymbol ? this.represent((FirRegularClassSymbol)declaration) : (firBasedSymbol instanceof FirTypeAliasSymbol ? this.represent((FirTypeAliasSymbol)declaration) : (firBasedSymbol instanceof FirPropertySymbol ? this.represent((FirVariableSymbol)declaration) : null)));
    }

    @NotNull
    public final String represent(@NotNull FirNamedFunctionSymbol it) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StringBuilder $this$represent_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendRepresentationBeforeCallableId($this$represent_u24lambda_u240, it);
        INSTANCE.appendRepresentation($this$represent_u24lambda_u240, it.getCallableId());
        INSTANCE.appendValueParameters($this$represent_u24lambda_u240, it);
        return stringBuilder.toString();
    }

    @NotNull
    public final String represent(@NotNull FirVariableSymbol<?> it) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(it, (String)"it");
        StringBuilder $this$represent_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.appendRepresentationBeforeCallableId($this$represent_u24lambda_u241, (FirCallableSymbol)it);
        CallableId callableId = it.getCallableId();
        Intrinsics.checkNotNull((Object)callableId);
        INSTANCE.appendRepresentation($this$represent_u24lambda_u241, callableId);
        if (it instanceof FirFieldSymbol) {
            $this$represent_u24lambda_u241.append("#f");
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final String represent(@NotNull FirTypeAliasSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this.representClassLike(it);
    }

    @NotNull
    public final String represent(@NotNull FirRegularClassSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this.representClassLike(it);
    }

    private final String representClassLike(FirClassLikeSymbol<?> it) {
        StringBuilder stringBuilder;
        StringBuilder $this$representClassLike_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$representClassLike_u24lambda_u240.append('<');
        $this$representClassLike_u24lambda_u240.append('>');
        $this$representClassLike_u24lambda_u240.append('[');
        $this$representClassLike_u24lambda_u240.append(']');
        INSTANCE.appendRepresentation($this$representClassLike_u24lambda_u240, it.getClassId());
        return stringBuilder.toString();
    }

    @NotNull
    public final String represent(@NotNull FirConstructorSymbol it, @NotNull FirClassLikeSymbol<?> owner) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        StringBuilder $this$represent_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!((Collection)it.getContextParameterSymbols()).isEmpty()) {
            $this$represent_u24lambda_u242.append(',');
        }
        $this$represent_u24lambda_u242.append('<');
        int n = it.getTypeParameterSymbols().size();
        int n2 = 0;
        while (n2 < n) {
            int it2 = n2++;
            boolean bl2 = false;
            $this$represent_u24lambda_u242.append(',');
        }
        $this$represent_u24lambda_u242.append('>');
        $this$represent_u24lambda_u242.append('[');
        $this$represent_u24lambda_u242.append(']');
        INSTANCE.appendRepresentation($this$represent_u24lambda_u242, owner.getClassId());
        $this$represent_u24lambda_u242.append('(');
        Iterable $this$forEach$iv = it.getValueParameterSymbols();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameterSymbol it3 = (FirValueParameterSymbol)element$iv;
            boolean bl3 = false;
            INSTANCE.appendRepresentation($this$represent_u24lambda_u242, it3);
            $this$represent_u24lambda_u242.append(',');
        }
        $this$represent_u24lambda_u242.append(')');
        return stringBuilder.toString();
    }
}

