/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.structuralsearch.Scopes;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="ui-state", storages={@Storage(value="structuralSearch.xml")}, category=SettingsCategory.UI)
final class UIState
implements PersistentStateComponent<UIState> {
    public boolean migrated = false;
    public TreeState templatesTreeState;
    public Scopes.Type scopeType;
    public String scopeDescriptor;
    public boolean searchInjectedCode = true;
    public boolean matchCase = false;
    public boolean shortenFQNames = true;
    public boolean useStaticImport = false;
    public boolean reformat = true;
    public boolean filtersVisible = true;
    public boolean existingTemplatesVisible = true;
    public boolean pinned = false;

    UIState() {
    }

    public static UIState getInstance() {
        return (UIState)ApplicationManager.getApplication().getService(UIState.class);
    }

    public UIState getState() {
        return this;
    }

    public void loadState(@NotNull UIState state) {
        if (state == null) {
            UIState.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (!this.migrated) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            this.filtersVisible = properties.getBoolean("structural.search.filters.visible", true);
            this.existingTemplatesVisible = properties.getBoolean("structural.search.templates.visible", true);
            this.pinned = properties.getBoolean("structural.seach.pinned", false);
            properties.unsetValue("structural.search.filters.visible");
            properties.unsetValue("structural.search.templates.visible");
            properties.unsetValue("structural.seach.pinned");
            properties.unsetValue("structural.search.shorten.fqn");
            properties.unsetValue("structural.search.reformat");
            properties.unsetValue("structural.search.use.static.import");
            this.migrated = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/structuralsearch/plugin/ui/UIState", "loadState"));
    }
}

