/*******************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!    This example demonstrates non-deterministic random number generation using
!    VSL_BRNG_NONDETERM
!******************************************************************************/

#include <stdio.h>

#include "mkl_vsl.h"
#include "errcheck.inc"

#define BRNG    VSL_BRNG_NONDETERM
#define METHOD  VSL_RNG_METHOD_UNIFORM_STD
#define SOURCE  VSL_BRNG_RDRAND
#define N       1000
#define NN      10

int main(void)
{
    float r[N];
    VSLStreamStatePtr stream;
    int i, errcode = VSL_ERROR_OK, status = 0;
    float a = 0.0f, b = 1.0f;

    /***** Initialize *****/
    errcode = vslNewStream( &stream, BRNG, SOURCE );
    CheckVslError( errcode );

    /***** Call RNG *****/
    errcode = vsRngUniform( METHOD, stream, N, r, a, b );
    CheckVslError( errcode );

    /***** Printing results *****/
    printf("Sample of vsRngUniform.\n");
    printf("-----------------------\n\n");
    printf("Parameters:\n");
    printf("    a=%.4f\n",a);
    printf("    b=%.4f\n\n",b);

    printf("Results (first 10 of 1000):\n");
    printf("---------------------------\n");
    for( i = 0; i < NN; i++ )
    {
        printf("r[%d]=%.4f\n",i,r[i]);
    }

    /***** Deinitialize *****/
    errcode = vslDeleteStream( &stream );
    CheckVslError( errcode );

    return status;
}
