!
! Copyright Intel Corporation.
! 
! This software and the related documents are Intel copyrighted materials, and
! your use of them is governed by the express license under which they were
! provided to you (License). Unless the License provides otherwise, you may
! not use, modify, copy, publish, distribute, disclose or transmit this
! software or the related documents without Intel's prior written permission.
! 
! This software and the related documents are provided as is, with no express
! or implied warranties, other than those that are expressly stated in the
! License.
!
! Copyright (C) by Argonne National Laboratory
! 
! 				  COPYRIGHT
! 
! The following is a notice of limited availability of the code, and disclaimer
! which must be included in the prologue of the code and in all source listings
! of the code.
! 
! Copyright Notice
! 1998--2020, Argonne National Laboratory
! 
! Permission is hereby granted to use, reproduce, prepare derivative works, and
! to redistribute to others.  This software was authored by:
! 
! Mathematics and Computer Science Division
! Argonne National Laboratory, Argonne IL 60439
! 
! (and)
! 
! Department of Computer Science
! University of Illinois at Urbana-Champaign
! 
! 
! 			      GOVERNMENT LICENSE
! 
! Portions of this material resulted from work developed under a U.S.
! Government Contract and are subject to the following license: the Government
! is granted for itself and others acting on its behalf a paid-up, nonexclusive,
! irrevocable worldwide license in this computer software to reproduce, prepare
! derivative works, and perform publicly and display publicly.
! 
! 				  DISCLAIMER
! 
! This computer code material was prepared, in part, as an account of work
! sponsored by an agency of the United States Government.  Neither the United
! States, nor the University of Chicago, nor any of their employees, makes any
! warranty express or implied, or assumes any legal liability or responsibility
! for the accuracy, completeness, or usefulness of any information, apparatus,
! product, or process disclosed, or represents that its use would not infringe
! privately owned rights.
! 
! 			   EXTERNAL CONTRIBUTIONS
! 
! Portions of this code have been contributed under the above license by:
! 
!  * Intel Corporation
!  * Cray
!  * IBM Corporation
!  * Microsoft Corporation
!  * Mellanox Technologies Ltd.
!  * DataDirect Networks.
!  * Oak Ridge National Laboratory
!  * Sun Microsystems, Lustre group
!  * Dolphin Interconnect Solutions Inc.
!  * Institut Polytechnique de Bordeaux
!
!     
!

! -- THIS FILE IS AUTO-GENERATED -- 

module pmpi_f08
    USE,intrinsic :: iso_c_binding, ONLY: c_ptr
    USE :: mpi_f08_types
    USE :: mpi_f08_compile_constants
    USE :: mpi_f08_link_constants
    USE :: mpi_f08_callbacks
    
    IMPLICIT NONE
    
    interface PMPI_Comm_attach_buffer
        subroutine PMPIR_Comm_attach_buffer_f08ts(comm, buffer, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER, INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_attach_buffer_f08ts
        
        subroutine PMPIR_Comm_attach_buffer_c_f08ts(comm, buffer, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_attach_buffer_c_f08ts
    END interface PMPI_Comm_attach_buffer

    interface PMPI_Comm_detach_buffer
        subroutine PMPIR_Comm_detach_buffer_f08(comm, buffer_addr, size, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(C_PTR), INTENT(out) :: buffer_addr
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_detach_buffer_f08
        
        subroutine PMPIR_Comm_detach_buffer_c_f08(comm, buffer_addr, size, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(C_PTR), INTENT(out) :: buffer_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_detach_buffer_c_f08
    END interface PMPI_Comm_detach_buffer

    interface PMPI_Comm_flush_buffer
        subroutine PMPIR_Comm_flush_buffer_f08(comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_flush_buffer_f08
    END interface PMPI_Comm_flush_buffer
    
    interface PMPI_Comm_iflush_buffer
        subroutine PMPIR_Comm_iflush_buffer_f08(comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_iflush_buffer_f08
    END interface PMPI_Comm_iflush_buffer

    interface PMPI_Comm_create_keyval
        subroutine PMPIR_Comm_create_keyval_f08(comm_copy_attr_fn, comm_delete_attr_fn, comm_keyval, &
                                              extra_state, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            USE :: mpi_f08_callbacks, ONLY : MPI_Comm_copy_attr_function, MPI_Comm_delete_attr_function
            IMPLICIT NONE
            PROCEDURE(MPI_Comm_copy_attr_function) :: comm_copy_attr_fn
            PROCEDURE(MPI_Comm_delete_attr_function) :: comm_delete_attr_fn
            INTEGER, INTENT(out) :: comm_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extra_state
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_create_keyval_f08
    END interface PMPI_Comm_create_keyval
    
    interface PMPI_Comm_delete_attr
        subroutine PMPIR_Comm_delete_attr_f08(comm, comm_keyval, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: comm_keyval
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_delete_attr_f08
    END interface PMPI_Comm_delete_attr
    
    interface PMPI_Comm_free_keyval
        subroutine PMPIR_Comm_free_keyval_f08(comm_keyval, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(inout) :: comm_keyval
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_free_keyval_f08
    END interface PMPI_Comm_free_keyval
    
    interface PMPI_Comm_get_attr
        subroutine PMPIR_Comm_get_attr_f08(comm, comm_keyval, attribute_val, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: comm_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: attribute_val
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_get_attr_f08
    END interface PMPI_Comm_get_attr
    
    interface PMPI_Comm_set_attr
        subroutine PMPIR_Comm_set_attr_f08(comm, comm_keyval, attribute_val, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: comm_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: attribute_val
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_set_attr_f08
    END interface PMPI_Comm_set_attr
    
    interface PMPI_Type_create_keyval
        subroutine PMPIR_Type_create_keyval_f08(type_copy_attr_fn, type_delete_attr_fn, type_keyval, &
                                              extra_state, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            USE :: mpi_f08_callbacks, ONLY : MPI_Type_copy_attr_function, MPI_Type_delete_attr_function
            IMPLICIT NONE
            PROCEDURE(MPI_Type_copy_attr_function) :: type_copy_attr_fn
            PROCEDURE(MPI_Type_delete_attr_function) :: type_delete_attr_fn
            INTEGER, INTENT(out) :: type_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extra_state
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_keyval_f08
    END interface PMPI_Type_create_keyval
    
    interface PMPI_Type_delete_attr
        subroutine PMPIR_Type_delete_attr_f08(datatype, type_keyval, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: type_keyval
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_delete_attr_f08
    END interface PMPI_Type_delete_attr
    
    interface PMPI_Type_free_keyval
        subroutine PMPIR_Type_free_keyval_f08(type_keyval, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(inout) :: type_keyval
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_free_keyval_f08
    END interface PMPI_Type_free_keyval
    
    interface PMPI_Type_get_attr
        subroutine PMPIR_Type_get_attr_f08(datatype, type_keyval, attribute_val, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: type_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: attribute_val
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_attr_f08
    END interface PMPI_Type_get_attr
    
    interface PMPI_Type_set_attr
        subroutine PMPIR_Type_set_attr_f08(datatype, type_keyval, attribute_val, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: type_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: attribute_val
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_set_attr_f08
    END interface PMPI_Type_set_attr
    
    interface PMPI_Win_create_keyval
        subroutine PMPIR_Win_create_keyval_f08(win_copy_attr_fn, win_delete_attr_fn, win_keyval, extra_state, &
                                             ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            USE :: mpi_f08_callbacks, ONLY : MPI_Win_copy_attr_function, MPI_Win_delete_attr_function
            IMPLICIT NONE
            PROCEDURE(MPI_Win_copy_attr_function) :: win_copy_attr_fn
            PROCEDURE(MPI_Win_delete_attr_function) :: win_delete_attr_fn
            INTEGER, INTENT(out) :: win_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extra_state
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_create_keyval_f08
    END interface PMPI_Win_create_keyval
    
    interface PMPI_Win_delete_attr
        subroutine PMPIR_Win_delete_attr_f08(win, win_keyval, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, INTENT(in) :: win_keyval
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_delete_attr_f08
    END interface PMPI_Win_delete_attr
    
    interface PMPI_Win_free_keyval
        subroutine PMPIR_Win_free_keyval_f08(win_keyval, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(inout) :: win_keyval
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_free_keyval_f08
    END interface PMPI_Win_free_keyval
    
    interface PMPI_Win_get_attr
        subroutine PMPIR_Win_get_attr_f08(win, win_keyval, attribute_val, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, INTENT(in) :: win_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: attribute_val
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_get_attr_f08
    END interface PMPI_Win_get_attr
    
    interface PMPI_Win_set_attr
        subroutine PMPIR_Win_set_attr_f08(win, win_keyval, attribute_val, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, INTENT(in) :: win_keyval
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: attribute_val
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_set_attr_f08
    END interface PMPI_Win_set_attr
    
    interface PMPI_Allgather
        subroutine PMPIR_Allgather_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                       ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgather_f08ts
        
        subroutine PMPIR_Allgather_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                         ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgather_c_f08ts
    END interface PMPI_Allgather
    
    interface PMPI_Allgather_init
        subroutine PMPIR_Allgather_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                            comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgather_init_f08ts
        
        subroutine PMPIR_Allgather_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                              comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgather_init_c_f08ts
    END interface PMPI_Allgather_init
    
    interface PMPI_Allgatherv
        subroutine PMPIR_Allgatherv_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, &
                                        comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER, INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgatherv_f08ts
        
        subroutine PMPIR_Allgatherv_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                          recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgatherv_c_f08ts
    END interface PMPI_Allgatherv
    
    interface PMPI_Allgatherv_init
        subroutine PMPIR_Allgatherv_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                             recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgatherv_init_f08ts
        
        subroutine PMPIR_Allgatherv_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                               recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allgatherv_init_c_f08ts
    END interface PMPI_Allgatherv_init
    
    interface PMPI_Allreduce
        subroutine PMPIR_Allreduce_f08ts(sendbuf, recvbuf, count, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allreduce_f08ts
        
        subroutine PMPIR_Allreduce_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allreduce_c_f08ts
    END interface PMPI_Allreduce
    
    interface PMPI_Allreduce_init
        subroutine PMPIR_Allreduce_init_f08ts(sendbuf, recvbuf, count, datatype, op, comm, info, request, &
                                            ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allreduce_init_f08ts
        
        subroutine PMPIR_Allreduce_init_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, info, request, &
                                              ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Allreduce_init_c_f08ts
    END interface PMPI_Allreduce_init
    
    interface PMPI_Alltoall
        subroutine PMPIR_Alltoall_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                      ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoall_f08ts
        
        subroutine PMPIR_Alltoall_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                        ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoall_c_f08ts
    END interface PMPI_Alltoall
    
    interface PMPI_Alltoall_init
        subroutine PMPIR_Alltoall_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                           info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoall_init_f08ts
        
        subroutine PMPIR_Alltoall_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                             comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoall_init_c_f08ts
    END interface PMPI_Alltoall_init
    
    interface PMPI_Alltoallv
        subroutine PMPIR_Alltoallv_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, rdispls, &
                                       recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcounts(*)
            INTEGER, INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER, INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallv_f08ts
        
        subroutine PMPIR_Alltoallv_c_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, &
                                         rdispls, recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallv_c_f08ts
    END interface PMPI_Alltoallv
    
    interface PMPI_Alltoallv_init
        subroutine PMPIR_Alltoallv_init_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, &
                                            rdispls, recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallv_init_f08ts
        
        subroutine PMPIR_Alltoallv_init_c_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, &
                                              rdispls, recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallv_init_c_f08ts
    END interface PMPI_Alltoallv_init
    
    interface PMPI_Alltoallw
        subroutine PMPIR_Alltoallw_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, &
                                       rdispls, recvtypes, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcounts(*)
            INTEGER, INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtypes(*)
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER, INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallw_f08ts
        
        subroutine PMPIR_Alltoallw_c_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, &
                                         rdispls, recvtypes, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtypes(*)
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallw_c_f08ts
    END interface PMPI_Alltoallw
    
    interface PMPI_Alltoallw_init
        subroutine PMPIR_Alltoallw_init_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, &
                                            rdispls, recvtypes, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallw_init_f08ts
        
        subroutine PMPIR_Alltoallw_init_c_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, &
                                              rdispls, recvtypes, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alltoallw_init_c_f08ts
    END interface PMPI_Alltoallw_init
    
    interface PMPI_Barrier
        subroutine PMPIR_Barrier_f08(comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Barrier_f08
    END interface PMPI_Barrier
    
    interface PMPI_Barrier_init
        subroutine PMPIR_Barrier_init_f08(comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Barrier_init_f08
    END interface PMPI_Barrier_init
    
    interface PMPI_Bcast
        subroutine PMPIR_Bcast_f08ts(buffer, count, datatype, root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout) :: buffer
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bcast_f08ts
        
        subroutine PMPIR_Bcast_c_f08ts(buffer, count, datatype, root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout) :: buffer
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bcast_c_f08ts
    END interface PMPI_Bcast
    
    interface PMPI_Bcast_init
        subroutine PMPIR_Bcast_init_f08ts(buffer, count, datatype, root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bcast_init_f08ts
        
        subroutine PMPIR_Bcast_init_c_f08ts(buffer, count, datatype, root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bcast_init_c_f08ts
    END interface PMPI_Bcast_init
    
    interface PMPI_Exscan
        subroutine PMPIR_Exscan_f08ts(sendbuf, recvbuf, count, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Exscan_f08ts
        
        subroutine PMPIR_Exscan_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Exscan_c_f08ts
    END interface PMPI_Exscan
    
    interface PMPI_Exscan_init
        subroutine PMPIR_Exscan_init_f08ts(sendbuf, recvbuf, count, datatype, op, comm, info, request, &
                                         ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Exscan_init_f08ts
        
        subroutine PMPIR_Exscan_init_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, info, request, &
                                           ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Exscan_init_c_f08ts
    END interface PMPI_Exscan_init
    
    interface PMPI_Gather
        subroutine PMPIR_Gather_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm, &
                                    ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gather_f08ts
        
        subroutine PMPIR_Gather_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                      comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gather_c_f08ts
    END interface PMPI_Gather
    
    interface PMPI_Gather_init
        subroutine PMPIR_Gather_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                         comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gather_init_f08ts
        
        subroutine PMPIR_Gather_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                           comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gather_init_c_f08ts
    END interface PMPI_Gather_init
    
    interface PMPI_Gatherv
        subroutine PMPIR_Gatherv_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, &
                                     root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER, INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gatherv_f08ts
        
        subroutine PMPIR_Gatherv_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, &
                                       root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gatherv_c_f08ts
    END interface PMPI_Gatherv
    
    interface PMPI_Gatherv_init
        subroutine PMPIR_Gatherv_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                          recvtype, root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gatherv_init_f08ts
        
        subroutine PMPIR_Gatherv_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                            recvtype, root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Gatherv_init_c_f08ts
    END interface PMPI_Gatherv_init
    
    interface PMPI_Iallgather
        subroutine PMPIR_Iallgather_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                        request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iallgather_f08ts
        
        subroutine PMPIR_Iallgather_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                          request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iallgather_c_f08ts
    END interface PMPI_Iallgather
    
    interface PMPI_Iallgatherv
        subroutine PMPIR_Iallgatherv_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                         recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iallgatherv_f08ts
        
        subroutine PMPIR_Iallgatherv_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                           recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iallgatherv_c_f08ts
    END interface PMPI_Iallgatherv
    
    interface PMPI_Iallreduce
        subroutine PMPIR_Iallreduce_f08ts(sendbuf, recvbuf, count, datatype, op, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iallreduce_f08ts
        
        subroutine PMPIR_Iallreduce_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iallreduce_c_f08ts
    END interface PMPI_Iallreduce
    
    interface PMPI_Ialltoall
        subroutine PMPIR_Ialltoall_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                       request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ialltoall_f08ts
        
        subroutine PMPIR_Ialltoall_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, comm, &
                                         request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ialltoall_c_f08ts
    END interface PMPI_Ialltoall
    
    interface PMPI_Ialltoallv
        subroutine PMPIR_Ialltoallv_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, &
                                        rdispls, recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ialltoallv_f08ts
        
        subroutine PMPIR_Ialltoallv_c_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, &
                                          rdispls, recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ialltoallv_c_f08ts
    END interface PMPI_Ialltoallv
    
    interface PMPI_Ialltoallw
        subroutine PMPIR_Ialltoallw_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, &
                                        rdispls, recvtypes, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ialltoallw_f08ts
        
        subroutine PMPIR_Ialltoallw_c_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, recvcounts, &
                                          rdispls, recvtypes, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ialltoallw_c_f08ts
    END interface PMPI_Ialltoallw
    
    interface PMPI_Ibarrier
        subroutine PMPIR_Ibarrier_f08(comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ibarrier_f08
    END interface PMPI_Ibarrier
    
    interface PMPI_Ibcast
        subroutine PMPIR_Ibcast_f08ts(buffer, count, datatype, root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout), ASYNCHRONOUS :: buffer
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ibcast_f08ts
        
        subroutine PMPIR_Ibcast_c_f08ts(buffer, count, datatype, root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout), ASYNCHRONOUS :: buffer
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ibcast_c_f08ts
    END interface PMPI_Ibcast
    
    interface PMPI_Iexscan
        subroutine PMPIR_Iexscan_f08ts(sendbuf, recvbuf, count, datatype, op, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iexscan_f08ts
        
        subroutine PMPIR_Iexscan_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iexscan_c_f08ts
    END interface PMPI_Iexscan
    
    interface PMPI_Igather
        subroutine PMPIR_Igather_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm, &
                                     request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Igather_f08ts
        
        subroutine PMPIR_Igather_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                       comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Igather_c_f08ts
    END interface PMPI_Igather
    
    interface PMPI_Igatherv
        subroutine PMPIR_Igatherv_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, &
                                      root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Igatherv_f08ts
        
        subroutine PMPIR_Igatherv_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, recvtype, &
                                        root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Igatherv_c_f08ts
    END interface PMPI_Igatherv
    
    interface PMPI_Ineighbor_allgather
        subroutine PMPIR_Ineighbor_allgather_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                                 comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_allgather_f08ts
        
        subroutine PMPIR_Ineighbor_allgather_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                   recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_allgather_c_f08ts
    END interface PMPI_Ineighbor_allgather
    
    interface PMPI_Ineighbor_allgatherv
        subroutine PMPIR_Ineighbor_allgatherv_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                                  recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_allgatherv_f08ts
        
        subroutine PMPIR_Ineighbor_allgatherv_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, &
                                                    displs, recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_allgatherv_c_f08ts
    END interface PMPI_Ineighbor_allgatherv
    
    interface PMPI_Ineighbor_alltoall
        subroutine PMPIR_Ineighbor_alltoall_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                                comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_alltoall_f08ts
        
        subroutine PMPIR_Ineighbor_alltoall_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                  recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_alltoall_c_f08ts
    END interface PMPI_Ineighbor_alltoall
    
    interface PMPI_Ineighbor_alltoallv
        subroutine PMPIR_Ineighbor_alltoallv_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, &
                                                 recvcounts, rdispls, recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_alltoallv_f08ts
        
        subroutine PMPIR_Ineighbor_alltoallv_c_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, &
                                                   recvcounts, rdispls, recvtype, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_alltoallv_c_f08ts
    END interface PMPI_Ineighbor_alltoallv
    
    interface PMPI_Ineighbor_alltoallw
        subroutine PMPIR_Ineighbor_alltoallw_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, &
                                                 recvcounts, rdispls, recvtypes, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_alltoallw_f08ts
        
        subroutine PMPIR_Ineighbor_alltoallw_c_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, &
                                                   recvcounts, rdispls, recvtypes, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ineighbor_alltoallw_c_f08ts
    END interface PMPI_Ineighbor_alltoallw
    
    interface PMPI_Ireduce
        subroutine PMPIR_Ireduce_f08ts(sendbuf, recvbuf, count, datatype, op, root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ireduce_f08ts
        
        subroutine PMPIR_Ireduce_c_f08ts(sendbuf, recvbuf, count, datatype, op, root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ireduce_c_f08ts
    END interface PMPI_Ireduce
    
    interface PMPI_Ireduce_scatter
        subroutine PMPIR_Ireduce_scatter_f08ts(sendbuf, recvbuf, recvcounts, datatype, op, comm, request, &
                                             ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ireduce_scatter_f08ts
        
        subroutine PMPIR_Ireduce_scatter_c_f08ts(sendbuf, recvbuf, recvcounts, datatype, op, comm, request, &
                                               ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ireduce_scatter_c_f08ts
    END interface PMPI_Ireduce_scatter
    
    interface PMPI_Ireduce_scatter_block
        subroutine PMPIR_Ireduce_scatter_block_f08ts(sendbuf, recvbuf, recvcount, datatype, op, comm, request, &
                                                   ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ireduce_scatter_block_f08ts
        
        subroutine PMPIR_Ireduce_scatter_block_c_f08ts(sendbuf, recvbuf, recvcount, datatype, op, comm, &
                                                     request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ireduce_scatter_block_c_f08ts
    END interface PMPI_Ireduce_scatter_block
    
    interface PMPI_Iscan
        subroutine PMPIR_Iscan_f08ts(sendbuf, recvbuf, count, datatype, op, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iscan_f08ts
        
        subroutine PMPIR_Iscan_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iscan_c_f08ts
    END interface PMPI_Iscan
    
    interface PMPI_Iscatter
        subroutine PMPIR_Iscatter_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                      comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iscatter_f08ts
        
        subroutine PMPIR_Iscatter_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                        comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iscatter_c_f08ts
    END interface PMPI_Iscatter
    
    interface PMPI_Iscatterv
        subroutine PMPIR_Iscatterv_f08ts(sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, recvtype, &
                                       root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iscatterv_f08ts
        
        subroutine PMPIR_Iscatterv_c_f08ts(sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, &
                                         recvtype, root, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iscatterv_c_f08ts
    END interface PMPI_Iscatterv
    
    interface PMPI_Neighbor_allgather
        subroutine PMPIR_Neighbor_allgather_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                                comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgather_f08ts
        
        subroutine PMPIR_Neighbor_allgather_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                  recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgather_c_f08ts
    END interface PMPI_Neighbor_allgather
    
    interface PMPI_Neighbor_allgather_init
        subroutine PMPIR_Neighbor_allgather_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                     recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgather_init_f08ts
        
        subroutine PMPIR_Neighbor_allgather_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                       recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgather_init_c_f08ts
    END interface PMPI_Neighbor_allgather_init
    
    interface PMPI_Neighbor_allgatherv
        subroutine PMPIR_Neighbor_allgatherv_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, displs, &
                                                 recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER, INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgatherv_f08ts
        
        subroutine PMPIR_Neighbor_allgatherv_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, &
                                                   displs, recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgatherv_c_f08ts
    END interface PMPI_Neighbor_allgatherv
    
    interface PMPI_Neighbor_allgatherv_init
        subroutine PMPIR_Neighbor_allgatherv_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, &
                                                      displs, recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgatherv_init_f08ts
        
        subroutine PMPIR_Neighbor_allgatherv_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcounts, &
                                                        displs, recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_allgatherv_init_c_f08ts
    END interface PMPI_Neighbor_allgatherv_init
    
    interface PMPI_Neighbor_alltoall
        subroutine PMPIR_Neighbor_alltoall_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                               comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoall_f08ts
        
        subroutine PMPIR_Neighbor_alltoall_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                                 comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoall_c_f08ts
    END interface PMPI_Neighbor_alltoall
    
    interface PMPI_Neighbor_alltoall_init
        subroutine PMPIR_Neighbor_alltoall_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                    recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoall_init_f08ts
        
        subroutine PMPIR_Neighbor_alltoall_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, &
                                                      recvtype, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoall_init_c_f08ts
    END interface PMPI_Neighbor_alltoall_init
    
    interface PMPI_Neighbor_alltoallv
        subroutine PMPIR_Neighbor_alltoallv_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, recvcounts, &
                                                rdispls, recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcounts(*)
            INTEGER, INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER, INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallv_f08ts
        
        subroutine PMPIR_Neighbor_alltoallv_c_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, &
                                                  recvcounts, rdispls, recvtype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallv_c_f08ts
    END interface PMPI_Neighbor_alltoallv
    
    interface PMPI_Neighbor_alltoallv_init
        subroutine PMPIR_Neighbor_alltoallv_init_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, &
                                                     recvcounts, rdispls, recvtype, comm, info, request, &
                                                     ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallv_init_f08ts
        
        subroutine PMPIR_Neighbor_alltoallv_init_c_f08ts(sendbuf, sendcounts, sdispls, sendtype, recvbuf, &
                                                       recvcounts, rdispls, recvtype, comm, info, request, &
                                                       ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallv_init_c_f08ts
    END interface PMPI_Neighbor_alltoallv_init
    
    interface PMPI_Neighbor_alltoallw
        subroutine PMPIR_Neighbor_alltoallw_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, &
                                                recvcounts, rdispls, recvtypes, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtypes(*)
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallw_f08ts
        
        subroutine PMPIR_Neighbor_alltoallw_c_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, &
                                                  recvcounts, rdispls, recvtypes, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtypes(*)
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in) :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallw_c_f08ts
    END interface PMPI_Neighbor_alltoallw
    
    interface PMPI_Neighbor_alltoallw_init
        subroutine PMPIR_Neighbor_alltoallw_init_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, &
                                                     recvcounts, rdispls, recvtypes, comm, info, request, &
                                                     ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallw_init_f08ts
        
        subroutine PMPIR_Neighbor_alltoallw_init_c_f08ts(sendbuf, sendcounts, sdispls, sendtypes, recvbuf, &
                                                       recvcounts, rdispls, recvtypes, comm, info, request, &
                                                       ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: sdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: sendtypes(*)
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: rdispls(*)
            TYPE(MPI_Datatype), INTENT(in), ASYNCHRONOUS :: recvtypes(*)
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Neighbor_alltoallw_init_c_f08ts
    END interface PMPI_Neighbor_alltoallw_init
    
    interface PMPI_Reduce
        subroutine PMPIR_Reduce_f08ts(sendbuf, recvbuf, count, datatype, op, root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_f08ts
        
        subroutine PMPIR_Reduce_c_f08ts(sendbuf, recvbuf, count, datatype, op, root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_c_f08ts
    END interface PMPI_Reduce
    
    interface PMPI_Reduce_init
        subroutine PMPIR_Reduce_init_f08ts(sendbuf, recvbuf, count, datatype, op, root, comm, info, request, &
                                         ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_init_f08ts
        
        subroutine PMPIR_Reduce_init_c_f08ts(sendbuf, recvbuf, count, datatype, op, root, comm, info, request, &
                                           ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_init_c_f08ts
    END interface PMPI_Reduce_init
    
    interface PMPI_Reduce_local
        subroutine PMPIR_Reduce_local_f08ts(inbuf, inoutbuf, count, datatype, op, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            TYPE(*), DIMENSION(..), INTENT(inout) :: inoutbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_local_f08ts
        
        subroutine PMPIR_Reduce_local_c_f08ts(inbuf, inoutbuf, count, datatype, op, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            TYPE(*), DIMENSION(..), INTENT(inout) :: inoutbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_local_c_f08ts
    END interface PMPI_Reduce_local
    
    interface PMPI_Reduce_scatter
        subroutine PMPIR_Reduce_scatter_f08ts(sendbuf, recvbuf, recvcounts, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcounts(*)
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_f08ts
        
        subroutine PMPIR_Reduce_scatter_c_f08ts(sendbuf, recvbuf, recvcounts, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcounts(*)
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_c_f08ts
    END interface PMPI_Reduce_scatter
    
    interface PMPI_Reduce_scatter_block
        subroutine PMPIR_Reduce_scatter_block_f08ts(sendbuf, recvbuf, recvcount, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_block_f08ts
        
        subroutine PMPIR_Reduce_scatter_block_c_f08ts(sendbuf, recvbuf, recvcount, datatype, op, comm, &
                                                    ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_block_c_f08ts
    END interface PMPI_Reduce_scatter_block
    
    interface PMPI_Reduce_scatter_block_init
        subroutine PMPIR_Reduce_scatter_block_init_f08ts(sendbuf, recvbuf, recvcount, datatype, op, comm, &
                                                       info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_block_init_f08ts
        
        subroutine PMPIR_Reduce_scatter_block_init_c_f08ts(sendbuf, recvbuf, recvcount, datatype, op, comm, &
                                                         info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_block_init_c_f08ts
    END interface PMPI_Reduce_scatter_block_init
    
    interface PMPI_Reduce_scatter_init
        subroutine PMPIR_Reduce_scatter_init_f08ts(sendbuf, recvbuf, recvcounts, datatype, op, comm, info, &
                                                 request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_init_f08ts
        
        subroutine PMPIR_Reduce_scatter_init_c_f08ts(sendbuf, recvbuf, recvcounts, datatype, op, comm, info, &
                                                   request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: recvcounts(*)
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Reduce_scatter_init_c_f08ts
    END interface PMPI_Reduce_scatter_init
    
    interface PMPI_Scan
        subroutine PMPIR_Scan_f08ts(sendbuf, recvbuf, count, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scan_f08ts
        
        subroutine PMPIR_Scan_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scan_c_f08ts
    END interface PMPI_Scan
    
    interface PMPI_Scan_init
        subroutine PMPIR_Scan_init_f08ts(sendbuf, recvbuf, count, datatype, op, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scan_init_f08ts
        
        subroutine PMPIR_Scan_init_c_f08ts(sendbuf, recvbuf, count, datatype, op, comm, info, request, &
                                         ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scan_init_c_f08ts
    END interface PMPI_Scan_init
    
    interface PMPI_Scatter
        subroutine PMPIR_Scatter_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, comm, &
                                     ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatter_f08ts
        
        subroutine PMPIR_Scatter_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                       comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatter_c_f08ts
    END interface PMPI_Scatter
    
    interface PMPI_Scatter_init
        subroutine PMPIR_Scatter_init_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, root, &
                                          comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatter_init_f08ts
        
        subroutine PMPIR_Scatter_init_c_f08ts(sendbuf, sendcount, sendtype, recvbuf, recvcount, recvtype, &
                                            root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatter_init_c_f08ts
    END interface PMPI_Scatter_init
    
    interface PMPI_Scatterv
        subroutine PMPIR_Scatterv_f08ts(sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, recvtype, &
                                      root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcounts(*)
            INTEGER, INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatterv_f08ts
        
        subroutine PMPIR_Scatterv_c_f08ts(sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, recvtype, &
                                        root, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatterv_c_f08ts
    END interface PMPI_Scatterv
    
    interface PMPI_Scatterv_init
        subroutine PMPIR_Scatterv_init_f08ts(sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, &
                                           recvtype, root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER, INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER, INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatterv_init_f08ts
        
        subroutine PMPIR_Scatterv_init_c_f08ts(sendbuf, sendcounts, displs, sendtype, recvbuf, recvcount, &
                                             recvtype, root, comm, info, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in), ASYNCHRONOUS :: sendcounts(*)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in), ASYNCHRONOUS :: displs(*)
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Scatterv_init_c_f08ts
    END interface PMPI_Scatterv_init
    
    interface PMPI_Comm_compare
        subroutine PMPIR_Comm_compare_f08(comm1, comm2, result, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm1
            TYPE(MPI_Comm), INTENT(in) :: comm2
            INTEGER, INTENT(out) :: result
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_compare_f08
    END interface PMPI_Comm_compare
    
    interface PMPI_Comm_create
        subroutine PMPIR_Comm_create_f08(comm, group, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Group), INTENT(in) :: group
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_create_f08
    END interface PMPI_Comm_create
    
    interface PMPI_Comm_create_group
        subroutine PMPIR_Comm_create_group_f08(comm, group, tag, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_create_group_f08
    END interface PMPI_Comm_create_group
    
    interface PMPI_Comm_dup
        subroutine PMPIR_Comm_dup_f08(comm, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_dup_f08
    END interface PMPI_Comm_dup
    
    interface PMPI_Comm_dup_with_info
        subroutine PMPIR_Comm_dup_with_info_f08(comm, info, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_dup_with_info_f08
    END interface PMPI_Comm_dup_with_info
    
    interface PMPI_Comm_free
        subroutine PMPIR_Comm_free_f08(comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(inout) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_free_f08
    END interface PMPI_Comm_free
    
    interface PMPI_Comm_get_info
        subroutine PMPIR_Comm_get_info_f08(comm, info_used, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(out) :: info_used
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_get_info_f08
    END interface PMPI_Comm_get_info
    
    interface PMPI_Comm_get_name
        subroutine PMPIR_Comm_get_name_f08(comm, comm_name, resultlen, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_OBJECT_NAME
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            CHARACTER(len=MPI_MAX_OBJECT_NAME), INTENT(out) :: comm_name
            INTEGER, INTENT(out) :: resultlen
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_get_name_f08
    END interface PMPI_Comm_get_name
    
    interface PMPI_Comm_group
        subroutine PMPIR_Comm_group_f08(comm, group, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Group), INTENT(out) :: group
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_group_f08
    END interface PMPI_Comm_group
    
    interface PMPI_Comm_idup
        subroutine PMPIR_Comm_idup_f08(comm, newcomm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Comm), INTENT(out), ASYNCHRONOUS :: newcomm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_idup_f08
    END interface PMPI_Comm_idup
    
    interface PMPI_Comm_idup_with_info
        subroutine PMPIR_Comm_idup_with_info_f08(comm, info, newcomm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(out), ASYNCHRONOUS :: newcomm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_idup_with_info_f08
    END interface PMPI_Comm_idup_with_info
    
    interface PMPI_Comm_rank
        subroutine PMPIR_Comm_rank_f08(comm, rank, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: rank
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_rank_f08
    END interface PMPI_Comm_rank
    
    interface PMPI_Comm_remote_group
        subroutine PMPIR_Comm_remote_group_f08(comm, group, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Group), INTENT(out) :: group
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_remote_group_f08
    END interface PMPI_Comm_remote_group
    
    interface PMPI_Comm_remote_size
        subroutine PMPIR_Comm_remote_size_f08(comm, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_remote_size_f08
    END interface PMPI_Comm_remote_size
    
    interface PMPI_Comm_set_info
        subroutine PMPIR_Comm_set_info_f08(comm, info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_set_info_f08
    END interface PMPI_Comm_set_info
    
    interface PMPI_Comm_set_name
        subroutine PMPIR_Comm_set_name_f08(comm, comm_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            CHARACTER(len=*), INTENT(in) :: comm_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_set_name_f08
    END interface PMPI_Comm_set_name
    
    interface PMPI_Comm_size
        subroutine PMPIR_Comm_size_f08(comm, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_size_f08
    END interface PMPI_Comm_size
    
    interface PMPI_Comm_split
        subroutine PMPIR_Comm_split_f08(comm, color, key, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: color
            INTEGER, INTENT(in) :: key
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_split_f08
    END interface PMPI_Comm_split
    
    interface PMPI_Comm_split_type
        subroutine PMPIR_Comm_split_type_f08(comm, split_type, key, info, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: split_type
            INTEGER, INTENT(in) :: key
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_split_type_f08
    END interface PMPI_Comm_split_type
    
    interface PMPI_Comm_test_inter
        subroutine PMPIR_Comm_test_inter_f08(comm, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_test_inter_f08
    END interface PMPI_Comm_test_inter
    
    interface PMPI_Intercomm_create
        subroutine PMPIR_Intercomm_create_f08(local_comm, local_leader, peer_comm, remote_leader, tag, &
                                            newintercomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: local_comm
            INTEGER, INTENT(in) :: local_leader
            TYPE(MPI_Comm), INTENT(in) :: peer_comm
            INTEGER, INTENT(in) :: remote_leader
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(out) :: newintercomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Intercomm_create_f08
    END interface PMPI_Intercomm_create
    
    interface PMPI_Intercomm_create_from_groups
        subroutine PMPIR_Intercomm_create_from_groups_f08(local_group, local_leader, remote_group, &
                                                        remote_leader, stringtag, info, errhandler, &
                                                        newintercomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group, MPI_Info, MPI_Errhandler, MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: local_group
            INTEGER, INTENT(in) :: local_leader
            TYPE(MPI_Group), INTENT(in) :: remote_group
            INTEGER, INTENT(in) :: remote_leader
            CHARACTER(len=*), INTENT(in) :: stringtag
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            TYPE(MPI_Comm), INTENT(out) :: newintercomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Intercomm_create_from_groups_f08
    END interface PMPI_Intercomm_create_from_groups
    
    interface PMPI_Intercomm_merge
        subroutine PMPIR_Intercomm_merge_f08(intercomm, high, newintracomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: intercomm
            LOGICAL, INTENT(in) :: high
            TYPE(MPI_Comm), INTENT(out) :: newintracomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Intercomm_merge_f08
    END interface PMPI_Intercomm_merge
    
    interface PMPI_Get_address
        subroutine PMPIR_Get_address_f08ts(location, address, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: location
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: address
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_address_f08ts
    END interface PMPI_Get_address
    
    interface PMPI_Get_count
        subroutine PMPIR_Get_count_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(out) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_count_f08
        
        subroutine PMPIR_Get_count_c_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_count_c_f08
    END interface PMPI_Get_count
    
    interface PMPI_Get_elements
        subroutine PMPIR_Get_elements_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(out) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_elements_f08
        
        subroutine PMPIR_Get_elements_c_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_elements_c_f08
    END interface PMPI_Get_elements
    
    interface PMPI_Get_elements_x
        subroutine PMPIR_Get_elements_x_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_elements_x_f08
    END interface PMPI_Get_elements_x
    
    interface PMPI_Get_hw_resource_info
        subroutine PMPIR_Get_hw_resource_info_f08(hw_info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(out) :: hw_info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_hw_resource_info_f08
    END interface PMPI_Get_hw_resource_info

    interface PMPI_Pack
        subroutine PMPIR_Pack_f08ts(inbuf, incount, datatype, outbuf, outsize, position, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER, INTENT(in) :: outsize
            INTEGER, INTENT(inout) :: position
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_f08ts
        
        subroutine PMPIR_Pack_c_f08ts(inbuf, incount, datatype, outbuf, outsize, position, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: outsize
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(inout) :: position
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_c_f08ts
    END interface PMPI_Pack
    
    interface PMPI_Pack_external
        subroutine PMPIR_Pack_external_f08ts(datarep, inbuf, incount, datatype, outbuf, outsize, position, &
                                           ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: outsize
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(inout) :: position
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_external_f08ts
        
        subroutine PMPIR_Pack_external_c_f08ts(datarep, inbuf, incount, datatype, outbuf, outsize, position, &
                                             ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: outsize
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(inout) :: position
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_external_c_f08ts
    END interface PMPI_Pack_external
    
    interface PMPI_Pack_external_size
        subroutine PMPIR_Pack_external_size_f08(datarep, incount, datatype, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_external_size_f08
        
        subroutine PMPIR_Pack_external_size_c_f08(datarep, incount, datatype, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_external_size_c_f08
    END interface PMPI_Pack_external_size
    
    interface PMPI_Pack_size
        subroutine PMPIR_Pack_size_f08(incount, datatype, comm, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_size_f08
        
        subroutine PMPIR_Pack_size_c_f08(incount, datatype, comm, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: incount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pack_size_c_f08
    END interface PMPI_Pack_size
    
    interface PMPI_Status_set_elements
        subroutine PMPIR_Status_set_elements_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_elements_f08
        
        subroutine PMPIR_Status_set_elements_c_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_elements_c_f08
    END interface PMPI_Status_set_elements
    
    interface PMPI_Status_set_elements_x
        subroutine PMPIR_Status_set_elements_x_f08(status, datatype, count, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_elements_x_f08
    END interface PMPI_Status_set_elements_x
    
    interface PMPI_Type_commit
        subroutine PMPIR_Type_commit_f08(datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(inout) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_commit_f08
    END interface PMPI_Type_commit
    
    interface PMPI_Type_contiguous
        subroutine PMPIR_Type_contiguous_f08(count, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_contiguous_f08
        
        subroutine PMPIR_Type_contiguous_c_f08(count, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_contiguous_c_f08
    END interface PMPI_Type_contiguous
    
    interface PMPI_Type_create_darray
        subroutine PMPIR_Type_create_darray_f08(size, rank, ndims, array_of_gsizes, array_of_distribs, &
                                              array_of_dargs, array_of_psizes, order, oldtype, newtype, &
                                              ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: size
            INTEGER, INTENT(in) :: rank
            INTEGER, INTENT(in) :: ndims
            INTEGER, INTENT(in) :: array_of_gsizes(ndims)
            INTEGER, INTENT(in) :: array_of_distribs(ndims)
            INTEGER, INTENT(in) :: array_of_dargs(ndims)
            INTEGER, INTENT(in) :: array_of_psizes(ndims)
            INTEGER, INTENT(in) :: order
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_darray_f08
        
        subroutine PMPIR_Type_create_darray_c_f08(size, rank, ndims, array_of_gsizes, array_of_distribs, &
                                                array_of_dargs, array_of_psizes, order, oldtype, newtype, &
                                                ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER, INTENT(in) :: size
            INTEGER, INTENT(in) :: rank
            INTEGER, INTENT(in) :: ndims
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_gsizes(ndims)
            INTEGER, INTENT(in) :: array_of_distribs(ndims)
            INTEGER, INTENT(in) :: array_of_dargs(ndims)
            INTEGER, INTENT(in) :: array_of_psizes(ndims)
            INTEGER, INTENT(in) :: order
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_darray_c_f08
    END interface PMPI_Type_create_darray
    
    interface PMPI_Type_create_hindexed
        subroutine PMPIR_Type_create_hindexed_f08(count, array_of_blocklengths, array_of_displacements, &
                                                oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: array_of_blocklengths(count)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_hindexed_f08
        
        subroutine PMPIR_Type_create_hindexed_c_f08(count, array_of_blocklengths, array_of_displacements, &
                                                  oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_blocklengths(count)
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_hindexed_c_f08
    END interface PMPI_Type_create_hindexed
    
    interface PMPI_Type_create_hindexed_block
        subroutine PMPIR_Type_create_hindexed_block_f08(count, blocklength, array_of_displacements, oldtype, &
                                                      newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: blocklength
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_hindexed_block_f08
        
        subroutine PMPIR_Type_create_hindexed_block_c_f08(count, blocklength, array_of_displacements, oldtype, &
                                                        newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: blocklength
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_hindexed_block_c_f08
    END interface PMPI_Type_create_hindexed_block
    
    interface PMPI_Type_create_hvector
        subroutine PMPIR_Type_create_hvector_f08(count, blocklength, stride, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: blocklength
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: stride
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_hvector_f08
        
        subroutine PMPIR_Type_create_hvector_c_f08(count, blocklength, stride, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: blocklength
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: stride
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_hvector_c_f08
    END interface PMPI_Type_create_hvector
    
    interface PMPI_Type_create_indexed_block
        subroutine PMPIR_Type_create_indexed_block_f08(count, blocklength, array_of_displacements, oldtype, &
                                                     newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: blocklength
            INTEGER, INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_indexed_block_f08
        
        subroutine PMPIR_Type_create_indexed_block_c_f08(count, blocklength, array_of_displacements, oldtype, &
                                                       newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: blocklength
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_indexed_block_c_f08
    END interface PMPI_Type_create_indexed_block
    
    interface PMPI_Type_create_resized
        subroutine PMPIR_Type_create_resized_f08(oldtype, lb, extent, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: lb
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extent
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_resized_f08
    END interface PMPI_Type_create_resized
    
    interface PMPI_Type_create_struct
        subroutine PMPIR_Type_create_struct_f08(count, array_of_blocklengths, array_of_displacements, &
                                              array_of_types, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: array_of_blocklengths(count)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: array_of_types(count)
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_struct_f08
        
        subroutine PMPIR_Type_create_struct_c_f08(count, array_of_blocklengths, array_of_displacements, &
                                                array_of_types, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_blocklengths(count)
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: array_of_types(count)
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_struct_c_f08
    END interface PMPI_Type_create_struct
    
    interface PMPI_Type_create_subarray
        subroutine PMPIR_Type_create_subarray_f08(ndims, array_of_sizes, array_of_subsizes, array_of_starts, &
                                                order, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: ndims
            INTEGER, INTENT(in) :: array_of_sizes(ndims)
            INTEGER, INTENT(in) :: array_of_subsizes(ndims)
            INTEGER, INTENT(in) :: array_of_starts(ndims)
            INTEGER, INTENT(in) :: order
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_subarray_f08
        
        subroutine PMPIR_Type_create_subarray_c_f08(ndims, array_of_sizes, array_of_subsizes, array_of_starts, &
                                                  order, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER, INTENT(in) :: ndims
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_sizes(ndims)
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_subsizes(ndims)
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_starts(ndims)
            INTEGER, INTENT(in) :: order
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_subarray_c_f08
    END interface PMPI_Type_create_subarray
    
    interface PMPI_Type_dup
        subroutine PMPIR_Type_dup_f08(oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_dup_f08
    END interface PMPI_Type_dup
    
    interface PMPI_Type_free
        subroutine PMPIR_Type_free_f08(datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(inout) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_free_f08
    END interface PMPI_Type_free
    
    interface PMPI_Type_get_contents
        subroutine PMPIR_Type_get_contents_f08(datatype, max_integers, max_addresses, max_datatypes, &
                                             array_of_integers, array_of_addresses, array_of_datatypes, &
                                             ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: max_integers
            INTEGER, INTENT(in) :: max_addresses
            INTEGER, INTENT(in) :: max_datatypes
            INTEGER, INTENT(out) :: array_of_integers(max_integers)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: array_of_addresses(max_addresses)
            TYPE(MPI_Datatype), INTENT(out) :: array_of_datatypes(max_datatypes)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_contents_f08
        
        subroutine PMPIR_Type_get_contents_c_f08(datatype, max_integers, max_addresses, max_large_counts, &
                                               max_datatypes, array_of_integers, array_of_addresses, &
                                               array_of_large_counts, array_of_datatypes, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: max_integers
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: max_addresses
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: max_large_counts
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: max_datatypes
            INTEGER, INTENT(out) :: array_of_integers(max_integers)
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: array_of_addresses(max_addresses)
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: array_of_large_counts(max_large_counts)
            TYPE(MPI_Datatype), INTENT(out) :: array_of_datatypes(max_datatypes)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_contents_c_f08
    END interface PMPI_Type_get_contents
    
    interface PMPI_Type_get_envelope
        subroutine PMPIR_Type_get_envelope_f08(datatype, num_integers, num_addresses, num_datatypes, combiner, &
                                             ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(out) :: num_integers
            INTEGER, INTENT(out) :: num_addresses
            INTEGER, INTENT(out) :: num_datatypes
            INTEGER, INTENT(out) :: combiner
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_envelope_f08
        
        subroutine PMPIR_Type_get_envelope_c_f08(datatype, num_integers, num_addresses, num_large_counts, &
                                               num_datatypes, combiner, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: num_integers
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: num_addresses
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: num_large_counts
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: num_datatypes
            INTEGER, INTENT(out) :: combiner
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_envelope_c_f08
    END interface PMPI_Type_get_envelope
    
    interface PMPI_Type_get_extent
        subroutine PMPIR_Type_get_extent_f08(datatype, lb, extent, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: lb
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: extent
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_extent_f08
    END interface PMPI_Type_get_extent
    
    interface PMPI_Type_get_extent_x
        subroutine PMPIR_Type_get_extent_x_f08(datatype, lb, extent, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: lb
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: extent
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_extent_x_f08
    END interface PMPI_Type_get_extent_x
    
    interface PMPI_Type_get_name
        subroutine PMPIR_Type_get_name_f08(datatype, type_name, resultlen, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_OBJECT_NAME
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            CHARACTER(len=MPI_MAX_OBJECT_NAME), INTENT(out) :: type_name
            INTEGER, INTENT(out) :: resultlen
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_name_f08
    END interface PMPI_Type_get_name
    
    interface PMPI_Type_get_true_extent
        subroutine PMPIR_Type_get_true_extent_f08(datatype, true_lb, true_extent, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: true_lb
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: true_extent
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_true_extent_f08
    END interface PMPI_Type_get_true_extent
    
    interface PMPI_Type_get_true_extent_x
        subroutine PMPIR_Type_get_true_extent_x_f08(datatype, true_lb, true_extent, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: true_lb
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: true_extent
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_true_extent_x_f08
    END interface PMPI_Type_get_true_extent_x
    
    interface PMPI_Type_get_value_index
        subroutine PMPIR_Type_get_value_index_f08(value_type, index_type, pair_type, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: value_type
            TYPE(MPI_Datatype), INTENT(in) :: index_type
            TYPE(MPI_Datatype), INTENT(out) :: pair_type
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_get_value_index_f08
    END interface PMPI_Type_get_value_index

    interface PMPI_Type_indexed
        subroutine PMPIR_Type_indexed_f08(count, array_of_blocklengths, array_of_displacements, oldtype, &
                                        newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: array_of_blocklengths(count)
            INTEGER, INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_indexed_f08
        
        subroutine PMPIR_Type_indexed_c_f08(count, array_of_blocklengths, array_of_displacements, oldtype, &
                                          newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_blocklengths(count)
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: array_of_displacements(count)
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_indexed_c_f08
    END interface PMPI_Type_indexed
    
    interface PMPI_Type_match_size
        subroutine PMPIR_Type_match_size_f08(typeclass, size, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: typeclass
            INTEGER, INTENT(in) :: size
            TYPE(MPI_Datatype), INTENT(out) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_match_size_f08
    END interface PMPI_Type_match_size
    
    interface PMPI_Type_set_name
        subroutine PMPIR_Type_set_name_f08(datatype, type_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            CHARACTER(len=*), INTENT(in) :: type_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_set_name_f08
    END interface PMPI_Type_set_name
    
    interface PMPI_Type_size
        subroutine PMPIR_Type_size_f08(datatype, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_size_f08
        
        subroutine PMPIR_Type_size_c_f08(datatype, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_size_c_f08
    END interface PMPI_Type_size
    
    interface PMPI_Type_size_x
        subroutine PMPIR_Type_size_x_f08(datatype, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_size_x_f08
    END interface PMPI_Type_size_x
    
    interface PMPI_Type_vector
        subroutine PMPIR_Type_vector_f08(count, blocklength, stride, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            INTEGER, INTENT(in) :: blocklength
            INTEGER, INTENT(in) :: stride
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_vector_f08
        
        subroutine PMPIR_Type_vector_c_f08(count, blocklength, stride, oldtype, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: blocklength
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: stride
            TYPE(MPI_Datatype), INTENT(in) :: oldtype
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_vector_c_f08
    END interface PMPI_Type_vector
    
    interface PMPI_Unpack
        subroutine PMPIR_Unpack_f08ts(inbuf, insize, position, outbuf, outcount, datatype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER, INTENT(in) :: insize
            INTEGER, INTENT(inout) :: position
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER, INTENT(in) :: outcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Unpack_f08ts
        
        subroutine PMPIR_Unpack_c_f08ts(inbuf, insize, position, outbuf, outcount, datatype, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: insize
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(inout) :: position
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: outcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Unpack_c_f08ts
    END interface PMPI_Unpack
    
    interface PMPI_Unpack_external
        subroutine PMPIR_Unpack_external_f08ts(datarep, inbuf, insize, position, outbuf, outcount, datatype, &
                                             ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: insize
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(inout) :: position
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER, INTENT(in) :: outcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Unpack_external_f08ts
        
        subroutine PMPIR_Unpack_external_c_f08ts(datarep, inbuf, insize, position, outbuf, outcount, datatype, &
                                               ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            TYPE(*), DIMENSION(..), INTENT(in) :: inbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: insize
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(inout) :: position
            TYPE(*), DIMENSION(..) :: outbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: outcount
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Unpack_external_c_f08ts
    END interface PMPI_Unpack_external
    
    interface PMPI_Add_error_class
        subroutine PMPIR_Add_error_class_f08(errorclass, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(out) :: errorclass
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Add_error_class_f08
    END interface PMPI_Add_error_class
    
    interface PMPI_Add_error_code
        subroutine PMPIR_Add_error_code_f08(errorclass, errorcode, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorclass
            INTEGER, INTENT(out) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Add_error_code_f08
    END interface PMPI_Add_error_code
    
    interface PMPI_Add_error_string
        subroutine PMPIR_Add_error_string_f08(errorcode, string, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorcode
            CHARACTER(len=*), INTENT(in) :: string
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Add_error_string_f08
    END interface PMPI_Add_error_string
    
    interface PMPI_Comm_call_errhandler
        subroutine PMPIR_Comm_call_errhandler_f08(comm, errorcode, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_call_errhandler_f08
    END interface PMPI_Comm_call_errhandler
    
    interface PMPI_Comm_create_errhandler
        subroutine PMPIR_Comm_create_errhandler_f08(comm_errhandler_fn, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Errhandler
            USE :: mpi_f08_callbacks, ONLY : MPI_Comm_errhandler_function
            IMPLICIT NONE
            PROCEDURE(MPI_Comm_errhandler_function) :: comm_errhandler_fn
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_create_errhandler_f08
    END interface PMPI_Comm_create_errhandler
    
    interface PMPI_Comm_get_errhandler
        subroutine PMPIR_Comm_get_errhandler_f08(comm, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_get_errhandler_f08
    END interface PMPI_Comm_get_errhandler
    
    interface PMPI_Comm_set_errhandler
        subroutine PMPIR_Comm_set_errhandler_f08(comm, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_set_errhandler_f08
    END interface PMPI_Comm_set_errhandler
    
    interface PMPI_Errhandler_free
        subroutine PMPIR_Errhandler_free_f08(errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Errhandler), INTENT(inout) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Errhandler_free_f08
    END interface PMPI_Errhandler_free
    
    interface PMPI_Error_class
        subroutine PMPIR_Error_class_f08(errorcode, errorclass, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorcode
            INTEGER, INTENT(out) :: errorclass
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Error_class_f08
    END interface PMPI_Error_class
    
    interface PMPI_Error_string
        subroutine PMPIR_Error_string_f08(errorcode, string, resultlen, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_ERROR_STRING
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorcode
            CHARACTER(len=MPI_MAX_ERROR_STRING), INTENT(out) :: string
            INTEGER, INTENT(out) :: resultlen
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Error_string_f08
    END interface PMPI_Error_string
    
    interface PMPI_File_call_errhandler
        subroutine PMPIR_File_call_errhandler_f08(fh, errorcode, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_call_errhandler_f08
    END interface PMPI_File_call_errhandler
    
    interface PMPI_File_create_errhandler
        subroutine PMPIR_File_create_errhandler_f08(file_errhandler_fn, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Errhandler
            USE :: mpi_f08_callbacks, ONLY : MPI_File_errhandler_function
            IMPLICIT NONE
            PROCEDURE(MPI_File_errhandler_function) :: file_errhandler_fn
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_create_errhandler_f08
    END interface PMPI_File_create_errhandler
    
    interface PMPI_File_get_errhandler
        subroutine PMPIR_File_get_errhandler_f08(file, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: file
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_errhandler_f08
    END interface PMPI_File_get_errhandler
    
    interface PMPI_File_set_errhandler
        subroutine PMPIR_File_set_errhandler_f08(file, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: file
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_set_errhandler_f08
    END interface PMPI_File_set_errhandler
    
    interface PMPI_Remove_error_class
        subroutine PMPIR_Remove_error_class_f08(errorclass, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorclass
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Remove_error_class_f08
    END interface PMPI_Remove_error_class
    
    interface PMPI_Remove_error_code
        subroutine PMPIR_Remove_error_code_f08(errorcode, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Remove_error_code_f08
    END interface PMPI_Remove_error_code
    
    interface PMPI_Remove_error_string
        subroutine PMPIR_Remove_error_string_f08(errorcode, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Remove_error_string_f08
    END interface PMPI_Remove_error_string

    interface PMPI_Session_call_errhandler
        subroutine PMPIR_Session_call_errhandler_f08(session, errorcode, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_call_errhandler_f08
    END interface PMPI_Session_call_errhandler
    
    interface PMPI_Session_create_errhandler
        subroutine PMPIR_Session_create_errhandler_f08(session_errhandler_fn, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Errhandler
            USE :: mpi_f08_callbacks, ONLY : MPI_Session_errhandler_function
            IMPLICIT NONE
            PROCEDURE(MPI_Session_errhandler_function) :: session_errhandler_fn
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_create_errhandler_f08
    END interface PMPI_Session_create_errhandler
    
    interface PMPI_Session_get_errhandler
        subroutine PMPIR_Session_get_errhandler_f08(session, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_get_errhandler_f08
    END interface PMPI_Session_get_errhandler
    
    interface PMPI_Session_set_errhandler
        subroutine PMPIR_Session_set_errhandler_f08(session, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_set_errhandler_f08
    END interface PMPI_Session_set_errhandler
    
    interface PMPI_Win_call_errhandler
        subroutine PMPIR_Win_call_errhandler_f08(win, errorcode, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_call_errhandler_f08
    END interface PMPI_Win_call_errhandler
    
    interface PMPI_Win_create_errhandler
        subroutine PMPIR_Win_create_errhandler_f08(win_errhandler_fn, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Errhandler
            USE :: mpi_f08_callbacks, ONLY : MPI_Win_errhandler_function
            IMPLICIT NONE
            PROCEDURE(MPI_Win_errhandler_function) :: win_errhandler_fn
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_create_errhandler_f08
    END interface PMPI_Win_create_errhandler
    
    interface PMPI_Win_get_errhandler
        subroutine PMPIR_Win_get_errhandler_f08(win, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Errhandler), INTENT(out) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_get_errhandler_f08
    END interface PMPI_Win_get_errhandler
    
    interface PMPI_Win_set_errhandler
        subroutine PMPIR_Win_set_errhandler_f08(win, errhandler, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win, MPI_Errhandler
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_set_errhandler_f08
    END interface PMPI_Win_set_errhandler
    
    interface PMPI_Group_compare
        subroutine PMPIR_Group_compare_f08(group1, group2, result, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group1
            TYPE(MPI_Group), INTENT(in) :: group2
            INTEGER, INTENT(out) :: result
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_compare_f08
    END interface PMPI_Group_compare
    
    interface PMPI_Group_difference
        subroutine PMPIR_Group_difference_f08(group1, group2, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group1
            TYPE(MPI_Group), INTENT(in) :: group2
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_difference_f08
    END interface PMPI_Group_difference
    
    interface PMPI_Group_excl
        subroutine PMPIR_Group_excl_f08(group, n, ranks, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(in) :: ranks(n)
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_excl_f08
    END interface PMPI_Group_excl
    
    interface PMPI_Group_free
        subroutine PMPIR_Group_free_f08(group, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(inout) :: group
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_free_f08
    END interface PMPI_Group_free
    
    interface PMPI_Group_incl
        subroutine PMPIR_Group_incl_f08(group, n, ranks, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(in) :: ranks(n)
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_incl_f08
    END interface PMPI_Group_incl
    
    interface PMPI_Group_intersection
        subroutine PMPIR_Group_intersection_f08(group1, group2, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group1
            TYPE(MPI_Group), INTENT(in) :: group2
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_intersection_f08
    END interface PMPI_Group_intersection
    
    interface PMPI_Group_range_excl
        subroutine PMPIR_Group_range_excl_f08(group, n, ranges, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(in) :: ranges(n, 3)
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_range_excl_f08
    END interface PMPI_Group_range_excl
    
    interface PMPI_Group_range_incl
        subroutine PMPIR_Group_range_incl_f08(group, n, ranges, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(in) :: ranges(n, 3)
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_range_incl_f08
    END interface PMPI_Group_range_incl
    
    interface PMPI_Group_rank
        subroutine PMPIR_Group_rank_f08(group, rank, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(out) :: rank
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_rank_f08
    END interface PMPI_Group_rank
    
    interface PMPI_Group_size
        subroutine PMPIR_Group_size_f08(group, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_size_f08
    END interface PMPI_Group_size
    
    interface PMPI_Group_translate_ranks
        subroutine PMPIR_Group_translate_ranks_f08(group1, n, ranks1, group2, ranks2, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group1
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(in) :: ranks1(n)
            TYPE(MPI_Group), INTENT(in) :: group2
            INTEGER, INTENT(out) :: ranks2(n)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_translate_ranks_f08
    END interface PMPI_Group_translate_ranks
    
    interface PMPI_Group_union
        subroutine PMPIR_Group_union_f08(group1, group2, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group1
            TYPE(MPI_Group), INTENT(in) :: group2
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_union_f08
    END interface PMPI_Group_union
    
    interface PMPI_Info_create
        subroutine PMPIR_Info_create_f08(info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(out) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_create_f08
    END interface PMPI_Info_create
    
    interface PMPI_Info_delete
        subroutine PMPIR_Info_delete_f08(info, key, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=*), INTENT(in) :: key
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_delete_f08
    END interface PMPI_Info_delete
    
    interface PMPI_Info_dup
        subroutine PMPIR_Info_dup_f08(info, newinfo, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Info), INTENT(out) :: newinfo
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_dup_f08
    END interface PMPI_Info_dup
    
    interface PMPI_Info_free
        subroutine PMPIR_Info_free_f08(info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(inout) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_free_f08
    END interface PMPI_Info_free

    interface PMPI_Info_get_string
        subroutine PMPIR_Info_get_string_f08(info, key, buflen, value, flag, ierror)
            use :: mpi_f08_types, only : MPI_Info
            implicit none
            type(MPI_Info), intent(in) :: info
            character(len=*), intent(in) :: key
            integer, intent(inout) :: buflen
            character(len=*), intent(out) :: value
            logical, intent(out) :: flag
            integer, optional, intent(out) :: ierror
        end subroutine PMPIR_Info_get_string_f08
    end interface PMPI_Info_get_string

    interface PMPI_Info_create_env
        subroutine PMPIR_Info_create_env_f08(info, ierror)
            use :: mpi_f08_types, only : MPI_Info
            implicit none
            type(MPI_Info), intent(out) :: info
            integer, optional, intent(out) :: ierror
        end subroutine PMPIR_Info_create_env_f08
    end interface PMPI_Info_create_env

    interface PMPI_Info_get
        subroutine PMPIR_Info_get_f08(info, key, valuelen, value, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=*), INTENT(in) :: key
            INTEGER, INTENT(in) :: valuelen
            CHARACTER(len=valuelen), INTENT(out) :: value
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_get_f08
    END interface PMPI_Info_get
    
    interface PMPI_Info_get_nkeys
        subroutine PMPIR_Info_get_nkeys_f08(info, nkeys, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(out) :: nkeys
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_get_nkeys_f08
    END interface PMPI_Info_get_nkeys
    
    interface PMPI_Info_get_nthkey
        subroutine PMPIR_Info_get_nthkey_f08(info, n, key, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(in) :: n
            CHARACTER(len=*), INTENT(out) :: key
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_get_nthkey_f08
    END interface PMPI_Info_get_nthkey
    
    interface PMPI_Info_get_valuelen
        subroutine PMPIR_Info_get_valuelen_f08(info, key, valuelen, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=*), INTENT(in) :: key
            INTEGER, INTENT(out) :: valuelen
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_get_valuelen_f08
    END interface PMPI_Info_get_valuelen
    
    interface PMPI_Info_set
        subroutine PMPIR_Info_set_f08(info, key, value, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=*), INTENT(in) :: key
            CHARACTER(len=*), INTENT(in) :: value
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Info_set_f08
    END interface PMPI_Info_set
    
    interface PMPI_Abort
        subroutine PMPIR_Abort_f08(comm, errorcode, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: errorcode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Abort_f08
    END interface PMPI_Abort
    
    interface PMPI_Comm_create_from_group
        subroutine PMPIR_Comm_create_from_group_f08(group, stringtag, info, errhandler, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group, MPI_Info, MPI_Errhandler, MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            CHARACTER(len=*), INTENT(in) :: stringtag
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_create_from_group_f08
    END interface PMPI_Comm_create_from_group
    
    interface PMPI_Finalize
        subroutine PMPIR_Finalize_f08(ierror)
            IMPLICIT NONE
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Finalize_f08
    END interface PMPI_Finalize
    
    interface PMPI_Finalized
        subroutine PMPIR_Finalized_f08(flag, ierror)
            IMPLICIT NONE
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Finalized_f08
    END interface PMPI_Finalized
    
    interface PMPI_Group_from_session_pset
        subroutine PMPIR_Group_from_session_pset_f08(session, pset_name, newgroup, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            CHARACTER(len=*), INTENT(in) :: pset_name
            TYPE(MPI_Group), INTENT(out) :: newgroup
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Group_from_session_pset_f08
    END interface PMPI_Group_from_session_pset
    
    interface PMPI_Init
        subroutine PMPIR_Init_f08(ierror)
            IMPLICIT NONE
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Init_f08
    END interface PMPI_Init
    
    interface PMPI_Init_thread
        subroutine PMPIR_Init_thread_f08(required, provided, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: required
            INTEGER, INTENT(out) :: provided
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Init_thread_f08
    END interface PMPI_Init_thread
    
    interface PMPI_Initialized
        subroutine PMPIR_Initialized_f08(flag, ierror)
            IMPLICIT NONE
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Initialized_f08
    END interface PMPI_Initialized
    
    interface PMPI_Is_thread_main
        subroutine PMPIR_Is_thread_main_f08(flag, ierror)
            IMPLICIT NONE
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Is_thread_main_f08
    END interface PMPI_Is_thread_main
    
    interface PMPI_Query_thread
        subroutine PMPIR_Query_thread_f08(provided, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(out) :: provided
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Query_thread_f08
    END interface PMPI_Query_thread
    
    interface PMPI_Session_finalize
        subroutine PMPIR_Session_finalize_f08(session, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(inout) :: session
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_finalize_f08
    END interface PMPI_Session_finalize
    
    interface PMPI_Session_get_info
        subroutine PMPIR_Session_get_info_f08(session, info_used, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(MPI_Info), INTENT(out) :: info_used
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_get_info_f08
    END interface PMPI_Session_get_info
    
    interface PMPI_Session_get_nth_pset
        subroutine PMPIR_Session_get_nth_pset_f08(session, info, n, pset_len, pset_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(inout) :: pset_len
            CHARACTER(len=*), INTENT(out) :: pset_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_get_nth_pset_f08
    END interface PMPI_Session_get_nth_pset
    
    interface PMPI_Session_get_num_psets
        subroutine PMPIR_Session_get_num_psets_f08(session, info, npset_names, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(out) :: npset_names
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_get_num_psets_f08
    END interface PMPI_Session_get_num_psets
    
    interface PMPI_Session_get_pset_info
        subroutine PMPIR_Session_get_pset_info_f08(session, pset_name, info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            CHARACTER(len=*), INTENT(in) :: pset_name
            TYPE(MPI_Info), INTENT(out) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_get_pset_info_f08
    END interface PMPI_Session_get_pset_info
    
    interface PMPI_Session_init
        subroutine PMPIR_Session_init_f08(info, errhandler, session, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Errhandler, MPI_Session
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Errhandler), INTENT(in) :: errhandler
            TYPE(MPI_Session), INTENT(out) :: session
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_init_f08
    END interface PMPI_Session_init
    
    interface PMPI_Aint_add
        function PMPIR_Aint_add_f08(base, disp) result(res)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: base
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: disp
            INTEGER(KIND=MPI_ADDRESS_KIND) :: res
        END function PMPIR_Aint_add_f08
    END interface PMPI_Aint_add
    
    interface PMPI_Aint_diff
        function PMPIR_Aint_diff_f08(addr1, addr2) result(res)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: addr1
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: addr2
            INTEGER(KIND=MPI_ADDRESS_KIND) :: res
        END function PMPIR_Aint_diff_f08
    END interface PMPI_Aint_diff
    
    interface PMPI_Get_library_version
        subroutine PMPIR_Get_library_version_f08(version, resultlen, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_LIBRARY_VERSION_STRING
            IMPLICIT NONE
            CHARACTER(len=MPI_MAX_LIBRARY_VERSION_STRING), INTENT(out) :: version
            INTEGER, INTENT(out) :: resultlen
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_library_version_f08
    END interface PMPI_Get_library_version
    
    interface PMPI_Get_processor_name
        subroutine PMPIR_Get_processor_name_f08(name, resultlen, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_PROCESSOR_NAME
            IMPLICIT NONE
            CHARACTER(len=MPI_MAX_PROCESSOR_NAME), INTENT(out) :: name
            INTEGER, INTENT(out) :: resultlen
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_processor_name_f08
    END interface PMPI_Get_processor_name
    
    interface PMPI_Get_version
        subroutine PMPIR_Get_version_f08(version, subversion, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(out) :: version
            INTEGER, INTENT(out) :: subversion
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_version_f08
    END interface PMPI_Get_version
    
    interface PMPI_Pcontrol
        subroutine PMPIR_Pcontrol_f08(level, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: level
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pcontrol_f08
    END interface PMPI_Pcontrol
    
    interface PMPI_Op_commutative
        subroutine PMPIR_Op_commutative_f08(op, commute, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Op
            IMPLICIT NONE
            TYPE(MPI_Op), INTENT(in) :: op
            LOGICAL, INTENT(out) :: commute
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Op_commutative_f08
    END interface PMPI_Op_commutative
    
    interface PMPI_Op_create
        subroutine PMPIR_Op_create_f08(user_fn, commute, op, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Op
            USE :: mpi_f08_callbacks, ONLY : MPI_User_function
            IMPLICIT NONE
            PROCEDURE(MPI_User_function) :: user_fn
            LOGICAL, INTENT(in) :: commute
            TYPE(MPI_Op), INTENT(out) :: op
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Op_create_f08
    END interface PMPI_Op_create
    
    interface PMPI_Op_create_c
        subroutine PMPIR_Op_create_c_f08(user_fn, commute, op, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Op
            USE :: mpi_f08_callbacks, ONLY : MPI_User_function_c
            IMPLICIT NONE
            PROCEDURE(MPI_User_function_c) :: user_fn
            LOGICAL, INTENT(in) :: commute
            TYPE(MPI_Op), INTENT(out) :: op
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Op_create_c_f08
    END interface PMPI_Op_create_c
    
    interface PMPI_Op_free
        subroutine PMPIR_Op_free_f08(op, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Op
            IMPLICIT NONE
            TYPE(MPI_Op), INTENT(inout) :: op
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Op_free_f08
    END interface PMPI_Op_free
    
    interface PMPI_Parrived
        subroutine PMPIR_Parrived_f08(request, partition, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(in) :: request
            INTEGER, INTENT(in) :: partition
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Parrived_f08
    END interface PMPI_Parrived
    
    interface PMPI_Pready
        subroutine PMPIR_Pready_f08(partition, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            INTEGER, INTENT(in) :: partition
            TYPE(MPI_Request), INTENT(in) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pready_f08
    END interface PMPI_Pready
    
    interface PMPI_Pready_list
        subroutine PMPIR_Pready_list_f08(length, array_of_partitions, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            INTEGER, INTENT(in) :: length
            INTEGER, INTENT(in) :: array_of_partitions(length)
            TYPE(MPI_Request), INTENT(in) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pready_list_f08
    END interface PMPI_Pready_list
    
    interface PMPI_Pready_range
        subroutine PMPIR_Pready_range_f08(partition_low, partition_high, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            INTEGER, INTENT(in) :: partition_low
            INTEGER, INTENT(in) :: partition_high
            TYPE(MPI_Request), INTENT(in) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Pready_range_f08
    END interface PMPI_Pready_range
    
    interface PMPI_Precv_init
        subroutine PMPIR_Precv_init_f08ts(buf, partitions, count, datatype, dest, tag, comm, info, request, &
                                        ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: partitions
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Precv_init_f08ts
    END interface PMPI_Precv_init
    
    interface PMPI_Psend_init
        subroutine PMPIR_Psend_init_f08ts(buf, partitions, count, datatype, dest, tag, comm, info, request, &
                                        ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Info, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: partitions
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Psend_init_f08ts
    END interface PMPI_Psend_init
    
    interface PMPI_Bsend
        subroutine PMPIR_Bsend_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bsend_f08ts
        
        subroutine PMPIR_Bsend_c_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bsend_c_f08ts
    END interface PMPI_Bsend
    
    interface PMPI_Bsend_init
        subroutine PMPIR_Bsend_init_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bsend_init_f08ts
        
        subroutine PMPIR_Bsend_init_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Bsend_init_c_f08ts
    END interface PMPI_Bsend_init
    
    interface PMPI_Buffer_attach
        subroutine PMPIR_Buffer_attach_f08ts(buffer, size, ierror)
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER, INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Buffer_attach_f08ts
        
        subroutine PMPIR_Buffer_attach_c_f08ts(buffer, size, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Buffer_attach_c_f08ts
    END interface PMPI_Buffer_attach
    
    interface PMPI_Buffer_detach
        subroutine PMPIR_Buffer_detach_f08(buffer_addr, size, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            IMPLICIT NONE
            TYPE(C_PTR), INTENT(out) :: buffer_addr
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Buffer_detach_f08
        
        subroutine PMPIR_Buffer_detach_c_f08(buffer_addr, size, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(C_PTR), INTENT(out) :: buffer_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Buffer_detach_c_f08
    END interface PMPI_Buffer_detach
    
    interface PMPI_Buffer_flush
        subroutine PMPIR_Buffer_flush_f08(ierror)
            IMPLICIT NONE
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Buffer_flush_f08
    END interface PMPI_Buffer_flush

    interface PMPI_Buffer_iflush
        subroutine PMPIR_Buffer_iflush_f08(request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Buffer_iflush_f08
    END interface PMPI_Buffer_iflush

    interface PMPI_Ibsend
        subroutine PMPIR_Ibsend_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ibsend_f08ts
        
        subroutine PMPIR_Ibsend_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ibsend_c_f08ts
    END interface PMPI_Ibsend
    
    interface PMPI_Improbe
        subroutine PMPIR_Improbe_f08(source, tag, comm, flag, message, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Message, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Message), INTENT(out) :: message
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Improbe_f08
    END interface PMPI_Improbe
    
    interface PMPI_Imrecv
        subroutine PMPIR_Imrecv_f08ts(buf, count, datatype, message, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Message, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Message), INTENT(inout) :: message
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Imrecv_f08ts
        
        subroutine PMPIR_Imrecv_c_f08ts(buf, count, datatype, message, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Message, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Message), INTENT(inout) :: message
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Imrecv_c_f08ts
    END interface PMPI_Imrecv
    
    interface PMPI_Iprobe
        subroutine PMPIR_Iprobe_f08(source, tag, comm, flag, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Iprobe_f08
    END interface PMPI_Iprobe
    
    interface PMPI_Irecv
        subroutine PMPIR_Irecv_f08ts(buf, count, datatype, source, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Irecv_f08ts
        
        subroutine PMPIR_Irecv_c_f08ts(buf, count, datatype, source, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Irecv_c_f08ts
    END interface PMPI_Irecv
    
    interface PMPI_Irsend
        subroutine PMPIR_Irsend_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Irsend_f08ts
        
        subroutine PMPIR_Irsend_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Irsend_c_f08ts
    END interface PMPI_Irsend
    
    interface PMPI_Isend
        subroutine PMPIR_Isend_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Isend_f08ts
        
        subroutine PMPIR_Isend_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Isend_c_f08ts
    END interface PMPI_Isend
    
    interface PMPI_Issend
        subroutine PMPIR_Issend_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Issend_f08ts
        
        subroutine PMPIR_Issend_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Issend_c_f08ts
    END interface PMPI_Issend
    
    interface PMPI_Mprobe
        subroutine PMPIR_Mprobe_f08(source, tag, comm, message, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Message, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Message), INTENT(out) :: message
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Mprobe_f08
    END interface PMPI_Mprobe
    
    interface PMPI_Mrecv
        subroutine PMPIR_Mrecv_f08ts(buf, count, datatype, message, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Message, MPI_Status
            IMPLICIT NONE
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Message), INTENT(inout) :: message
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Mrecv_f08ts
        
        subroutine PMPIR_Mrecv_c_f08ts(buf, count, datatype, message, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Message, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Message), INTENT(inout) :: message
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Mrecv_c_f08ts
    END interface PMPI_Mrecv
    
    interface PMPI_Probe
        subroutine PMPIR_Probe_f08(source, tag, comm, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Probe_f08
    END interface PMPI_Probe
    
    interface PMPI_Recv
        subroutine PMPIR_Recv_f08ts(buf, count, datatype, source, tag, comm, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Status
            IMPLICIT NONE
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Recv_f08ts
        
        subroutine PMPIR_Recv_c_f08ts(buf, count, datatype, source, tag, comm, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Recv_c_f08ts
    END interface PMPI_Recv
    
    interface PMPI_Recv_init
        subroutine PMPIR_Recv_init_f08ts(buf, count, datatype, source, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Recv_init_f08ts
        
        subroutine PMPIR_Recv_init_c_f08ts(buf, count, datatype, source, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Recv_init_c_f08ts
    END interface PMPI_Recv_init
    
    interface PMPI_Rsend
        subroutine PMPIR_Rsend_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rsend_f08ts
        
        subroutine PMPIR_Rsend_c_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rsend_c_f08ts
    END interface PMPI_Rsend
    
    interface PMPI_Rsend_init
        subroutine PMPIR_Rsend_init_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rsend_init_f08ts
        
        subroutine PMPIR_Rsend_init_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rsend_init_c_f08ts
    END interface PMPI_Rsend_init
    
    interface PMPI_Send
        subroutine PMPIR_Send_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Send_f08ts
        
        subroutine PMPIR_Send_c_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Send_c_f08ts
    END interface PMPI_Send
    
    interface PMPI_Send_init
        subroutine PMPIR_Send_init_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Send_init_f08ts
        
        subroutine PMPIR_Send_init_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Send_init_c_f08ts
    END interface PMPI_Send_init
    
    interface PMPI_Sendrecv
        subroutine PMPIR_Sendrecv_f08ts(sendbuf, sendcount, sendtype, dest, sendtag, recvbuf, recvcount, &
                                      recvtype, source, recvtag, comm, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Status
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER, INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: sendtag
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER, INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: recvtag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Sendrecv_f08ts
        
        subroutine PMPIR_Sendrecv_c_f08ts(sendbuf, sendcount, sendtype, dest, sendtag, recvbuf, recvcount, &
                                        recvtype, source, recvtag, comm, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: sendbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: sendcount
            TYPE(MPI_Datatype), INTENT(in) :: sendtype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: sendtag
            TYPE(*), DIMENSION(..) :: recvbuf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: recvcount
            TYPE(MPI_Datatype), INTENT(in) :: recvtype
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: recvtag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Sendrecv_c_f08ts
    END interface PMPI_Sendrecv
    
    interface PMPI_Sendrecv_replace
        subroutine PMPIR_Sendrecv_replace_f08ts(buf, count, datatype, dest, sendtag, source, recvtag, comm, &
                                              status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Status
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: sendtag
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: recvtag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Sendrecv_replace_f08ts
        
        subroutine PMPIR_Sendrecv_replace_c_f08ts(buf, count, datatype, dest, sendtag, source, recvtag, comm, &
                                                status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: sendtag
            INTEGER, INTENT(in) :: source
            INTEGER, INTENT(in) :: recvtag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Sendrecv_replace_c_f08ts
    END interface PMPI_Sendrecv_replace

    interface PMPI_Session_attach_buffer
        subroutine PMPIR_Session_attach_buffer_f08ts(session, buffer, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER, INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_attach_buffer_f08ts
        
        subroutine PMPIR_Session_attach_buffer_c_f08ts(session, buffer, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buffer
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_attach_buffer_c_f08ts
    END interface PMPI_Session_attach_buffer

    interface PMPI_Session_detach_buffer
        subroutine PMPIR_Session_detach_buffer_f08(session, buffer_addr, size, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Session
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(C_PTR), INTENT(out) :: buffer_addr
            INTEGER, INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_detach_buffer_f08
        
        subroutine PMPIR_Session_detach_buffer_c_f08(session, buffer_addr, size, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Session
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(C_PTR), INTENT(out) :: buffer_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_detach_buffer_c_f08
    END interface PMPI_Session_detach_buffer
    
    interface PMPI_Session_flush_buffer
        subroutine PMPIR_Session_flush_buffer_f08(session, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_flush_buffer_f08
    END interface PMPI_Session_flush_buffer
    
    interface PMPI_Session_iflush_buffer
        subroutine PMPIR_Session_iflush_buffer_f08(session, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Session, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Session), INTENT(in) :: session
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Session_iflush_buffer_f08
    END interface PMPI_Session_iflush_buffer

    interface PMPI_Ssend
        subroutine PMPIR_Ssend_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ssend_f08ts
        
        subroutine PMPIR_Ssend_c_f08ts(buf, count, datatype, dest, tag, comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ssend_c_f08ts
    END interface PMPI_Ssend
    
    interface PMPI_Ssend_init
        subroutine PMPIR_Ssend_init_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ssend_init_f08ts
        
        subroutine PMPIR_Ssend_init_c_f08ts(buf, count, datatype, dest, tag, comm, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Comm, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: dest
            INTEGER, INTENT(in) :: tag
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Ssend_init_c_f08ts
    END interface PMPI_Ssend_init
    
    interface PMPI_Cancel
        subroutine PMPIR_Cancel_f08(request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(in) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cancel_f08
    END interface PMPI_Cancel
    
    interface PMPI_Grequest_complete
        subroutine PMPIR_Grequest_complete_f08(request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(in) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Grequest_complete_f08
    END interface PMPI_Grequest_complete
    
    interface PMPI_Grequest_start
        subroutine PMPIR_Grequest_start_f08(query_fn, free_fn, cancel_fn, extra_state, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            USE :: mpi_f08_callbacks, ONLY : MPI_Grequest_query_function, MPI_Grequest_free_function, &
                MPI_Grequest_cancel_function
            IMPLICIT NONE
            PROCEDURE(MPI_Grequest_query_function) :: query_fn
            PROCEDURE(MPI_Grequest_free_function) :: free_fn
            PROCEDURE(MPI_Grequest_cancel_function) :: cancel_fn
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extra_state
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Grequest_start_f08
    END interface PMPI_Grequest_start
    
    interface PMPI_Request_free
        subroutine PMPIR_Request_free_f08(request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(inout) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Request_free_f08
    END interface PMPI_Request_free
    
    interface PMPI_Request_get_status
        subroutine PMPIR_Request_get_status_f08(request, flag, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(in) :: request
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Request_get_status_f08
    END interface PMPI_Request_get_status
    
    interface PMPI_Request_get_status_all
        subroutine PMPIR_Request_get_status_all_f08(count, array_of_requests, flag, array_of_statuses, &
                                                  ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(in) :: array_of_requests(count)
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: array_of_statuses(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Request_get_status_all_f08
    END interface PMPI_Request_get_status_all
    
    interface PMPI_Request_get_status_any
        subroutine PMPIR_Request_get_status_any_f08(count, array_of_requests, indx, flag, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(in) :: array_of_requests(count)
            INTEGER, INTENT(out) :: indx
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Request_get_status_any_f08
    END interface PMPI_Request_get_status_any
    
    interface PMPI_Request_get_status_some
        subroutine PMPIR_Request_get_status_some_f08(incount, array_of_requests, outcount, array_of_indices, &
                                                   array_of_statuses, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Request), INTENT(in) :: array_of_requests(incount)
            INTEGER, INTENT(out) :: outcount
            INTEGER, INTENT(out) :: array_of_indices(*)
            TYPE(MPI_Status), INTENT(out), TARGET :: array_of_statuses(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Request_get_status_some_f08
    END interface PMPI_Request_get_status_some
    
    interface PMPI_Start
        subroutine PMPIR_Start_f08(request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(inout) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Start_f08
    END interface PMPI_Start
    
    interface PMPI_Startall
        subroutine PMPIR_Startall_f08(count, array_of_requests, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(count)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Startall_f08
    END interface PMPI_Startall
    
    interface PMPI_Status_get_error
        subroutine PMPIR_Status_get_error_f08(status, error, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            INTEGER, INTENT(out) :: error
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_get_error_f08
    END interface PMPI_Status_get_error
    
    interface PMPI_Status_get_source
        subroutine PMPIR_Status_get_source_f08(status, source, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            INTEGER, INTENT(out) :: source
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_get_source_f08
    END interface PMPI_Status_get_source
    
    interface PMPI_Status_get_tag
        subroutine PMPIR_Status_get_tag_f08(status, tag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            INTEGER, INTENT(out) :: tag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_get_tag_f08
    END interface PMPI_Status_get_tag
    
    interface PMPI_Status_set_error
        subroutine PMPIR_Status_set_error_f08(status, error, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            INTEGER, INTENT(in) :: error
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_error_f08
    END interface PMPI_Status_set_error
    
    interface PMPI_Status_set_source
        subroutine PMPIR_Status_set_source_f08(status, source, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            INTEGER, INTENT(in) :: source
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_source_f08
    END interface PMPI_Status_set_source
    
    interface PMPI_Status_set_tag
        subroutine PMPIR_Status_set_tag_f08(status, tag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            INTEGER, INTENT(in) :: tag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_tag_f08
    END interface PMPI_Status_set_tag
    
    interface PMPI_Status_set_cancelled
        subroutine PMPIR_Status_set_cancelled_f08(status, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(inout), TARGET :: status
            LOGICAL, INTENT(in) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Status_set_cancelled_f08
    END interface PMPI_Status_set_cancelled
    
    interface PMPI_Test
        subroutine PMPIR_Test_f08(request, flag, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(inout) :: request
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Test_f08
    END interface PMPI_Test
    
    interface PMPI_Test_cancelled
        subroutine PMPIR_Test_cancelled_f08(status, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Status), INTENT(in), TARGET :: status
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Test_cancelled_f08
    END interface PMPI_Test_cancelled
    
    interface PMPI_Testall
        subroutine PMPIR_Testall_f08(count, array_of_requests, flag, array_of_statuses, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(count)
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: array_of_statuses(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Testall_f08
    END interface PMPI_Testall
    
    interface PMPI_Testany
        subroutine PMPIR_Testany_f08(count, array_of_requests, indx, flag, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(count)
            INTEGER, INTENT(out) :: indx
            LOGICAL, INTENT(out) :: flag
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Testany_f08
    END interface PMPI_Testany
    
    interface PMPI_Testsome
        subroutine PMPIR_Testsome_f08(incount, array_of_requests, outcount, array_of_indices, &
                                    array_of_statuses, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(incount)
            INTEGER, INTENT(out) :: outcount
            INTEGER, INTENT(out) :: array_of_indices(*)
            TYPE(MPI_Status), INTENT(out), TARGET :: array_of_statuses(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Testsome_f08
    END interface PMPI_Testsome
    
    interface PMPI_Wait
        subroutine PMPIR_Wait_f08(request, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_Request), INTENT(inout) :: request
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Wait_f08
    END interface PMPI_Wait
    
    interface PMPI_Waitall
        subroutine PMPIR_Waitall_f08(count, array_of_requests, array_of_statuses, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(count)
            TYPE(MPI_Status), INTENT(out), TARGET :: array_of_statuses(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Waitall_f08
    END interface PMPI_Waitall
    
    interface PMPI_Waitany
        subroutine PMPIR_Waitany_f08(count, array_of_requests, indx, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(count)
            INTEGER, INTENT(out) :: indx
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Waitany_f08
    END interface PMPI_Waitany
    
    interface PMPI_Waitsome
        subroutine PMPIR_Waitsome_f08(incount, array_of_requests, outcount, array_of_indices, &
                                    array_of_statuses, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Request, MPI_Status
            IMPLICIT NONE
            INTEGER, INTENT(in) :: incount
            TYPE(MPI_Request), INTENT(inout) :: array_of_requests(incount)
            INTEGER, INTENT(out) :: outcount
            INTEGER, INTENT(out) :: array_of_indices(*)
            TYPE(MPI_Status), INTENT(out), TARGET :: array_of_statuses(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Waitsome_f08
    END interface PMPI_Waitsome
    
    interface PMPI_Accumulate
        subroutine PMPIR_Accumulate_f08ts(origin_addr, origin_count, origin_datatype, target_rank, &
                                        target_disp, target_count, target_datatype, op, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Accumulate_f08ts
        
        subroutine PMPIR_Accumulate_c_f08ts(origin_addr, origin_count, origin_datatype, target_rank, &
                                          target_disp, target_count, target_datatype, op, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Accumulate_c_f08ts
    END interface PMPI_Accumulate
    
    interface PMPI_Alloc_mem
        subroutine PMPIR_Alloc_mem_f08(size, info, baseptr, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Info
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(C_PTR), INTENT(out) :: baseptr
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Alloc_mem_f08
    END interface PMPI_Alloc_mem
    
    interface PMPI_Compare_and_swap
        subroutine PMPIR_Compare_and_swap_f08ts(origin_addr, compare_addr, result_addr, datatype, target_rank, &
                                              target_disp, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: compare_addr
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: result_addr
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Compare_and_swap_f08ts
    END interface PMPI_Compare_and_swap
    
    interface PMPI_Fetch_and_op
        subroutine PMPIR_Fetch_and_op_f08ts(origin_addr, result_addr, datatype, target_rank, target_disp, op, &
                                          win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: result_addr
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Fetch_and_op_f08ts
    END interface PMPI_Fetch_and_op
    
    interface PMPI_Free_mem
        subroutine PMPIR_Free_mem_f08(base, ierror)
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: base
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Free_mem_f08
    END interface PMPI_Free_mem
    
    interface PMPI_Get
        subroutine PMPIR_Get_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                 target_count, target_datatype, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_f08ts
        
        subroutine PMPIR_Get_c_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                   target_count, target_datatype, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_c_f08ts
    END interface PMPI_Get
    
    interface PMPI_Get_accumulate
        subroutine PMPIR_Get_accumulate_f08ts(origin_addr, origin_count, origin_datatype, result_addr, &
                                            result_count, result_datatype, target_rank, target_disp, &
                                            target_count, target_datatype, op, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: result_addr
            INTEGER, INTENT(in) :: result_count
            TYPE(MPI_Datatype), INTENT(in) :: result_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_accumulate_f08ts
        
        subroutine PMPIR_Get_accumulate_c_f08ts(origin_addr, origin_count, origin_datatype, result_addr, &
                                              result_count, result_datatype, target_rank, target_disp, &
                                              target_count, target_datatype, op, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: result_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: result_count
            TYPE(MPI_Datatype), INTENT(in) :: result_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Get_accumulate_c_f08ts
    END interface PMPI_Get_accumulate
    
    interface PMPI_Put
        subroutine PMPIR_Put_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                 target_count, target_datatype, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Put_f08ts
        
        subroutine PMPIR_Put_c_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                   target_count, target_datatype, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Put_c_f08ts
    END interface PMPI_Put
    
    interface PMPI_Raccumulate
        subroutine PMPIR_Raccumulate_f08ts(origin_addr, origin_count, origin_datatype, target_rank, &
                                         target_disp, target_count, target_datatype, op, win, request, &
                                         ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Raccumulate_f08ts
        
        subroutine PMPIR_Raccumulate_c_f08ts(origin_addr, origin_count, origin_datatype, target_rank, &
                                           target_disp, target_count, target_datatype, op, win, request, &
                                           ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Raccumulate_c_f08ts
    END interface PMPI_Raccumulate
    
    interface PMPI_Rget
        subroutine PMPIR_Rget_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                  target_count, target_datatype, win, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rget_f08ts
        
        subroutine PMPIR_Rget_c_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                    target_count, target_datatype, win, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rget_c_f08ts
    END interface PMPI_Rget
    
    interface PMPI_Rget_accumulate
        subroutine PMPIR_Rget_accumulate_f08ts(origin_addr, origin_count, origin_datatype, result_addr, &
                                             result_count, result_datatype, target_rank, target_disp, &
                                             target_count, target_datatype, op, win, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: result_addr
            INTEGER, INTENT(in) :: result_count
            TYPE(MPI_Datatype), INTENT(in) :: result_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rget_accumulate_f08ts
        
        subroutine PMPIR_Rget_accumulate_c_f08ts(origin_addr, origin_count, origin_datatype, result_addr, &
                                               result_count, result_datatype, target_rank, target_disp, &
                                               target_count, target_datatype, op, win, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Op, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: result_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: result_count
            TYPE(MPI_Datatype), INTENT(in) :: result_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Op), INTENT(in) :: op
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rget_accumulate_c_f08ts
    END interface PMPI_Rget_accumulate
    
    interface PMPI_Rput
        subroutine PMPIR_Rput_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                  target_count, target_datatype, win, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER, INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER, INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rput_f08ts
        
        subroutine PMPIR_Rput_c_f08ts(origin_addr, origin_count, origin_datatype, target_rank, target_disp, &
                                    target_count, target_datatype, win, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype, MPI_Win, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND, MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: origin_addr
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: origin_count
            TYPE(MPI_Datatype), INTENT(in) :: origin_datatype
            INTEGER, INTENT(in) :: target_rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: target_disp
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: target_count
            TYPE(MPI_Datatype), INTENT(in) :: target_datatype
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Rput_c_f08ts
    END interface PMPI_Rput
    
    interface PMPI_Win_allocate
        subroutine PMPIR_Win_allocate_f08(size, disp_unit, info, comm, baseptr, win, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER, INTENT(in) :: disp_unit
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(C_PTR), INTENT(out) :: baseptr
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_allocate_f08
        
        subroutine PMPIR_Win_allocate_c_f08(size, disp_unit, info, comm, baseptr, win, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: disp_unit
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(C_PTR), INTENT(out) :: baseptr
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_allocate_c_f08
    END interface PMPI_Win_allocate
    
    interface PMPI_Win_allocate_shared
        subroutine PMPIR_Win_allocate_shared_f08(size, disp_unit, info, comm, baseptr, win, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER, INTENT(in) :: disp_unit
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(C_PTR), INTENT(out) :: baseptr
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_allocate_shared_f08
        
        subroutine PMPIR_Win_allocate_shared_c_f08(size, disp_unit, info, comm, baseptr, win, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: disp_unit
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(C_PTR), INTENT(out) :: baseptr
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_allocate_shared_c_f08
    END interface PMPI_Win_allocate_shared
    
    interface PMPI_Win_attach
        subroutine PMPIR_Win_attach_f08ts(win, base, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: base
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_attach_f08ts
    END interface PMPI_Win_attach
    
    interface PMPI_Win_complete
        subroutine PMPIR_Win_complete_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_complete_f08
    END interface PMPI_Win_complete
    
    interface PMPI_Win_create
        subroutine PMPIR_Win_create_f08ts(base, size, disp_unit, info, comm, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: base
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER, INTENT(in) :: disp_unit
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_create_f08ts
        
        subroutine PMPIR_Win_create_c_f08ts(base, size, disp_unit, info, comm, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: base
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: size
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: disp_unit
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_create_c_f08ts
    END interface PMPI_Win_create
    
    interface PMPI_Win_create_dynamic
        subroutine PMPIR_Win_create_dynamic_f08(info, comm, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm, MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Win), INTENT(out) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_create_dynamic_f08
    END interface PMPI_Win_create_dynamic
    
    interface PMPI_Win_detach
        subroutine PMPIR_Win_detach_f08ts(win, base, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: base
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_detach_f08ts
    END interface PMPI_Win_detach
    
    interface PMPI_Win_fence
        subroutine PMPIR_Win_fence_f08(assert, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            INTEGER, INTENT(in) :: assert
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_fence_f08
    END interface PMPI_Win_fence
    
    interface PMPI_Win_flush
        subroutine PMPIR_Win_flush_f08(rank, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            INTEGER, INTENT(in) :: rank
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_flush_f08
    END interface PMPI_Win_flush
    
    interface PMPI_Win_flush_all
        subroutine PMPIR_Win_flush_all_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_flush_all_f08
    END interface PMPI_Win_flush_all
    
    interface PMPI_Win_flush_local
        subroutine PMPIR_Win_flush_local_f08(rank, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            INTEGER, INTENT(in) :: rank
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_flush_local_f08
    END interface PMPI_Win_flush_local
    
    interface PMPI_Win_flush_local_all
        subroutine PMPIR_Win_flush_local_all_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_flush_local_all_f08
    END interface PMPI_Win_flush_local_all
    
    interface PMPI_Win_free
        subroutine PMPIR_Win_free_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(inout) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_free_f08
    END interface PMPI_Win_free
    
    interface PMPI_Win_get_group
        subroutine PMPIR_Win_get_group_f08(win, group, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Group), INTENT(out) :: group
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_get_group_f08
    END interface PMPI_Win_get_group
    
    interface PMPI_Win_get_info
        subroutine PMPIR_Win_get_info_f08(win, info_used, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Info), INTENT(out) :: info_used
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_get_info_f08
    END interface PMPI_Win_get_info
    
    interface PMPI_Win_get_name
        subroutine PMPIR_Win_get_name_f08(win, win_name, resultlen, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_OBJECT_NAME
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            CHARACTER(len=MPI_MAX_OBJECT_NAME), INTENT(out) :: win_name
            INTEGER, INTENT(out) :: resultlen
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_get_name_f08
    END interface PMPI_Win_get_name
    
    interface PMPI_Win_lock
        subroutine PMPIR_Win_lock_f08(lock_type, rank, assert, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            INTEGER, INTENT(in) :: lock_type
            INTEGER, INTENT(in) :: rank
            INTEGER, INTENT(in) :: assert
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_lock_f08
    END interface PMPI_Win_lock
    
    interface PMPI_Win_lock_all
        subroutine PMPIR_Win_lock_all_f08(assert, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            INTEGER, INTENT(in) :: assert
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_lock_all_f08
    END interface PMPI_Win_lock_all
    
    interface PMPI_Win_post
        subroutine PMPIR_Win_post_f08(group, assert, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group, MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: assert
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_post_f08
    END interface PMPI_Win_post
    
    interface PMPI_Win_set_info
        subroutine PMPIR_Win_set_info_f08(win, info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_set_info_f08
    END interface PMPI_Win_set_info
    
    interface PMPI_Win_set_name
        subroutine PMPIR_Win_set_name_f08(win, win_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            CHARACTER(len=*), INTENT(in) :: win_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_set_name_f08
    END interface PMPI_Win_set_name
    
    interface PMPI_Win_shared_query
        subroutine PMPIR_Win_shared_query_f08(win, rank, size, disp_unit, baseptr, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, INTENT(in) :: rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: size
            INTEGER, INTENT(out) :: disp_unit
            TYPE(C_PTR), INTENT(out) :: baseptr
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_shared_query_f08
        
        subroutine PMPIR_Win_shared_query_c_f08(win, rank, size, disp_unit, baseptr, ierror)
            USE, intrinsic :: iso_c_binding, ONLY : C_PTR
            USE :: mpi_f08_types, ONLY : MPI_Win
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, INTENT(in) :: rank
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: size
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: disp_unit
            TYPE(C_PTR), INTENT(out) :: baseptr
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_shared_query_c_f08
    END interface PMPI_Win_shared_query
    
    interface PMPI_Win_start
        subroutine PMPIR_Win_start_f08(group, assert, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Group, MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Group), INTENT(in) :: group
            INTEGER, INTENT(in) :: assert
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_start_f08
    END interface PMPI_Win_start
    
    interface PMPI_Win_sync
        subroutine PMPIR_Win_sync_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_sync_f08
    END interface PMPI_Win_sync
    
    interface PMPI_Win_test
        subroutine PMPIR_Win_test_f08(win, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_test_f08
    END interface PMPI_Win_test
    
    interface PMPI_Win_unlock
        subroutine PMPIR_Win_unlock_f08(rank, win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            INTEGER, INTENT(in) :: rank
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_unlock_f08
    END interface PMPI_Win_unlock
    
    interface PMPI_Win_unlock_all
        subroutine PMPIR_Win_unlock_all_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_unlock_all_f08
    END interface PMPI_Win_unlock_all
    
    interface PMPI_Win_wait
        subroutine PMPIR_Win_wait_f08(win, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Win
            IMPLICIT NONE
            TYPE(MPI_Win), INTENT(in) :: win
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Win_wait_f08
    END interface PMPI_Win_wait
    
    interface PMPI_Close_port
        subroutine PMPIR_Close_port_f08(port_name, ierror)
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: port_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Close_port_f08
    END interface PMPI_Close_port
    
    interface PMPI_Comm_accept
        subroutine PMPIR_Comm_accept_f08(port_name, info, root, comm, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: port_name
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_accept_f08
    END interface PMPI_Comm_accept
    
    interface PMPI_Comm_connect
        subroutine PMPIR_Comm_connect_f08(port_name, info, root, comm, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: port_name
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_connect_f08
    END interface PMPI_Comm_connect
    
    interface PMPI_Comm_disconnect
        subroutine PMPIR_Comm_disconnect_f08(comm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(inout) :: comm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_disconnect_f08
    END interface PMPI_Comm_disconnect
    
    interface PMPI_Comm_get_parent
        subroutine PMPIR_Comm_get_parent_f08(parent, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(out) :: parent
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_get_parent_f08
    END interface PMPI_Comm_get_parent
    
    interface PMPI_Comm_join
        subroutine PMPIR_Comm_join_f08(fd, intercomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            INTEGER, INTENT(in) :: fd
            TYPE(MPI_Comm), INTENT(out) :: intercomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_join_f08
    END interface PMPI_Comm_join
    
    interface PMPI_Comm_spawn
        subroutine PMPIR_Comm_spawn_f08(command, argv, maxprocs, info, root, comm, intercomm, &
                                      array_of_errcodes, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: command
            CHARACTER(len=*), INTENT(in), TARGET :: argv(*)
            INTEGER, INTENT(in) :: maxprocs
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Comm), INTENT(out) :: intercomm
            INTEGER, TARGET :: array_of_errcodes(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_spawn_f08
    END interface PMPI_Comm_spawn
    
    interface PMPI_Comm_spawn_multiple
        subroutine PMPIR_Comm_spawn_multiple_f08(count, array_of_commands, array_of_argv, array_of_maxprocs, &
                                               array_of_info, root, comm, intercomm, array_of_errcodes, &
                                               ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info, MPI_Comm
            IMPLICIT NONE
            INTEGER, INTENT(in) :: count
            CHARACTER(len=*), INTENT(in), TARGET :: array_of_commands(*)
            CHARACTER(len=*), INTENT(in), TARGET :: array_of_argv(count, *)
            INTEGER, INTENT(in) :: array_of_maxprocs(count)
            TYPE(MPI_Info), INTENT(in) :: array_of_info(count)
            INTEGER, INTENT(in) :: root
            TYPE(MPI_Comm), INTENT(in) :: comm
            TYPE(MPI_Comm), INTENT(out) :: intercomm
            INTEGER, TARGET :: array_of_errcodes(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Comm_spawn_multiple_f08
    END interface PMPI_Comm_spawn_multiple
    
    interface PMPI_Lookup_name
        subroutine PMPIR_Lookup_name_f08(service_name, info, port_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_PORT_NAME
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: service_name
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=MPI_MAX_PORT_NAME), INTENT(out) :: port_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Lookup_name_f08
    END interface PMPI_Lookup_name
    
    interface PMPI_Open_port
        subroutine PMPIR_Open_port_f08(info, port_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            USE :: mpi_f08_compile_constants, ONLY : MPI_MAX_PORT_NAME
            IMPLICIT NONE
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=MPI_MAX_PORT_NAME), INTENT(out) :: port_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Open_port_f08
    END interface PMPI_Open_port
    
    interface PMPI_Publish_name
        subroutine PMPIR_Publish_name_f08(service_name, info, port_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: service_name
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=*), INTENT(in) :: port_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Publish_name_f08
    END interface PMPI_Publish_name
    
    interface PMPI_Unpublish_name
        subroutine PMPIR_Unpublish_name_f08(service_name, info, port_name, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: service_name
            TYPE(MPI_Info), INTENT(in) :: info
            CHARACTER(len=*), INTENT(in) :: port_name
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Unpublish_name_f08
    END interface PMPI_Unpublish_name
    
    interface PMPI_Wtick
        function PMPIR_Wtick_f08() result(res)
            IMPLICIT NONE
            DOUBLE PRECISION :: res
        END function PMPIR_Wtick_f08
    END interface PMPI_Wtick
    
    interface PMPI_Wtime
        function PMPIR_Wtime_f08() result(res)
            IMPLICIT NONE
            DOUBLE PRECISION :: res
        END function PMPIR_Wtime_f08
    END interface PMPI_Wtime
    
    interface PMPI_Cart_coords
        subroutine PMPIR_Cart_coords_f08(comm, rank, maxdims, coords, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: rank
            INTEGER, INTENT(in) :: maxdims
            INTEGER, INTENT(out) :: coords(maxdims)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_coords_f08
    END interface PMPI_Cart_coords
    
    interface PMPI_Cart_create
        subroutine PMPIR_Cart_create_f08(comm_old, ndims, dims, periods, reorder, comm_cart, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm_old
            INTEGER, INTENT(in) :: ndims
            INTEGER, INTENT(in) :: dims(ndims)
            LOGICAL, INTENT(in) :: periods(ndims)
            LOGICAL, INTENT(in) :: reorder
            TYPE(MPI_Comm), INTENT(out) :: comm_cart
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_create_f08
    END interface PMPI_Cart_create
    
    interface PMPI_Cart_get
        subroutine PMPIR_Cart_get_f08(comm, maxdims, dims, periods, coords, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: maxdims
            INTEGER, INTENT(out) :: dims(maxdims)
            LOGICAL, INTENT(out) :: periods(maxdims)
            INTEGER, INTENT(out) :: coords(maxdims)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_get_f08
    END interface PMPI_Cart_get
    
    interface PMPI_Cart_map
        subroutine PMPIR_Cart_map_f08(comm, ndims, dims, periods, newrank, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: ndims
            INTEGER, INTENT(in) :: dims(ndims)
            LOGICAL, INTENT(in) :: periods(ndims)
            INTEGER, INTENT(out) :: newrank
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_map_f08
    END interface PMPI_Cart_map
    
    interface PMPI_Cart_rank
        subroutine PMPIR_Cart_rank_f08(comm, coords, rank, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: coords(*)
            INTEGER, INTENT(out) :: rank
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_rank_f08
    END interface PMPI_Cart_rank
    
    interface PMPI_Cart_shift
        subroutine PMPIR_Cart_shift_f08(comm, direction, disp, rank_source, rank_dest, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: direction
            INTEGER, INTENT(in) :: disp
            INTEGER, INTENT(out) :: rank_source
            INTEGER, INTENT(out) :: rank_dest
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_shift_f08
    END interface PMPI_Cart_shift
    
    interface PMPI_Cart_sub
        subroutine PMPIR_Cart_sub_f08(comm, remain_dims, newcomm, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            LOGICAL, INTENT(in) :: remain_dims(*)
            TYPE(MPI_Comm), INTENT(out) :: newcomm
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cart_sub_f08
    END interface PMPI_Cart_sub
    
    interface PMPI_Cartdim_get
        subroutine PMPIR_Cartdim_get_f08(comm, ndims, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: ndims
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Cartdim_get_f08
    END interface PMPI_Cartdim_get
    
    interface PMPI_Dims_create
        subroutine PMPIR_Dims_create_f08(nnodes, ndims, dims, ierror)
            IMPLICIT NONE
            INTEGER, INTENT(in) :: nnodes
            INTEGER, INTENT(in) :: ndims
            INTEGER, INTENT(inout) :: dims(ndims)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Dims_create_f08
    END interface PMPI_Dims_create
    
    interface PMPI_Dist_graph_create
        subroutine PMPIR_Dist_graph_create_f08(comm_old, n, sources, degrees, destinations, weights, info, &
                                             reorder, comm_dist_graph, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm_old
            INTEGER, INTENT(in) :: n
            INTEGER, INTENT(in) :: sources(n)
            INTEGER, INTENT(in) :: degrees(n)
            INTEGER, INTENT(in) :: destinations(*)
            INTEGER, INTENT(in), TARGET :: weights(*)
            TYPE(MPI_Info), INTENT(in) :: info
            LOGICAL, INTENT(in) :: reorder
            TYPE(MPI_Comm), INTENT(out) :: comm_dist_graph
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Dist_graph_create_f08
    END interface PMPI_Dist_graph_create
    
    interface PMPI_Dist_graph_create_adjacent
        subroutine PMPIR_Dist_graph_create_adjacent_f08(comm_old, indegree, sources, sourceweights, outdegree, &
                                                      destinations, destweights, info, reorder, &
                                                      comm_dist_graph, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm_old
            INTEGER, INTENT(in) :: indegree
            INTEGER, INTENT(in) :: sources(indegree)
            INTEGER, INTENT(in), TARGET :: sourceweights(*)
            INTEGER, INTENT(in) :: outdegree
            INTEGER, INTENT(in) :: destinations(outdegree)
            INTEGER, INTENT(in), TARGET :: destweights(*)
            TYPE(MPI_Info), INTENT(in) :: info
            LOGICAL, INTENT(in) :: reorder
            TYPE(MPI_Comm), INTENT(out) :: comm_dist_graph
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Dist_graph_create_adjacent_f08
    END interface PMPI_Dist_graph_create_adjacent
    
    interface PMPI_Dist_graph_neighbors
        subroutine PMPIR_Dist_graph_neighbors_f08(comm, maxindegree, sources, sourceweights, maxoutdegree, &
                                                destinations, destweights, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: maxindegree
            INTEGER, INTENT(out) :: sources(maxindegree)
            INTEGER, TARGET :: sourceweights(*)
            INTEGER, INTENT(in) :: maxoutdegree
            INTEGER, INTENT(out) :: destinations(maxoutdegree)
            INTEGER, TARGET :: destweights(*)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Dist_graph_neighbors_f08
    END interface PMPI_Dist_graph_neighbors
    
    interface PMPI_Dist_graph_neighbors_count
        subroutine PMPIR_Dist_graph_neighbors_count_f08(comm, indegree, outdegree, weighted, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: indegree
            INTEGER, INTENT(out) :: outdegree
            LOGICAL, INTENT(out) :: weighted
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Dist_graph_neighbors_count_f08
    END interface PMPI_Dist_graph_neighbors_count
    
    interface PMPI_Graph_create
        subroutine PMPIR_Graph_create_f08(comm_old, nnodes, indx, edges, reorder, comm_graph, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm_old
            INTEGER, INTENT(in) :: nnodes
            INTEGER, INTENT(in) :: indx(nnodes)
            INTEGER, INTENT(in) :: edges(*)
            LOGICAL, INTENT(in) :: reorder
            TYPE(MPI_Comm), INTENT(out) :: comm_graph
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Graph_create_f08
    END interface PMPI_Graph_create
    
    interface PMPI_Graph_get
        subroutine PMPIR_Graph_get_f08(comm, maxindex, maxedges, indx, edges, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: maxindex
            INTEGER, INTENT(in) :: maxedges
            INTEGER, INTENT(out) :: indx(maxindex)
            INTEGER, INTENT(out) :: edges(maxedges)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Graph_get_f08
    END interface PMPI_Graph_get
    
    interface PMPI_Graph_map
        subroutine PMPIR_Graph_map_f08(comm, nnodes, indx, edges, newrank, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: nnodes
            INTEGER, INTENT(in) :: indx(nnodes)
            INTEGER, INTENT(in) :: edges(*)
            INTEGER, INTENT(out) :: newrank
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Graph_map_f08
    END interface PMPI_Graph_map
    
    interface PMPI_Graph_neighbors
        subroutine PMPIR_Graph_neighbors_f08(comm, rank, maxneighbors, neighbors, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: rank
            INTEGER, INTENT(in) :: maxneighbors
            INTEGER, INTENT(out) :: neighbors(maxneighbors)
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Graph_neighbors_f08
    END interface PMPI_Graph_neighbors
    
    interface PMPI_Graph_neighbors_count
        subroutine PMPIR_Graph_neighbors_count_f08(comm, rank, nneighbors, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(in) :: rank
            INTEGER, INTENT(out) :: nneighbors
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Graph_neighbors_count_f08
    END interface PMPI_Graph_neighbors_count
    
    interface PMPI_Graphdims_get
        subroutine PMPIR_Graphdims_get_f08(comm, nnodes, nedges, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: nnodes
            INTEGER, INTENT(out) :: nedges
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Graphdims_get_f08
    END interface PMPI_Graphdims_get
    
    interface PMPI_Topo_test
        subroutine PMPIR_Topo_test_f08(comm, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            INTEGER, INTENT(out) :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Topo_test_f08
    END interface PMPI_Topo_test
    
    interface PMPI_File_close
        subroutine PMPIR_File_close_f08(fh, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(inout) :: fh
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_close_f08
    END interface PMPI_File_close
    
    interface PMPI_File_delete
        subroutine PMPIR_File_delete_f08(filename, info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Info
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: filename
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_delete_f08
    END interface PMPI_File_delete
    
    interface PMPI_File_get_amode
        subroutine PMPIR_File_get_amode_f08(fh, amode, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER, INTENT(out) :: amode
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_amode_f08
    END interface PMPI_File_get_amode
    
    interface PMPI_File_get_atomicity
        subroutine PMPIR_File_get_atomicity_f08(fh, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            LOGICAL, INTENT(out) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_atomicity_f08
    END interface PMPI_File_get_atomicity
    
    interface PMPI_File_get_byte_offset
        subroutine PMPIR_File_get_byte_offset_f08(fh, offset, disp, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(out) :: disp
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_byte_offset_f08
    END interface PMPI_File_get_byte_offset
    
    interface PMPI_File_get_group
        subroutine PMPIR_File_get_group_f08(fh, group, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Group
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(MPI_Group), INTENT(out) :: group
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_group_f08
    END interface PMPI_File_get_group
    
    interface PMPI_File_get_info
        subroutine PMPIR_File_get_info_f08(fh, info_used, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(MPI_Info), INTENT(out) :: info_used
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_info_f08
    END interface PMPI_File_get_info
    
    interface PMPI_File_get_position
        subroutine PMPIR_File_get_position_f08(fh, offset, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(out) :: offset
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_position_f08
    END interface PMPI_File_get_position
    
    interface PMPI_File_get_position_shared
        subroutine PMPIR_File_get_position_shared_f08(fh, offset, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(out) :: offset
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_position_shared_f08
    END interface PMPI_File_get_position_shared
    
    interface PMPI_File_get_size
        subroutine PMPIR_File_get_size_f08(fh, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(out) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_size_f08
    END interface PMPI_File_get_size
    
    interface PMPI_File_get_type_extent
        subroutine PMPIR_File_get_type_extent_f08(fh, datatype, extent, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(out) :: extent
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_type_extent_f08
    END interface PMPI_File_get_type_extent
    
    interface PMPI_File_get_view
        subroutine PMPIR_File_get_view_f08(fh, disp, etype, filetype, datarep, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(out) :: disp
            TYPE(MPI_Datatype), INTENT(out) :: etype
            TYPE(MPI_Datatype), INTENT(out) :: filetype
            CHARACTER(len=*), INTENT(out) :: datarep
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_get_view_f08
    END interface PMPI_File_get_view
    
    interface PMPI_File_iread
        subroutine PMPIR_File_iread_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_f08ts
        
        subroutine PMPIR_File_iread_c_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_c_f08ts
    END interface PMPI_File_iread
    
    interface PMPI_File_iread_all
        subroutine PMPIR_File_iread_all_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_all_f08ts
        
        subroutine PMPIR_File_iread_all_c_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_all_c_f08ts
    END interface PMPI_File_iread_all
    
    interface PMPI_File_iread_at
        subroutine PMPIR_File_iread_at_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_at_f08ts
        
        subroutine PMPIR_File_iread_at_c_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_at_c_f08ts
    END interface PMPI_File_iread_at
    
    interface PMPI_File_iread_at_all
        subroutine PMPIR_File_iread_at_all_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_at_all_f08ts
        
        subroutine PMPIR_File_iread_at_all_c_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_at_all_c_f08ts
    END interface PMPI_File_iread_at_all
    
    interface PMPI_File_iread_shared
        subroutine PMPIR_File_iread_shared_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_shared_f08ts
        
        subroutine PMPIR_File_iread_shared_c_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iread_shared_c_f08ts
    END interface PMPI_File_iread_shared
    
    interface PMPI_File_iwrite
        subroutine PMPIR_File_iwrite_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_f08ts
        
        subroutine PMPIR_File_iwrite_c_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_c_f08ts
    END interface PMPI_File_iwrite
    
    interface PMPI_File_iwrite_all
        subroutine PMPIR_File_iwrite_all_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_all_f08ts
        
        subroutine PMPIR_File_iwrite_all_c_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_all_c_f08ts
    END interface PMPI_File_iwrite_all
    
    interface PMPI_File_iwrite_at
        subroutine PMPIR_File_iwrite_at_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_at_f08ts
        
        subroutine PMPIR_File_iwrite_at_c_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_at_c_f08ts
    END interface PMPI_File_iwrite_at
    
    interface PMPI_File_iwrite_at_all
        subroutine PMPIR_File_iwrite_at_all_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_at_all_f08ts
        
        subroutine PMPIR_File_iwrite_at_all_c_f08ts(fh, offset, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_at_all_c_f08ts
    END interface PMPI_File_iwrite_at_all
    
    interface PMPI_File_iwrite_shared
        subroutine PMPIR_File_iwrite_shared_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_shared_f08ts
        
        subroutine PMPIR_File_iwrite_shared_c_f08ts(fh, buf, count, datatype, request, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Request
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Request), INTENT(out) :: request
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_iwrite_shared_c_f08ts
    END interface PMPI_File_iwrite_shared
    
    interface PMPI_File_open
        subroutine PMPIR_File_open_f08(comm, filename, amode, info, fh, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Comm, MPI_Info, MPI_File
            IMPLICIT NONE
            TYPE(MPI_Comm), INTENT(in) :: comm
            CHARACTER(len=*), INTENT(in) :: filename
            INTEGER, INTENT(in) :: amode
            TYPE(MPI_Info), INTENT(in) :: info
            TYPE(MPI_File), INTENT(out) :: fh
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_open_f08
    END interface PMPI_File_open
    
    interface PMPI_File_preallocate
        subroutine PMPIR_File_preallocate_f08(fh, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_preallocate_f08
    END interface PMPI_File_preallocate
    
    interface PMPI_File_read
        subroutine PMPIR_File_read_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_f08ts
        
        subroutine PMPIR_File_read_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_c_f08ts
    END interface PMPI_File_read
    
    interface PMPI_File_read_all
        subroutine PMPIR_File_read_all_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_all_f08ts
        
        subroutine PMPIR_File_read_all_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_all_c_f08ts
    END interface PMPI_File_read_all
    
    interface PMPI_File_read_all_begin
        subroutine PMPIR_File_read_all_begin_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_all_begin_f08ts
        
        subroutine PMPIR_File_read_all_begin_c_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_all_begin_c_f08ts
    END interface PMPI_File_read_all_begin
    
    interface PMPI_File_read_all_end
        subroutine PMPIR_File_read_all_end_f08ts(fh, buf, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_all_end_f08ts
    END interface PMPI_File_read_all_end
    
    interface PMPI_File_read_at
        subroutine PMPIR_File_read_at_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_f08ts
        
        subroutine PMPIR_File_read_at_c_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_c_f08ts
    END interface PMPI_File_read_at
    
    interface PMPI_File_read_at_all
        subroutine PMPIR_File_read_at_all_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_all_f08ts
        
        subroutine PMPIR_File_read_at_all_c_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_all_c_f08ts
    END interface PMPI_File_read_at_all
    
    interface PMPI_File_read_at_all_begin
        subroutine PMPIR_File_read_at_all_begin_f08ts(fh, offset, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_all_begin_f08ts
        
        subroutine PMPIR_File_read_at_all_begin_c_f08ts(fh, offset, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_all_begin_c_f08ts
    END interface PMPI_File_read_at_all_begin
    
    interface PMPI_File_read_at_all_end
        subroutine PMPIR_File_read_at_all_end_f08ts(fh, buf, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_at_all_end_f08ts
    END interface PMPI_File_read_at_all_end
    
    interface PMPI_File_read_ordered
        subroutine PMPIR_File_read_ordered_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_ordered_f08ts
        
        subroutine PMPIR_File_read_ordered_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_ordered_c_f08ts
    END interface PMPI_File_read_ordered
    
    interface PMPI_File_read_ordered_begin
        subroutine PMPIR_File_read_ordered_begin_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_ordered_begin_f08ts
        
        subroutine PMPIR_File_read_ordered_begin_c_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_ordered_begin_c_f08ts
    END interface PMPI_File_read_ordered_begin
    
    interface PMPI_File_read_ordered_end
        subroutine PMPIR_File_read_ordered_end_f08ts(fh, buf, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), ASYNCHRONOUS :: buf
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_ordered_end_f08ts
    END interface PMPI_File_read_ordered_end
    
    interface PMPI_File_read_shared
        subroutine PMPIR_File_read_shared_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_shared_f08ts
        
        subroutine PMPIR_File_read_shared_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_read_shared_c_f08ts
    END interface PMPI_File_read_shared
    
    interface PMPI_File_seek
        subroutine PMPIR_File_seek_f08(fh, offset, whence, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            INTEGER, INTENT(in) :: whence
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_seek_f08
    END interface PMPI_File_seek
    
    interface PMPI_File_seek_shared
        subroutine PMPIR_File_seek_shared_f08(fh, offset, whence, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            INTEGER, INTENT(in) :: whence
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_seek_shared_f08
    END interface PMPI_File_seek_shared
    
    interface PMPI_File_set_atomicity
        subroutine PMPIR_File_set_atomicity_f08(fh, flag, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            LOGICAL, INTENT(in) :: flag
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_set_atomicity_f08
    END interface PMPI_File_set_atomicity
    
    interface PMPI_File_set_info
        subroutine PMPIR_File_set_info_f08(fh, info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Info
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_set_info_f08
    END interface PMPI_File_set_info
    
    interface PMPI_File_set_size
        subroutine PMPIR_File_set_size_f08(fh, size, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: size
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_set_size_f08
    END interface PMPI_File_set_size
    
    interface PMPI_File_set_view
        subroutine PMPIR_File_set_view_f08(fh, disp, etype, filetype, datarep, info, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Info
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: disp
            TYPE(MPI_Datatype), INTENT(in) :: etype
            TYPE(MPI_Datatype), INTENT(in) :: filetype
            CHARACTER(len=*), INTENT(in) :: datarep
            TYPE(MPI_Info), INTENT(in) :: info
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_set_view_f08
    END interface PMPI_File_set_view
    
    interface PMPI_File_sync
        subroutine PMPIR_File_sync_f08(fh, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_sync_f08
    END interface PMPI_File_sync
    
    interface PMPI_File_write
        subroutine PMPIR_File_write_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_f08ts
        
        subroutine PMPIR_File_write_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_c_f08ts
    END interface PMPI_File_write
    
    interface PMPI_File_write_all
        subroutine PMPIR_File_write_all_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_all_f08ts
        
        subroutine PMPIR_File_write_all_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_all_c_f08ts
    END interface PMPI_File_write_all
    
    interface PMPI_File_write_all_begin
        subroutine PMPIR_File_write_all_begin_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_all_begin_f08ts
        
        subroutine PMPIR_File_write_all_begin_c_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_all_begin_c_f08ts
    END interface PMPI_File_write_all_begin
    
    interface PMPI_File_write_all_end
        subroutine PMPIR_File_write_all_end_f08ts(fh, buf, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_all_end_f08ts
    END interface PMPI_File_write_all_end
    
    interface PMPI_File_write_at
        subroutine PMPIR_File_write_at_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_f08ts
        
        subroutine PMPIR_File_write_at_c_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_c_f08ts
    END interface PMPI_File_write_at
    
    interface PMPI_File_write_at_all
        subroutine PMPIR_File_write_at_all_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_all_f08ts
        
        subroutine PMPIR_File_write_at_all_c_f08ts(fh, offset, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_all_c_f08ts
    END interface PMPI_File_write_at_all
    
    interface PMPI_File_write_at_all_begin
        subroutine PMPIR_File_write_at_all_begin_f08ts(fh, offset, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_all_begin_f08ts
        
        subroutine PMPIR_File_write_at_all_begin_c_f08ts(fh, offset, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_OFFSET_KIND, MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            INTEGER(KIND=MPI_OFFSET_KIND), INTENT(in) :: offset
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_all_begin_c_f08ts
    END interface PMPI_File_write_at_all_begin
    
    interface PMPI_File_write_at_all_end
        subroutine PMPIR_File_write_at_all_end_f08ts(fh, buf, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_at_all_end_f08ts
    END interface PMPI_File_write_at_all_end
    
    interface PMPI_File_write_ordered
        subroutine PMPIR_File_write_ordered_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_ordered_f08ts
        
        subroutine PMPIR_File_write_ordered_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_ordered_c_f08ts
    END interface PMPI_File_write_ordered
    
    interface PMPI_File_write_ordered_begin
        subroutine PMPIR_File_write_ordered_begin_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_ordered_begin_f08ts
        
        subroutine PMPIR_File_write_ordered_begin_c_f08ts(fh, buf, count, datatype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_ordered_begin_c_f08ts
    END interface PMPI_File_write_ordered_begin
    
    interface PMPI_File_write_ordered_end
        subroutine PMPIR_File_write_ordered_end_f08ts(fh, buf, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in), ASYNCHRONOUS :: buf
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_ordered_end_f08ts
    END interface PMPI_File_write_ordered_end
    
    interface PMPI_File_write_shared
        subroutine PMPIR_File_write_shared_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER, INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_shared_f08ts
        
        subroutine PMPIR_File_write_shared_c_f08ts(fh, buf, count, datatype, status, ierror)
            USE :: mpi_f08_types, ONLY : MPI_File, MPI_Datatype, MPI_Status
            USE :: mpi_f08_compile_constants, ONLY : MPI_COUNT_KIND
            IMPLICIT NONE
            TYPE(MPI_File), INTENT(in) :: fh
            TYPE(*), DIMENSION(..), INTENT(in) :: buf
            INTEGER(KIND=MPI_COUNT_KIND), INTENT(in) :: count
            TYPE(MPI_Datatype), INTENT(in) :: datatype
            TYPE(MPI_Status), INTENT(out), TARGET :: status
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_File_write_shared_c_f08ts
    END interface PMPI_File_write_shared
    
    interface PMPI_Register_datarep
        subroutine PMPIR_Register_datarep_f08(datarep, read_conversion_fn, write_conversion_fn, &
                                            dtype_file_extent_fn, extra_state, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            USE :: mpi_f08_callbacks, ONLY : MPI_Datarep_conversion_function, MPI_Datarep_extent_function
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            PROCEDURE(MPI_Datarep_conversion_function) :: read_conversion_fn
            PROCEDURE(MPI_Datarep_conversion_function) :: write_conversion_fn
            PROCEDURE(MPI_Datarep_extent_function) :: dtype_file_extent_fn
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extra_state
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Register_datarep_f08
    END interface PMPI_Register_datarep
    
    interface PMPI_Register_datarep_c
        subroutine PMPIR_Register_datarep_c_f08(datarep, read_conversion_fn, write_conversion_fn, &
                                              dtype_file_extent_fn, extra_state, ierror)
            USE :: mpi_f08_compile_constants, ONLY : MPI_ADDRESS_KIND
            USE :: mpi_f08_callbacks, ONLY : MPI_Datarep_conversion_function_c, MPI_Datarep_extent_function
            IMPLICIT NONE
            CHARACTER(len=*), INTENT(in) :: datarep
            PROCEDURE(MPI_Datarep_conversion_function_c) :: read_conversion_fn
            PROCEDURE(MPI_Datarep_conversion_function_c) :: write_conversion_fn
            PROCEDURE(MPI_Datarep_extent_function) :: dtype_file_extent_fn
            INTEGER(KIND=MPI_ADDRESS_KIND), INTENT(in) :: extra_state
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Register_datarep_c_f08
    END interface PMPI_Register_datarep_c
    
    interface PMPI_Type_create_f90_integer
        subroutine PMPIR_Type_create_f90_integer_f08(r, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: r
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_f90_integer_f08
    END interface PMPI_Type_create_f90_integer
    
    interface PMPI_Type_create_f90_real
        subroutine PMPIR_Type_create_f90_real_f08(p, r, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: p
            INTEGER, INTENT(in) :: r
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_f90_real_f08
    END interface PMPI_Type_create_f90_real
    
    interface PMPI_Type_create_f90_complex
        subroutine PMPIR_Type_create_f90_complex_f08(p, r, newtype, ierror)
            USE :: mpi_f08_types, ONLY : MPI_Datatype
            IMPLICIT NONE
            INTEGER, INTENT(in) :: p
            INTEGER, INTENT(in) :: r
            TYPE(MPI_Datatype), INTENT(out) :: newtype
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_Type_create_f90_complex_f08
    END interface PMPI_Type_create_f90_complex
    
    interface PMPI_F_sync_reg
        subroutine PMPIR_F_sync_reg_f08ts(buf, ierror)
            IMPLICIT NONE
            TYPE(*), DIMENSION(..), INTENT(inout), ASYNCHRONOUS :: buf
            INTEGER, OPTIONAL, INTENT(out) :: ierror
        END subroutine PMPIR_F_sync_reg_f08ts
    END interface PMPI_F_sync_reg
    
END module pmpi_f08
