!
! Copyright Intel Corporation.
! 
! This software and the related documents are Intel copyrighted materials, and
! your use of them is governed by the express license under which they were
! provided to you (License). Unless the License provides otherwise, you may
! not use, modify, copy, publish, distribute, disclose or transmit this
! software or the related documents without Intel's prior written permission.
! 
! This software and the related documents are provided as is, with no express
! or implied warranties, other than those that are expressly stated in the
! License.
!
! Copyright (C) by Argonne National Laboratory
! 
! 				  COPYRIGHT
! 
! The following is a notice of limited availability of the code, and disclaimer
! which must be included in the prologue of the code and in all source listings
! of the code.
! 
! Copyright Notice
! 1998--2020, Argonne National Laboratory
! 
! Permission is hereby granted to use, reproduce, prepare derivative works, and
! to redistribute to others.  This software was authored by:
! 
! Mathematics and Computer Science Division
! Argonne National Laboratory, Argonne IL 60439
! 
! (and)
! 
! Department of Computer Science
! University of Illinois at Urbana-Champaign
! 
! 
! 			      GOVERNMENT LICENSE
! 
! Portions of this material resulted from work developed under a U.S.
! Government Contract and are subject to the following license: the Government
! is granted for itself and others acting on its behalf a paid-up, nonexclusive,
! irrevocable worldwide license in this computer software to reproduce, prepare
! derivative works, and perform publicly and display publicly.
! 
! 				  DISCLAIMER
! 
! This computer code material was prepared, in part, as an account of work
! sponsored by an agency of the United States Government.  Neither the United
! States, nor the University of Chicago, nor any of their employees, makes any
! warranty express or implied, or assumes any legal liability or responsibility
! for the accuracy, completeness, or usefulness of any information, apparatus,
! product, or process disclosed, or represents that its use would not infringe
! privately owned rights.
! 
! 			   EXTERNAL CONTRIBUTIONS
! 
! Portions of this code have been contributed under the above license by:
! 
!  * Intel Corporation
!  * Cray
!  * IBM Corporation
!  * Microsoft Corporation
!  * Mellanox Technologies Ltd.
!  * DataDirect Networks.
!  * Oak Ridge National Laboratory
!  * Sun Microsystems, Lustre group
!  * Dolphin Interconnect Solutions Inc.
!  * Institut Polytechnique de Bordeaux
!
!     
!
! Module mpi_c_interface_types is a helper module used by the modules
! specifying c interfaces:
!
! mpi_c_interface_cdesc - interfaces for MPI functions with a descriptor argument
! mpi_c_interface_nobuf - interfaces for MPI functions with no choice argument
!
! MPICH C interface uses integer for handles and status type.
! It is not defined in the spec and not intended for end users.
!--------------------------------------------------------------

module mpi_c_interface_types

use, intrinsic :: iso_c_binding

implicit none

integer,parameter :: c_Fint       = KIND(0)

integer,parameter :: c_Aint       = c_long
integer,parameter :: c_Count      = c_long_long
integer,parameter :: c_Offset     = c_long_long

!=============================================================
! Kinds for handle types in C prototypes; should match  mpi.h
!=============================================================

integer,parameter :: c_Datatype   = c_int
integer,parameter :: c_Comm       = c_int
integer,parameter :: c_Group      = c_int
integer,parameter :: c_Win        = c_int
integer,parameter :: c_Op         = c_int
integer,parameter :: c_Info       = c_int
integer,parameter :: c_Errhandler = c_int
integer,parameter :: c_Request    = c_int
integer,parameter :: c_Message    = c_int
integer,parameter :: c_File       = c_intptr_t
integer,parameter :: c_Session    = c_int

!================================================
! C struct for STATUS values; should match  mpi.h
!================================================

! MPI_Status, with name changed to c_Status for internal disambiguation
! A.1.2 p 676

type, bind(c) :: c_Status
   integer(c_int)  :: count_lo
   integer(c_int)  :: count_hi_and_cancelled
   integer(c_int)  :: MPI_SOURCE
   integer(c_int)  :: MPI_TAG
   integer(c_int)  :: MPI_ERROR
end type c_Status

end module mpi_c_interface_types
