<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                xmlns:fnc="urn:functions"
                syntax="norules">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="useEventBasedCounts">false</xsl:param>
  <xsl:param name="isHotspots">false</xsl:param>
  <xsl:template match="/">
    <xsl:variable name="pmuConditions" select="document('config://include/pmu_variables.xsl')"/>
    <xsl:variable name="isEcoreServerPMU" select="$pmuConditions//variables/isEcoreServerPMU"/>
    <xsl:variable name="NoSMTOnPcore" select="$pmuConditions//variables/NoSMTOnPcore"/>
    <xsl:variable name="isPerfmetricsSupported" select="$pmuConditions//variables/isPerfmetricsSupported"/>
    <xsl:variable name="isHybridPMU" select="$pmuConditions//variables/isHybridPMU"/>
    <xsl:variable name="isAMXSupported" select="$pmuConditions//variables/isAMXSupported"/>
    <xsl:variable name="isPcoreFlopsAvailable" select="$pmuConditions//variables/isPcoreFlopsAvailable"/>
    <xsl:variable name="isEcoreFlopsAvailable" select="$pmuConditions//variables/isEcoreFlopsAvailable"/>
    <xsl:variable name="isNewArithEventsAvailable" select="$pmuConditions//variables/isNewArithEventsAvailable"/>
    <xsl:variable name="isAVX512Supported" select="$pmuConditions//variables/isAVX512Supported"/>
    <xsl:variable name="is4thGenPcoreXeonOrLater" select="$pmuConditions//variables/is4thGenPcoreXeonOrLater"/>
    <xsl:variable name="isFixedTopdownUnsupported" select="$pmuConditions//variables/isFixedTopdownUnsupported"/>
    <xsl:variable name="isHyperVPinWA" select="$pmuConditions//variables/isHyperVPinWA"/>
    <xsl:variable name="pmuConditionsExtended" select="document('config://include/pmu_variables_extended.xsl')"/>
    <xsl:variable name="isExtendedIsaSupport" select="$pmuConditionsExtended//variables/isExtendedIsaSupport"/>
    <xsl:variable name="SAVDEFAULT">
      <xsl:text>:sa=</xsl:text>
      <xsl:value-of select="format-number(round(exsl:ctx('referenceFrequency', 1000000000) * (1.0 div 1000)), '#')"/>
    </xsl:variable>
    <xsl:variable name="SAV2MDEFAULT"><xsl:text>:sa=2000003</xsl:text></xsl:variable>
    <xsl:variable name="SAV1MDEFAULT"><xsl:text>:sa=1000003</xsl:text></xsl:variable>
    <xsl:variable name="SAV200KDEFAULT"><xsl:text>:sa=200003</xsl:text></xsl:variable>
    <xsl:variable name="SAV100KDEFAULT"><xsl:text>:sa=100003</xsl:text></xsl:variable>
    <xsl:variable name="SAV50KDEFAULT"><xsl:text>:sa=50003</xsl:text></xsl:variable>
    <xsl:variable name="SAV10KDEFAULT"><xsl:text>:sa=10003</xsl:text></xsl:variable>
    <xsl:variable name="SAV">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAVDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="SAV2M">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAV2MDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="SAV1M">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAV1MDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="SAV200K">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAV200KDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="SAV100K">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAV100KDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="SAV50K">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAV50KDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="SAV10K">
      <xsl:if test="$useEventBasedCounts='false'"><xsl:value-of select="$SAV10KDEFAULT"/></xsl:if>
    </xsl:variable>
    <xsl:variable name="pmuCommon" select="document('config://include/pmu_common.xsl')"/>
    <xsl:variable name="perfMetricsPossible" select="$pmuCommon//variables/perfMetricsPossible"/>
    <xsl:variable name="usePerfMetrics" select="$perfMetricsPossible = 'true' and not(exsl:ctx('enableStackCollect', 0))"/>
    <xsl:variable name="tmamEventsFile">
      <xsl:choose>
        <xsl:when test="$usePerfMetrics">
          <xsl:value-of select="$pmuCommon//variables/tmamEventsFilePM"></xsl:value-of>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$pmuCommon//variables/tmamEventsFile"></xsl:value-of>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <events>
      <cpi>
        <xsl:choose>
          <xsl:when test="(exsl:ctx('PMU') = 'snowridge')">
            <xsl:value-of select="concat('CPU_CLK_UNHALTED.CORE',$SAV)"/>
            <xsl:value-of select="concat(',CPU_CLK_UNHALTED.REF_TSC:sample',$SAVDEFAULT)"/>
            <xsl:value-of select="concat(',INST_RETIRED.ANY:sample',$SAVDEFAULT)"/>
          </xsl:when>
          <xsl:when test="$isExtendedIsaSupport='true'">
            <xsl:variable name="extendedCPI" select="$pmuConditionsExtended//variables/extendedCPI"/>
            <xsl:value-of select="$extendedCPI"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="exsl:ctx('PerfmonVersion', '4') = '1'">
                <xsl:value-of select="concat(
                              'CPU_CLK_UNHALTED.THREAD_P_ANY',$SAV,
                              ',INST_RETIRED.ANY_P:sample',$SAVDEFAULT)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat('CPU_CLK_UNHALTED.THREAD',$SAV)"/>
                <xsl:value-of select="concat(',CPU_CLK_UNHALTED.REF_TSC:sample',$SAVDEFAULT)"/>
                <xsl:choose>
                  <xsl:when test="($isHyperVPinWA = 'true') and ($isHotspots = 'true')">
                    <xsl:value-of select="concat(',INST_RETIRED.ANY_P:sample',$SAVDEFAULT)"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat(',INST_RETIRED.ANY:sample',$SAVDEFAULT)"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:choose>
                  <xsl:when test="$isEcoreServerPMU = 'true' or $NoSMTOnPcore = 'true' or exsl:ctx('PMU') = 'alderlake_gracemont'">
                    <xsl:text></xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="concat(',CPU_CLK_UNHALTED.DISTRIBUTED',$SAV)"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
      </cpi>
      <memboundHPC>
        <xsl:choose>
          <xsl:when test="$isPerfmetricsSupported = 'true'">
            <xsl:variable name="hpcBaseEvents">
              <xsl:value-of select="document($tmamEventsFile)/main/HPC_Tree/BaseEvents"/>
            </xsl:variable>
            <xsl:variable name="hpcHypervisorEvents">
              <xsl:value-of select="document($tmamEventsFile)/main/HPC_Tree/HypervisorEvents"/>
            </xsl:variable>
            <xsl:choose>
              <xsl:when test="exsl:ctx('Hypervisor', 'None') = 'None' or (exsl:ctx('Hypervisor', 'None') = 'Microsoft Hv' and exsl:ctx('HypervisorType', 'None') = 'Hyper-V') or exsl:ctx('Hypervisor', 'None') = 'KVMKVMKVM'">
                <xsl:value-of select="concat($hpcBaseEvents,$hpcHypervisorEvents)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$hpcBaseEvents"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="concat(',MEM_INST_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_INST_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:if test="exsl:ctx('PMU') = 'icelake_server'">
              <xsl:if test="exsl:ctx('Hypervisor', 'None') = 'None' or (exsl:ctx('Hypervisor', 'None') = 'Microsoft Hv' and exsl:ctx('HypervisorType', 'None') = 'Hyper-V') or exsl:ctx('Hypervisor', 'None') = 'KVMKVMKVM'">
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.LOCAL_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.REMOTE_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.LOCAL_PMM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.REMOTE_PMM',$SAV100K)"/>
              </xsl:if>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </memboundHPC>
      <memAccess>
        <xsl:choose>
          <xsl:when test="exsl:ctx('PMU') = 'icelake' or exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'tigerlake' or $is4thGenPcoreXeonOrLater = 'true'">
            <xsl:value-of select="concat('MEM_INST_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_INST_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_TRANS_RETIRED.LOAD_LATENCY_GT_4',$SAV10K)"/>
            <xsl:if test="exsl:ctx('PMU') = 'icelake_server' or exsl:ctx('PMU') = 'sapphirerapids_server' or exsl:ctx('PMU') = 'emeraldrapids_server'">
              <xsl:if test="exsl:ctx('Hypervisor', 'None') = 'None' or (exsl:ctx('Hypervisor', 'None') = 'Microsoft Hv' and exsl:ctx('HypervisorType', 'None') = 'Hyper-V') or exsl:ctx('Hypervisor', 'None') = 'KVMKVMKVM'">
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.LOCAL_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.REMOTE_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.LOCAL_PMM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.REMOTE_PMM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.SNC_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.READS_TO_CORE.SNC_PMM',$SAV100K)"/>
                <xsl:value-of select="concat(',OCR.WRITE_ESTIMATE.MEMORY',$SAV100K)"/>
              </xsl:if>
            </xsl:if>
          </xsl:when>
          <xsl:when test="$isEcoreServerPMU = 'true'">
            <xsl:value-of select="concat('MEM_UOPS_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:choose>
              <xsl:when test="exsl:ctx('PMU') = 'snowridge'">
                <xsl:value-of select="concat(',MEM_LOAD_UOPS_RETIRED.DRAM_HIT',$SAV100K)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(',MEM_LOAD_UOPS_L3_MISS_RETIRED.LOCAL_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',MEM_UOPS_RETIRED.LOAD_LATENCY_GT_4',$SAV50K)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="$isHybridPMU = 'true'">
            <xsl:value-of select="concat('MEM_INST_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_INST_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_TRANS_RETIRED.LOAD_LATENCY_GT_4',$SAV10K)"/>
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.LOAD_LATENCY_GT_4',$SAV50K)"/>
            <xsl:choose>
              <xsl:when test="exsl:ctx('PMU') = 'alderlake'">
                <xsl:value-of select="concat(',MEM_LOAD_UOPS_RETIRED.DRAM_HIT',$SAV100K)"/>
              </xsl:when>
              <xsl:when test="exsl:ctx('PMU') = 'meteorlake'">
                <xsl:value-of select="concat(',MEM_LOAD_UOPS_MISC_RETIRED.LOCAL_DRAM',$SAV100K)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat(',MEM_LOAD_UOPS_MISC_RETIRED.LOCAL_DRAM',$SAV100K)"/>
                <xsl:value-of select="concat(',MEM_LOAD_UOPS_L3_MISS_RETIRED.LOCAL_DRAM',$SAV100K)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'alderlake_goldencove' or exsl:ctx('PMU') = 'pantherlake_cougarcove'">
            <xsl:value-of select="concat('MEM_INST_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_INST_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_TRANS_RETIRED.LOAD_LATENCY_GT_4',$SAV10K)"/>
          </xsl:when>
          <xsl:when test="exsl:ctx('PMU') = 'alderlake_gracemont'">
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.ALL_LOADS',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.ALL_STORES',$SAV100K)"/>
            <xsl:value-of select="concat(',MEM_UOPS_RETIRED.LOAD_LATENCY_GT_4',$SAV50K)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </memAccess>
      <fpu>
        <xsl:choose>
          <xsl:when test="$isEcoreFlopsAvailable = 'true'">
            <xsl:value-of select="concat('FP_FLOPS_RETIRED.ALL',$SAV2M)"/>
            <xsl:value-of select="concat(',FP_INST_RETIRED.32B_SP',$SAV2M)"/>
            <xsl:value-of select="concat(',FP_INST_RETIRED.64B_DP',$SAV2M)"/>
            <xsl:value-of select="concat(',FP_INST_RETIRED.128B_SP',$SAV2M)"/>
            <xsl:value-of select="concat(',FP_INST_RETIRED.128B_DP',$SAV2M)"/>
          </xsl:when>
          <xsl:when test="$isPcoreFlopsAvailable = 'true'">
            <xsl:choose>
              <xsl:when test="$isNewArithEventsAvailable = 'true'">
                <xsl:value-of select="concat('FP_ARITH_OPS_RETIRED.SCALAR_SINGLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_OPS_RETIRED.128B_PACKED_SINGLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_OPS_RETIRED.256B_PACKED_SINGLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_OPS_RETIRED.SCALAR_DOUBLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_OPS_RETIRED.128B_PACKED_DOUBLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_OPS_RETIRED.256B_PACKED_DOUBLE',$SAV2M)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="concat('FP_ARITH_INST_RETIRED.SCALAR_SINGLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.128B_PACKED_SINGLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.256B_PACKED_SINGLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.SCALAR_DOUBLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.128B_PACKED_DOUBLE',$SAV2M)"/>
                <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.256B_PACKED_DOUBLE',$SAV2M)"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="concat(',UOPS_EXECUTED.X87',$SAV2M)"/>
            <xsl:value-of select="concat(',UOPS_RETIRED.SLOTS',$SAV2M)"/>
            <xsl:value-of select="concat(',UOPS_EXECUTED.THREAD',$SAV2M)"/>
            <xsl:if test="$isAVX512Supported = 'true'">
              <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.512B_PACKED_DOUBLE',$SAV2M)"/>
              <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED.512B_PACKED_SINGLE',$SAV2M)"/>
            </xsl:if>
            <xsl:if test="$isAMXSupported = 'true'">
              <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED2.SCALAR_HALF',$SAV2M)"/>
              <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED2.128B_PACKED_HALF',$SAV2M)"/>
              <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED2.256B_PACKED_HALF',$SAV2M)"/>
              <xsl:value-of select="concat(',FP_ARITH_INST_RETIRED2.512B_PACKED_HALF',$SAV2M)"/>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text></xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </fpu>
      <retired>
        <xsl:choose>
          <xsl:when test="$isEcoreServerPMU = 'true' or exsl:ctx('PMU') = 'alderlake_gracemont'">
            <xsl:value-of select="concat(',TOPDOWN_RETIRING.ALL:sample',$SAV2MDEFAULT)"/>
          </xsl:when>
          <xsl:when test="$isPerfmetricsSupported = 'true'">
            <xsl:value-of select="concat(',TOPDOWN.SLOTS:sample',$SAV2MDEFAULT)"/>
            <xsl:value-of select="concat(',UOPS_RETIRED.SLOTS:sample',$SAV2MDEFAULT)"/>
            <xsl:if test="$isFixedTopdownUnsupported = 'true'">
              <xsl:value-of select="concat(',TOPDOWN.SLOTS_P:sample',$SAV2MDEFAULT)"/>
              <xsl:value-of select="concat(',TOPDOWN_RETIRING.ALL_P:sample',$SAV2MDEFAULT)"/>
            </xsl:if>
            <xsl:if test="not(exsl:ctx('usePerfMetrics', 0)) or
                          (exsl:ctx('Hypervisor', 'None') = 'Microsoft Hv' and
                           exsl:ctx('HypervisorType', 'None') = 'Hyper-V') or
                          exsl:ctx('Hypervisor', 'None') = 'KVMKVMKVM'">
              <xsl:value-of select="concat(',TOPDOWN.SLOTS_P:sample',$SAV2MDEFAULT)"/>
              <xsl:if test="$isHybridPMU = 'true'">
                <xsl:value-of select="concat(',TOPDOWN_RETIRING.ALL_P:sample',$SAV2MDEFAULT)"/>
              </xsl:if>
              <xsl:if test="exsl:ctx('PMU') = 'alderlake'">
                <xsl:value-of select="concat(',TOPDOWN_RETIRING.ALL:sample',$SAV2MDEFAULT)"/>
              </xsl:if>
            </xsl:if>
          </xsl:when>
          <xsl:when test="$isExtendedIsaSupport='true'">
            <xsl:variable name="extendedRetired" select="$pmuConditionsExtended//variables/extendedRetired"/>
            <xsl:value-of select="$extendedRetired"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="concat('UOPS_RETIRED.RETIRE_SLOTS:sample',$SAV2MDEFAULT)"/>
          </xsl:otherwise>
        </xsl:choose>
      </retired>
      <retired_perf_metrics>
        <xsl:choose>
          <xsl:when test="$isPerfmetricsSupported = 'true'">
            <xsl:value-of select="concat('TOPDOWN.SLOTS:perf_metrics:sample',$SAV2MDEFAULT)"/>
            <xsl:if test="$isHybridPMU = 'true'">
              <xsl:value-of select="concat(',TOPDOWN_RETIRING.ALL:sample',$SAV2MDEFAULT)"/>
              <xsl:if test="contains(exsl:ctx('availablePmuTypes', 'NotAvailable'), 'lpe-core')">
                <xsl:value-of select="concat(',TOPDOWN_RETIRING.ALL_P:sample',$SAV2MDEFAULT)"/>
              </xsl:if>
            </xsl:if>
          </xsl:when>
        </xsl:choose>
      </retired_perf_metrics>
      <pgo>
        <xsl:value-of select="concat('BR_INST_RETIRED.NEAR_TAKEN',$SAV200K, 'usr=yes:os=no')"/>
      </pgo>
    </events>
  </xsl:template>
</xsl:stylesheet>
