/*
    Copyright Intel Corporation.
    
    This software and the related documents are Intel copyrighted materials, and
    your use of them is governed by the express license under which they were
    provided to you (License). Unless the License provides otherwise, you may
    not use, modify, copy, publish, distribute, disclose or transmit this
    software or the related documents without Intel's prior written permission.
    
    This software and the related documents are provided as is, with no express
    or implied warranties, other than those that are expressly stated in the
    License.
*/
#include "mpi.h"
#include <iostream>

int main(int argc, char *argv[])
{
    int i, rank, size, namelen;
    char name[MPI_MAX_PROCESSOR_NAME];
    MPI::Status stat;

    MPI::Init(argc, argv);

    size = MPI::COMM_WORLD.Get_size();
    rank = MPI::COMM_WORLD.Get_rank();
    MPI::Get_processor_name(name, namelen);

    if (rank == 0) {
        std::cout << "Hello world: rank " << rank << " of " << size << " running on " << name <<
            "\n";

        for (i = 1; i < size; i++) {
            MPI::COMM_WORLD.Recv(&rank, 1, MPI_INT, i, 1, stat);
            MPI::COMM_WORLD.Recv(&size, 1, MPI_INT, i, 1, stat);
            MPI::COMM_WORLD.Recv(&namelen, 1, MPI_INT, i, 1, stat);
            MPI::COMM_WORLD.Recv(name, namelen + 1, MPI_CHAR, i, 1, stat);
            std::cout << "Hello world: rank " << rank << " of " << size << " running on " << name <<
                "\n";
        }
    } else {
        MPI::COMM_WORLD.Send(&rank, 1, MPI_INT, 0, 1);
        MPI::COMM_WORLD.Send(&size, 1, MPI_INT, 0, 1);
        MPI::COMM_WORLD.Send(&namelen, 1, MPI_INT, 0, 1);
        MPI::COMM_WORLD.Send(name, namelen + 1, MPI_CHAR, 0, 1);
    }

    MPI::Finalize();
    return (0);
}
