#
# Copyright (C) 2020 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain the contents of the performance projection
# data set.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project.
project = advisor.open_project(sys.argv[1])
# Load data. You can also use the type `advisor.PERFORMANCE_PROJECTION` to load performance projection data.
data = project.load(advisor.ALL)

print("=" * 60)
print("Performance Projection Dataset:")
print("=" * 60)

# Iterate over the performance projection data and print the results.
for top_row in data.perf_projection:
    stack = [top_row]
    while stack:
        row = stack.pop()
        for c in row.children:
            stack.append(c)

        print("=" * 60)
        print("Performance Projection Row:")

        # Iterate over the dictionary that stores values for a row.
        for key in row:
            print("{:_<45}: {}".format(key, row[key]))

        # Print CPU kernel info if any
        for cpu_kernel_info in row.cpu_kernel_info:
            for key in cpu_kernel_info:
                print("{:_<45}: {}".format(key, cpu_kernel_info[key]))

        print("=" * 60)
