#
# Copyright (C) 2020 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to read configuration values from cfg files for 
# specific collection.
# ------------------------------------------------------------------------------

import sys
try:
    import advisor
except ImportError:
    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

proj_pth = sys.argv[1]
proj = advisor.open_project(proj_pth)
data = proj.load(advisor.SURVEY)

# cfg_file_name is which .cfg file will be read, like collection.cfg
# By default it is "context_values.cfg"
if len(sys.argv) > 2:
    cfg_file_name = sys.argv[2]
    configs = data.get_cfg_info(advisor.ResultType.Survey, file_name=cfg_file_name)
else:
    configs = data.get_cfg_info(advisor.ResultType.Survey)
for k, v in configs.items():
    print("{:.<60}: {}\n".format(k, v))
