#
# Copyright (C) 2018 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to obtain the memory access count metric for loops.
#
# Metrics are subdivided into three groups by access pattern (const, unit, non
# unit) and each group subdivided by access type (read, write or readwrite).
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:

    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project.
project = advisor.open_project(sys.argv[1])
# Load vectorization data (advisor.VECTORIZATION_DATA is equivalent to advisor.SURVEY | advisor.DEPENDENCIES | advisor.MAP).
# advisor.VECTORIZATION_DATA also loads advisor.RECOMMENDATIONS. We exclude recommendations in order to speed up loading.
data = project.load(advisor.VECTORIZATION_DATA ^ advisor.RECOMMENDATIONS)

# Iteratve over each loop and print the metrics.
for loop in data.map:

    print(
        "constant_accesses: {}\nrandom_accesses: {}\nunit_accesses: {}\nuniform_accesses: {}\n"
        "load_constant_accesses: {}\nload_random_accesses: {}\nload_unit_accesses: {}\nload_uniform_accesses: {}\n"
        "store_constant_accesses: {}\nstore_random_accesses: {}\nstore_unit_accesses: {}\nstore_uniform_accesses: {}\n".format(
            loop["constant_accesses"],
            loop["random_accesses"],
            loop["unit_accesses"],
            loop["uniform_accesses"],
            loop["load_constant_accesses"],
            loop["load_random_accesses"],
            loop["load_unit_accesses"],
            loop["load_uniform_accesses"],
            loop["store_constant_accesses"],
            loop["store_random_accesses"],
            loop["store_unit_accesses"],
            loop["store_uniform_accesses"],
        )
    )

else:

    print("Advisor profile {} does not contain MAP data.".format(sys.argv[1]))
