from apm_helpers.decorator import cached_cls_row_prop
class Platform:
 def __init__(self,args,config,Accelerators):
  self.host=Processor(args,config)
  self.accelerators=[x(args,config)for x in Accelerators]
 def update_accelerators(self,args,config,oa_proj,cfg_loader=None):
  for x in self.accelerators:
   x.init_memory_models(args,config,oa_proj)
   if cfg_loader:
    x.init_baseline_device_configs(args,oa_proj,cfg_loader)
class Processor(object):
 def __init__(self,args,config):
  self.cpu_scale_factor=config.get('cpu_scale_factor',1.0)
  self.ignored_scale_factor=config.get('ignored_scale_factor',self.cpu_scale_factor)
  self.mpi_scale_factor=config.get('mpi_scale_factor',self.ignored_scale_factor)
  self.system_time_scale_factor=config.get('system_time_scale_factor',self.cpu_scale_factor)
  self._times_to_compare={'self_base_time':'self_elapsed_time','total_base_time':'total_elapsed_time','time':'total_elapsed_time',}
 def _self_time(self,row):
  return row['self_time']/self.cpu_scale_factor
 def _self_time_per_largest_thread(self,row):
  return row['self_time_per_largest_thread']/self.cpu_scale_factor
 def _total_time_per_largest_thread(self,row):
  return row['total_time_per_largest_thread']/self.cpu_scale_factor
 def _total_time(self,row):
  return row['total_time']/self.cpu_scale_factor
 def _self_elapsed_time(self,row):
  return row['self_elapsed_time']/self.cpu_scale_factor
 def _total_elapsed_time(self,row):
  return row['total_elapsed_time']/self.cpu_scale_factor
 def _total_time_in_mpi(self,row):
  return row['total_time_in_mpi']/self.mpi_scale_factor
 def _total_time_in_system_modules(self,row):
  return row['total_time_in_system_modules']/self.system_time_scale_factor
 def _total_time_in_ignored(self,row):
  return row['total_time_in_ignored']/self.ignored_scale_factor
 def estimate(self,row):
  res={'total_time':self._total_time(row),'total_elapsed_time':self._total_elapsed_time(row),'self_time':self._self_time(row),'self_elapsed_time':self._self_elapsed_time(row),'total_time_in_system_modules':self._total_time_in_system_modules(row),'total_time_in_mpi':self._total_time_in_mpi(row),'total_time_in_ignored':self._total_time_in_ignored(row),'self_time_per_largest_thread':self._self_time_per_largest_thread(row),'total_time_per_largest_thread':self._total_time_per_largest_thread(row),}
  res.update({k:res[v]for k,v in self._times_to_compare.items()})
  return res
 def generate_estimations(self,top_rows,**kwargs):
  res={}
  stack=top_rows[:]
  while stack:
   curr_row=stack.pop()
   stack+=curr_row.children
   res[curr_row]=self.estimate(curr_row)
  return res
