!===============================================================================
! Copyright (C) 2020 Intel Corporation
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!*
!
!*  Content:
!*            Add example program text (OpenMP offload interface)
!*
!*******************************************************************************/

include "mkl_omp_offload.f90"
include "_vml_common_functions.f90"

! @brief Real single precision function test begin
integer (kind=4) function test_float(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float
    real      (kind=4),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    real      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=4) test_arg1(VLEN)
    integer   (kind=4) test_arg2(VLEN)
    integer   (kind=4) test_ref1(VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'40D9B85C', & ! 6.80375481
                     Z'40B52EFA', & ! 5.66198444
                     Z'4103BA28', & ! 8.2329483
                     Z'C052EA36'  / ! -3.2955451
    data test_arg2 / Z'C007309A', & ! -2.1123414
                     Z'40BF006A', & ! 5.96880054
                     Z'C0C1912F', & ! -6.04897261
                     Z'40ABAABC'  / ! 5.3645916
    data test_ref1 / Z'4096200F', & ! 4.6914134
                     Z'413A17B2', & ! 11.630785
                     Z'400BC642', & ! 2.1839757
                     Z'40046B42'  / ! 2.0690465
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = as_float(test_arg1(i))
        varg2(i) = as_float(test_arg2(i))
        vref1(i) = as_float(test_ref1(i))
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_float(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vsadd(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmsadd(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vsaddi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmsaddi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_float(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float = errs

end function
! @brief Real single precision function test end

! @brief Real double precision function test begin
integer (kind=4) function test_double(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double
    real      (kind=8),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    real      (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=8) test_arg1(VLEN)
    integer   (kind=8) test_arg2(VLEN)
    integer   (kind=8) test_ref1(VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'401B370B60E66E18', & ! 6.80375434309419092
                     Z'4016A5DF421D4BBE', & ! 5.66198447517211711
                     Z'40207744D998EE8A', & ! 8.23294715873568705
                     Z'C00A5D46A314BA8E'  / ! -3.2955448857022196
    data test_arg2 / Z'C000E6134801CC26', & ! -2.11234146361813924
                     Z'4017E00D485FC01A', & ! 5.96880066952146571
                     Z'C0183225E080644C', & ! -6.04897261413232101
                     Z'4015755793FAEAB0'  / ! 5.36459189623808186
    data test_ref1 / Z'4012C401BCE58805', & ! 4.69141287947605168
                     Z'402742F6453E85EC', & ! 11.6307851446935828
                     Z'400178C7A562F190', & ! 2.18397454460336604
                     Z'40008D6884E11AD2'  / ! 2.06904701053586226
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = as_double(test_arg1(i))
        varg2(i) = as_double(test_arg2(i))
        vref1(i) = as_double(test_ref1(i))
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = as_double(test_ref1(i))
            vresi1(i)  = 999
            vmresi1(i) = 999
        else
            vrefi1(i)  = 777
            vresi1(i)  = 777
            vmresi1(i) = 777
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vdadd(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmdadd(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vdaddi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmdaddi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_double(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_double = errs

end function
! @brief Real double precision function test end

! @brief Complex single precision function test begin
integer (kind=4) function test_float_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=4)  :: as_float
    integer   (kind=4)  :: check_result_float_complex
    complex      (kind=4),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    complex      (kind=4),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=4) test_arg1(2*VLEN)
    integer   (kind=4) test_arg2(2*VLEN)
    integer   (kind=4) test_ref1(2*VLEN)
    integer   (kind=4) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'C007309A', Z'40D9B85C', & ! -2.1123414      + i * 6.80375481
                     Z'C0C1912F', Z'4103BA28', & ! -6.04897261     + i * 8.2329483
                     Z'3F8A29C0', Z'C08E3964', & ! 1.07939911      + i * -4.44450569
                     Z'3E8939C0', Z'C02D136C'  / ! 0.268018723     + i * -2.70431042
    data test_arg2 / Z'40BF006A', Z'40B52EFA', & ! 5.96880054      + i * 5.66198444
                     Z'40ABAABC', Z'C052EA36', & ! 5.3645916       + i * -3.2955451
                     Z'4024F46C', Z'BEE77440', & ! 2.57741833      + i * -0.452058792
                     Z'41052EB4', Z'4110B6A8'  / ! 8.32390213      + i * 9.04459381
    data test_ref1 / Z'4076D03A', Z'414773AB', & ! 3.85645914      + i * 12.4657393
                     Z'BF2F3398', Z'409DFF35', & ! -0.684381008    + i * 4.9374032
                     Z'406A094C', Z'C09CB0A8', & ! 3.65681744      + i * -4.89656448
                     Z'41097882', Z'40CAE39A'  / ! 8.59192085      + i * 6.34028339
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_float(test_arg1(2*i-1)), as_float(test_arg1(2*i)), 4)
        varg2(i) = CMPLX(as_float(test_arg2(2*i-1)), as_float(test_arg2(2*i)), 4)
        vref1(i) = CMPLX(as_float(test_ref1(2*i-1)), as_float(test_ref1(2*i)), 4)
        vres1(i) = as_float(nan_value)
        vmres1(i) = as_float(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = CMPLX(as_float(test_ref1(2*i-1)), as_float(test_ref1(2*i)), 4)
            vresi1(i)  = CMPLX(999,999,4)
            vmresi1(i) = CMPLX(999,999,4)
        else
            vrefi1(i)  = CMPLX(777,777,4)
            vresi1(i)  = CMPLX(777,777,4)
            vmresi1(i) = CMPLX(777,777,4)
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vcadd(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmcadd(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vcaddi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmcaddi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_float_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                           vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_float_complex = errs

end function
! @brief Complex single precision function test end

! @brief Complex double precision function test begin
integer (kind=4) function test_double_complex(funcname)

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    character (len = *) :: funcname
    real      (kind=8) :: as_double
    integer   (kind=4) :: check_result_double_complex
    complex   (kind=8),allocatable :: varg1(:), varg2(:), vres1(:), vmres1(:), vref1(:)
    complex   (kind=8),allocatable :: vresi1(:), vmresi1(:), vrefi1(:)
    integer   (kind=4) i, a, errs
    integer   (kind=4) VLEN, VLEN_2
    parameter (VLEN = 4)
    parameter (VLEN_2 = VLEN / 2)
    integer   (kind=8) test_arg1(2*VLEN)
    integer   (kind=8) test_arg2(2*VLEN)
    integer   (kind=8) test_ref1(2*VLEN)
    integer   (kind=8) nan_value
    integer   (kind=8) vml_accuracy_mode(3)
    data vml_accuracy_mode / VML_HA, VML_LA, VML_EP /
    integer   (kind=4) tmode

    ! NaN value to fill result vector
    data  nan_value /Z'FFFFFFFFFFFFFFFF'/

    ! Arguments and reference results begin
    data test_arg1 / Z'C000E6134801CC26', Z'401B370B60E66E18', & ! -2.11234146361813924      + i * 6.80375434309419092
                     Z'C0183225E080644C', Z'40207744D998EE8A', & ! -6.04897261413232101      + i * 8.23294715873568705
                     Z'3FF1453801E28A70', Z'C011C72C86338E59', & ! 1.07939911590861115       + i * -4.44450578393624429
                     Z'3FD12735D3224E60', Z'C005A26D910B44DC'  / ! 0.268018203912310682      + i * -2.70431054416313366
    data test_arg2 / Z'4017E00D485FC01A', Z'4016A5DF421D4BBE', & ! 5.96880066952146571       + i * 5.66198447517211711
                     Z'4015755793FAEAB0', Z'C00A5D46A314BA8E', & ! 5.36459189623808186       + i * -3.2955448857022196
                     Z'40049E8D96893D1C', Z'BFDCEE88B739DD20', & ! 2.57741849523848821       + i * -0.452058962756796134
                     Z'4020A5D666294BAC', Z'402216D5173C2DAA'  / ! 8.32390136007401082       + i * 9.04459450349425609
    data test_ref1 / Z'400EDA0748BDB40E', Z'4028EE755181DCEB', & ! 3.85645920590332647       + i * 12.465738818266308
                     Z'BFE5E672642BCCE0', Z'4013BFE661A77FCD', & ! -0.684380717894239154     + i * 4.93740227303346746
                     Z'400D4129977A8254', Z'C013961511A72C2B', & ! 3.65681761114709936       + i * -4.89656474669304043
                     Z'40212F1014C25E1F', Z'40195C7365F2B8E6'  / ! 8.59191956398632151       + i * 6.34028395933112243
    ! Arguments and reference results end

    errs = 0

    ! Allocate vectors
    allocate(varg1(VLEN))
    allocate(varg2(VLEN))
    allocate(vres1(VLEN))
    allocate(vmres1(VLEN))
    allocate(vref1(VLEN))
    allocate(vresi1(VLEN))
    allocate(vmresi1(VLEN))
    allocate(vrefi1(VLEN))

    ! Fill vectors
    do i = 1, VLEN
        varg1(i) = CMPLX(as_double(test_arg1(2*i-1)), as_double(test_arg1(2*i)), 8)
        varg2(i) = CMPLX(as_double(test_arg2(2*i-1)), as_double(test_arg2(2*i)), 8)
        vref1(i) = CMPLX(as_double(test_ref1(2*i-1)), as_double(test_ref1(2*i)), 8)
        vres1(i) = as_double(nan_value)
        vmres1(i) = as_double(nan_value)

        ! Fill even result values with 777 pads for strided indexing
        if (and(i,1) .eq. 1) then
            vrefi1(i)  = CMPLX(as_double(test_ref1(2*i-1)), as_double(test_ref1(2*i)), 8)
            vresi1(i)  = CMPLX(999,999,8)
            vmresi1(i) = CMPLX(999,999,8)
        else
            vrefi1(i)  = CMPLX(777,777,8)
            vresi1(i)  = CMPLX(777,777,8)
            vmresi1(i) = CMPLX(777,777,8)
        end if
    enddo

    ! Loop by three accuracy flavors
    do a = 1, 3
        ! Call VML function with specific accuracy flavor

        !$omp dispatch 
        tmode = vmlsetmode(vml_accuracy_mode(a))

        !$omp target data map(varg1,varg2,vres1)
        !$omp dispatch 
        call vzadd(VLEN, varg1, varg2, vres1)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmres1)
        !$omp dispatch 
        call vmzadd(VLEN, varg1, varg2, vmres1, vml_accuracy_mode(a))
        !$omp end target data

        !$omp target data map(varg1,varg2,vresi1)
        !$omp dispatch 
        call vzaddi(VLEN_2, varg1, 2, varg2, 2, vresi1, 2)
        !$omp end target data

        !$omp target data map(varg1,varg2,vmresi1)
        !$omp dispatch 
        call vmzaddi(VLEN_2, varg1, 2, varg2, 2, vmresi1, 2, vml_accuracy_mode(a))
        !$omp end target data

        ! Check results
        do i = 1, VLEN
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vres1(i), vres1(i), vref1(i), vref1(i), "v"//funcname, a, ",  simple")
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmres1(i), vmres1(i), vref1(i), vref1(i), "vm"//funcname, a, ",  simple")
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vresi1(i), vresi1(i), vrefi1(i), vrefi1(i), "v"//funcname//"i", a, ", strided")
          errs = errs + check_result_double_complex(i, VML_ARG2_RES1, varg1(i), varg2(i), &
                            vmresi1(i), vmresi1(i), vrefi1(i), vrefi1(i), "vm"//funcname//"i", a, ", strided")
        enddo
    enddo

    test_double_complex = errs

end function
! @brief Complex double precision function test end

! @brief Main test program begin
program add_example

    use onemkl_vml_omp_offload
    implicit none
    include "_vml_common_data.f90"
    integer   (kind=4) :: blend_int32
    integer   (kind=4) :: test_float
    integer   (kind=4) :: test_float_complex
    integer   (kind=4) :: test_double
    integer   (kind=4) :: test_double_complex
    integer   (kind=4) errs, total_errs, exit_status
    character (len = *), parameter :: funcname = "add"

    total_errs = 0

    data FLOAT_MAXULP /FLOAT_MAXULP_HA,FLOAT_MAXULP_LA,FLOAT_MAXULP_EP/
    data COMPLEX_FLOAT_MAXULP /FLOAT_COMPLEX_MAXULP_HA,FLOAT_COMPLEX_MAXULP_LA,FLOAT_COMPLEX_MAXULP_EP/
    data DOUBLE_MAXULP /DOUBLE_MAXULP_HA,DOUBLE_MAXULP_LA,DOUBLE_MAXULP_EP/
    data COMPLEX_DOUBLE_MAXULP /DOUBLE_COMPLEX_MAXULP_HA,DOUBLE_COMPLEX_MAXULP_LA,DOUBLE_COMPLEX_MAXULP_EP/

    write (*, 111) funcname
    111 format ('Running ', A, ' functions:')

    ! Single precision test run begin
    write (*, 112) TAB, funcname
    112 format(A, 'Running ',  A, ' with single precision real data type:')
    errs = test_float(funcname)
    total_errs = total_errs + errs
    write (*, 113) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    113 format(A, A, ' single precision real result: ', A)
    ! Single precision test run end

    ! Real double precision test run begin
    write (*, 117) TAB, funcname
    117 format(A, 'Running ',  A, ' with double precision real data type:')
    errs = test_double(funcname)
    total_errs = total_errs + errs
    write (*, 118) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    118 format(A, A, ' double precision real result: ', A)
    ! Real double precision test run end

    ! Single precision complex test run begin
    write (*, 115) TAB, funcname
    115 format(A, 'Running ',  A, ' with single precision complex data type:')
    errs = test_float_complex(funcname)
    total_errs = total_errs + errs
    write (*, 116) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    116 format(A, A, ' single precision complex result: ', A)
    ! Single precision complex test run end

    ! Complex double precision test run begin
    write (*, 119) TAB, funcname
    119 format(A, 'Running ',  A, ' with double precision complex data type:')
    errs = test_double_complex(funcname)
    total_errs = total_errs + errs
    write (*, 120) TAB, funcname, TEST_RESULT(blend_int32((errs>0),2,1))
    120 format(A, A, ' double precision complex result: ', A)
    ! Complex double precision  test run end

    write (*, 121) funcname, TEST_RESULT(blend_int32((total_errs>0),2,1))
    121 format(A, ' function result: ', A)

    exit_status = 0
    if (total_errs .ne. 0) then
         exit_status = 1
    endif
    stop exit_status
end program
! @brief Main test program end
