/*******************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!    vsRngUniform_64  Example Program Text
!******************************************************************************/

#include <stdio.h>
#include <math.h>

#include "mkl_vsl.h"
#include "errcheck.inc"

#define SEED    1
#define BRNG    VSL_BRNG_PHILOX4X32X10
#define METHOD  VSL_RNG_METHOD_UNIFORM_STD
#define N       10000
#define N_PRINT 10

int main(void)
{
    float* r = (float*)malloc(N * sizeof(float));
    CheckMalloc(r);
    float* r_ref = (float*)malloc(N * sizeof(float));
    CheckMalloc(r_ref);
    VSLStreamStatePtr stream;
    VSLStreamStatePtr stream_ref;
    int errcode = VSL_ERROR_OK, status = 0;
    float a = 0.0f, b = 1.0f;
    int i = 0;


    /***** Initialize *****/
    errcode = vslNewStream( &stream, BRNG,  SEED );
    CheckVslError( errcode );

    errcode = vslNewStream( &stream_ref, BRNG,  SEED );
    CheckVslError( errcode );

    /***** Call RNG *****/
    errcode = vsRngUniform_64( METHOD, stream, N, r, a, b );
    CheckVslError( errcode );


    errcode = vsRngUniform( METHOD, stream_ref, N, r_ref, a, b );
    CheckVslError( errcode );

    /***** Printing results *****/
    printf("Sample of vsRngUniform_64.\n");
    printf("-----------------------\n\n");
    printf("Parameters:\n");
    printf("    a=%.4f\n",a);
    printf("    b=%.4f\n\n",b);

    printf("Results (first 10):\n");
    printf("---------------------------\n");
    for( i = 0; i < N_PRINT; i++ )
    {
        printf("r[%d]=%.4f\n",i,r[i]);
    }

    printf("\n");
    for( i = 0; i < N; i++ )
    {
        if(r[i] != r_ref[i])
        {
            printf("Error at r[%d]=%.4f r_ref[%d]=%.4f\n", i, r[i], i, r_ref[i]);
            status = 1;
            break;
        }
    }

    /***** Deinitialize *****/
    errcode = vslDeleteStream( &stream );
    CheckVslError( errcode );

    errcode = vslDeleteStream( &stream_ref );
    CheckVslError( errcode );

    free(r);
    free(r_ref);

    return status;
}
