/*******************************************************************************
 * Copyright 2018 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

///////////////////////////////////////////////////////////////////////////////
//
//  Content:
//      Wrappers to align with SDL requirements
//
///////////////////////////////////////////////////////////////////////////////

#if !defined(_WIN32) && !defined(_WIN64)

  #include <stdarg.h>

  #include "safestring/safe_str_lib.h"

int vsnprintf_s(char *buf, size_t buf_size, size_t count, const char *fmt, va_list ap)
{
    int rc;
    size_t max_chars_to_write;

    if (fmt == NULL || !(buf != NULL && buf_size > 0)) {
        return -1;
    }

    max_chars_to_write = (buf_size - 1 < count) ? buf_size : count + 1;
    rc = vsnprintf(buf, max_chars_to_write, fmt, ap);
    if (rc < 0) {
        buf[0] = '\0';
        return -1;
    }

    buf[max_chars_to_write - 1] = '\0';

    if (buf_size > count && rc > count) {
        return -1;
    } else if (rc >= buf_size) {
        if (count != _TRUNCATE) {
            buf[0] = '\0';
        }
        return -1;
    }

    return rc;
}

int _vsctprintf(const char *fmt, va_list ap)
{
    int rc;

    va_list arglist;
    va_copy(arglist, ap);
    rc = vsnprintf(NULL, 0, fmt, arglist);
    va_end(arglist);

    return rc;
}

#endif
