/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.nio.Buffer;
import mpi.Comm;
import mpi.Datatype;
import mpi.MPIException;
import mpi.MPIJHelper;
import mpi.Op;

public class Collective {
    public static void allToAll(Buffer buffer, int n, Datatype datatype, Buffer buffer2, int n2, Datatype datatype2, Comm comm) throws MPIException {
        int n3 = 0;
        int n4 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2.isDirect();
        if (!bl) {
            n3 = buffer.arrayOffset();
        }
        if (!bl2) {
            n4 = buffer2.arrayOffset();
        }
        Collective.MPI_Alltoall(buffer, n3, bl, n, datatype.getId(), buffer2, n4, bl2, n2, datatype2.getId(), comm.getHandle());
    }

    public static void allToAll(Object object, int n, Datatype datatype, Object object2, int n2, Datatype datatype2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2);
        Collective.MPI_Alltoall(object, 0, false, n, datatype.getId(), object2, 0, false, n2, datatype2.getId(), comm.getHandle());
    }

    private static native void MPI_Alltoall(Object var0, int var1, boolean var2, int var3, int var4, Object var5, int var6, boolean var7, int var8, int var9, long var10);

    public static void reduce(Buffer buffer, Buffer buffer2, int n, Datatype datatype, Op op, int n2, Comm comm) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2 != null ? buffer2.isDirect() : bl;
        if (!bl) {
            n3 = buffer.arrayOffset();
        }
        if (!bl2 && buffer2 != null) {
            n4 = buffer2.arrayOffset();
        }
        long l = op.isCustom() ? op.getHandle() : (long)op.getId();
        Collective.MPI_Reduce(buffer, n3, bl, buffer2, n4, bl2, n, datatype.getId(), l, op.isCustom(), n2, comm.getHandle());
    }

    public static void reduce(Object object, Object object2, int n, Datatype datatype, Op op, int n2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2);
        long l = op.isCustom() ? op.getHandle() : (long)op.getId();
        Collective.MPI_Reduce(object, 0, false, object2, 0, false, n, datatype.getId(), l, op.isCustom(), n2, comm.getHandle());
    }

    private static native void MPI_Reduce(Object var0, int var1, boolean var2, Object var3, int var4, boolean var5, int var6, int var7, long var8, boolean var10, int var11, long var12);

    public static void bcast(Buffer buffer, int n, Datatype datatype, int n2, Comm comm) throws MPIException {
        int n3 = 0;
        boolean bl = buffer.isDirect();
        if (!bl) {
            n3 = buffer.arrayOffset();
        }
        Collective.MPI_Bcast(buffer, n3, bl, n, datatype.getId(), n2, comm.getHandle());
    }

    public static void bcast(Object object, int n, Datatype datatype, int n2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object);
        Collective.MPI_Bcast(object, 0, false, n, datatype.getId(), n2, comm.getHandle());
    }

    private static native void MPI_Bcast(Object var0, int var1, boolean var2, int var3, int var4, int var5, long var6);

    public static void gather(Buffer buffer, int n, Datatype datatype, Buffer buffer2, int n2, Datatype datatype2, int n3, Comm comm) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2 != null ? buffer2.isDirect() : bl;
        if (!bl) {
            n4 = buffer.arrayOffset();
        }
        if (!bl2 && buffer2 != null) {
            n5 = buffer2.arrayOffset();
        }
        Collective.MPI_Gather(buffer, n4, bl, n, datatype.getId(), buffer2, n5, bl2, n2, datatype2.getId(), n3, comm.getHandle());
    }

    public static void gather(Object object, int n, Datatype datatype, Object object2, int n2, Datatype datatype2, int n3, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2);
        Collective.MPI_Gather(object, 0, false, n, datatype.getId(), object2, 0, false, n2, datatype2.getId(), n3, comm.getHandle());
    }

    private static native void MPI_Gather(Object var0, int var1, boolean var2, int var3, int var4, Object var5, int var6, boolean var7, int var8, int var9, int var10, long var11);

    public static void allGather(Object object, int n, Datatype datatype, Object object2, int n2, Datatype datatype2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2);
        Collective.MPI_Allgather(object, 0, false, n, datatype.getId(), object2, 0, false, n2, datatype2.getId(), comm.getHandle());
    }

    public static void allGather(Buffer buffer, int n, Datatype datatype, Buffer buffer2, int n2, Datatype datatype2, Comm comm) throws MPIException {
        int n3 = 0;
        int n4 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2.isDirect();
        if (!bl) {
            n3 = buffer.arrayOffset();
        }
        if (!bl2) {
            n4 = buffer2.arrayOffset();
        }
        Collective.MPI_Allgather(buffer, n3, bl, n, datatype.getId(), buffer2, n4, bl2, n2, datatype2.getId(), comm.getHandle());
    }

    private static native void MPI_Allgather(Object var0, int var1, boolean var2, int var3, int var4, Object var5, int var6, boolean var7, int var8, int var9, long var10);

    public static void allGatherv(Object object, int n, Datatype datatype, Object object2, Object object3, Object object4, Datatype datatype2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2, object4, object3);
        Collective.MPI_Allgatherv(object, 0, false, n, datatype.getId(), object2, 0, false, object3, object4, datatype2.getId(), comm.getHandle());
    }

    public static void allGatherv(Buffer buffer, int n, Datatype datatype, Buffer buffer2, Buffer buffer3, Buffer buffer4, Datatype datatype2, Comm comm) throws MPIException {
        int n2 = 0;
        int n3 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2.isDirect();
        if (!bl) {
            n2 = buffer.arrayOffset();
        }
        if (!bl2) {
            n3 = buffer2.arrayOffset();
        }
        Collective.MPI_Allgatherv(buffer, n2, bl, n, datatype.getId(), buffer2, n3, bl2, buffer3, buffer4, datatype2.getId(), comm.getHandle());
    }

    private static native void MPI_Allgatherv(Object var0, int var1, boolean var2, int var3, int var4, Object var5, int var6, boolean var7, Object var8, Object var9, int var10, long var11);

    public static void allReduce(Buffer buffer, Buffer buffer2, int n, Datatype datatype, Op op, Comm comm) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2.isDirect();
        if (!bl) {
            n2 = buffer.arrayOffset();
        }
        if (!bl2) {
            n3 = buffer2.arrayOffset();
        }
        Collective.MPI_Allreduce(buffer, n2, bl, buffer2, n3, bl2, n, datatype.getId(), op.getId(), comm.getHandle());
    }

    public static void allReduce(Object object, Object object2, int n, Datatype datatype, Op op, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2);
        Collective.MPI_Allreduce(object, 0, false, object2, 0, false, n, datatype.getId(), op.getId(), comm.getHandle());
    }

    private static native void MPI_Allreduce(Object var0, int var1, boolean var2, Object var3, int var4, boolean var5, int var6, int var7, int var8, long var9);

    public static void allToAllv(Object object, Object object2, Object object3, Datatype datatype, Object object4, Object object5, Object object6, Datatype datatype2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2, object3, object4, object5, object6);
        Collective.MPI_Alltoallv(object, 0, false, object2, object3, datatype.getId(), object4, 0, false, object5, object6, datatype2.getId(), comm.getHandle());
    }

    public static void allToAllv(Buffer buffer, Buffer buffer2, Buffer buffer3, Datatype datatype, Buffer buffer4, Buffer buffer5, Buffer buffer6, Datatype datatype2, Comm comm) throws MPIException {
        int n = 0;
        int n2 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer4.isDirect();
        if (!bl) {
            n = buffer.arrayOffset();
        }
        if (!bl2) {
            n2 = buffer4.arrayOffset();
        }
        Collective.MPI_Alltoallv(buffer, n, bl, buffer2, buffer3, datatype.getId(), buffer4, n2, bl2, buffer5, buffer6, datatype2.getId(), comm.getHandle());
    }

    private static native void MPI_Alltoallv(Object var0, int var1, boolean var2, Object var3, Object var4, int var5, Object var6, int var7, boolean var8, Object var9, Object var10, int var11, long var12);

    public static void gatherv(Buffer buffer, int n, Datatype datatype, Buffer buffer2, Object object, Object object2, Datatype datatype2, int n2, Comm comm) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2 != null ? buffer2.isDirect() : bl;
        if (!bl) {
            n3 = buffer.arrayOffset();
        }
        if (!bl2 && buffer2 != null) {
            n4 = buffer2.arrayOffset();
        }
        Collective.MPI_Gatherv(buffer, n3, bl, n, datatype.getId(), buffer2, n4, bl2, object, object2, datatype2.getId(), n2, comm.getHandle());
    }

    public static void gatherv(Object object, int n, Datatype datatype, Object object2, Object object3, Object object4, Datatype datatype2, int n2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2, object3, object4);
        Collective.MPI_Gatherv(object, 0, false, n, datatype.getId(), object2, 0, false, object3, object4, datatype2.getId(), n2, comm.getHandle());
    }

    private static native void MPI_Gatherv(Object var0, int var1, boolean var2, int var3, int var4, Object var5, int var6, boolean var7, Object var8, Object var9, int var10, int var11, long var12);

    public static void reduceScatter(Buffer buffer, Buffer buffer2, Buffer buffer3, Datatype datatype, Op op, Comm comm) {
        int n = 0;
        int n2 = 0;
        boolean bl = buffer.isDirect();
        boolean bl2 = buffer2.isDirect();
        if (!bl) {
            n = buffer.arrayOffset();
        }
        if (!bl2) {
            n2 = buffer2.arrayOffset();
        }
        Collective.MPI_Reduce_scatter(buffer, n, bl, buffer2, n2, bl2, buffer3, datatype.getId(), op.getId(), comm.getHandle());
    }

    public static void reduceScatter(Object object, Object object2, Object object3, Datatype datatype, Op op, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2, object3);
        Collective.MPI_Reduce_scatter(object, 0, false, object2, 0, false, object3, datatype.getId(), op.getId(), comm.getHandle());
    }

    private static native void MPI_Reduce_scatter(Object var0, int var1, boolean var2, Object var3, int var4, boolean var5, Object var6, int var7, int var8, long var9);

    public static void scatter(Buffer buffer, int n, Datatype datatype, Buffer buffer2, int n2, Datatype datatype2, int n3, Comm comm) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = buffer2.isDirect();
        boolean bl2 = buffer != null ? buffer.isDirect() : bl;
        if (!bl2 && buffer != null) {
            n4 = buffer.arrayOffset();
        }
        if (!bl) {
            n5 = buffer2.arrayOffset();
        }
        Collective.MPI_Scatter(buffer, n4, bl2, n, datatype.getId(), buffer2, n5, bl, n2, datatype2.getId(), n3, comm.getHandle());
    }

    public static void scatter(Object object, int n, Datatype datatype, Object object2, int n2, Datatype datatype2, int n3, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object2);
        Collective.MPI_Scatter(object, 0, false, n, datatype.getId(), object2, 0, false, n2, datatype2.getId(), n3, comm.getHandle());
    }

    private static native void MPI_Scatter(Object var0, int var1, boolean var2, int var3, int var4, Object var5, int var6, boolean var7, int var8, int var9, int var10, long var11);

    public static void scatterv(Buffer buffer, Buffer buffer2, Buffer buffer3, Datatype datatype, Buffer buffer4, int n, Datatype datatype2, int n2, Comm comm) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = buffer4.isDirect();
        boolean bl2 = buffer != null ? buffer.isDirect() : bl;
        if (!bl2 && buffer != null) {
            n3 = buffer.arrayOffset();
        }
        if (!bl) {
            n4 = buffer4.arrayOffset();
        }
        Collective.MPI_Scatterv(buffer, n3, bl2, buffer2, buffer3, datatype.getId(), buffer4, n4, bl, n, datatype2.getId(), n2, comm.getHandle());
    }

    public static void scatterv(Object object, Object object2, Object object3, Datatype datatype, Object object4, int n, Datatype datatype2, int n2, Comm comm) throws MPIException {
        MPIJHelper.checkIfArray(object, object4, object2, object3);
        Collective.MPI_Scatterv(object, 0, false, object2, object3, datatype.getId(), object4, 0, false, n, datatype2.getId(), n2, comm.getHandle());
    }

    private static native void MPI_Scatterv(Object var0, int var1, boolean var2, Object var3, Object var4, int var5, Object var6, int var7, boolean var8, int var9, int var10, int var11, long var12);

    public static void barrier(Comm comm) throws MPIException {
        Collective.MPI_Barrier(comm.getHandle());
    }

    private static native void MPI_Barrier(long var0) throws MPIException;
}

