import '@grafana/ui';
import { OperatorType } from '../types.js';
import { MACROS } from './macros.js';
import '@grafana/data';

function getStandardSQLCompletionProvider(monaco, language) {
  var _a, _b, _c;
  const provider = { triggerCharacters: [".", " ", "$", ",", "(", "'"] };
  if (language && Array.isArray(language.builtinFunctions)) {
    provider.supportedFunctions = () => language.builtinFunctions.map((f) => ({ id: f, name: f }));
  }
  const operators = [];
  if ((_a = language == null ? undefined : language.comparisonOperators) == null ? undefined : _a.length) {
    operators.push(
      ...language.comparisonOperators.map((f) => ({
        id: f.toLocaleLowerCase(),
        operator: f,
        type: OperatorType.Comparison
      }))
    );
  }
  language.logicalOperators = (_b = language.logicalOperators) != null ? _b : language.operators;
  if ((_c = language == null ? undefined : language.logicalOperators) == null ? undefined : _c.length) {
    operators.push(
      ...language.logicalOperators.map((f) => ({ id: f.toLocaleLowerCase(), operator: f, type: OperatorType.Logical }))
    );
  }
  provider.supportedOperators = () => operators;
  provider.supportedMacros = () => MACROS;
  return provider;
}

export { getStandardSQLCompletionProvider };
//# sourceMappingURL=standardSQLCompletionItemProvider.js.map
