import { jsx } from 'react/jsx-runtime';
import { useAsync } from 'react-use';
import '@grafana/data';
import './AwesomeQueryBuilder.js';
import { WhereRow } from './WhereRow.js';
import '../types.js';
import 'lodash';
import { useSqlChange } from '../utils/useSqlChange.js';

function SQLWhereRow({ query, fields, onQueryChange, db }) {
  const state = useAsync(async () => {
    return mapFieldsToTypes(fields);
  }, [fields]);
  const { onSqlChange } = useSqlChange({ query, onQueryChange, db });
  return /* @__PURE__ */ jsx(
    WhereRow,
    {
      config: { fields: state.value || {} },
      sql: query.sql,
      onSqlChange: (val) => {
        onSqlChange(val);
      }
    },
    JSON.stringify(state.value)
  );
}
function mapFieldsToTypes(columns) {
  const fields = {};
  for (const col of columns) {
    fields[col.value] = {
      type: col.raqbFieldType || "text",
      valueSources: ["value"],
      mainWidgetProps: { customProps: { icon: col.icon } }
    };
  }
  return fields;
}

export { SQLWhereRow };
//# sourceMappingURL=SQLWhereRow.js.map
