import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '@grafana/ui';
import { EditorStack } from './EditorStack.js';

const EditorRow = ({ children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: styles.root, children: /* @__PURE__ */ jsx(EditorStack, { gap: 2, children }) });
};
const getStyles = (theme) => {
  return {
    root: css({
      padding: theme.spacing(1),
      backgroundColor: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default
    })
  };
};

export { EditorRow };
//# sourceMappingURL=EditorRow.js.map
